/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.common.header;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.openstack4j.model.common.header.HeaderNameValue;
import org.openstack4j.model.common.header.HeaderOption;
import org.openstack4j.openstack.internal.Parser;

public class IfCondition
implements HeaderOption {
    private String name;
    private Object value;

    protected IfCondition(String name) {
        this.name = name;
    }

    protected IfCondition(String name, Object value) {
        this(name);
        this.value = value;
    }

    public static IfModifiedSince modifiedSince(long milliseconds) {
        return new IfModifiedSince(new Date(milliseconds));
    }

    public static IfUnModifiedSince unModifiedSince(long milliseconds) {
        return new IfUnModifiedSince(new Date(milliseconds));
    }

    public static IfUnModifiedSince unModifiedSince(Date date) {
        return new IfUnModifiedSince(date);
    }

    public static IfModifiedSince modifiedSince(Date date) {
        Preconditions.checkNotNull((Object)date, (Object)"Date must not be null");
        return new IfModifiedSince(date);
    }

    public static IfNoneMatch noneMatch(String matchCondition) {
        Preconditions.checkNotNull((Object)matchCondition, (Object)"Match condition must not be null");
        return new IfNoneMatch(matchCondition);
    }

    public static IfMatch match(String matchValue) {
        Preconditions.checkNotNull((Object)matchValue, (Object)"Match value must not be null");
        return new IfMatch(matchValue);
    }

    @Override
    public HeaderNameValue toHeader() {
        return new HeaderNameValue(this.name, this.value);
    }

    public static class IfMatch
    extends IfCondition {
        private static final String IF_MATCH = "If-Match";

        IfMatch(String matchValue) {
            super(IF_MATCH, matchValue);
        }
    }

    public static class IfNoneMatch
    extends IfCondition {
        private static final String IF_NONE_MATCH = "If-None-Match";

        IfNoneMatch(String condition) {
            super(IF_NONE_MATCH, condition);
        }
    }

    public static class IfUnModifiedSince
    extends IfCondition {
        private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";

        IfUnModifiedSince(Date date) {
            super(IF_UNMODIFIED_SINCE, Parser.toRFC1123(date));
        }
    }

    public static class IfModifiedSince
    extends IfCondition {
        private static final String IF_MODIFIED_SINCE = "If-Modified-Since";

        IfModifiedSince(Date date) {
            super(IF_MODIFIED_SINCE, Parser.toRFC1123(date));
        }
    }
}

