/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.block.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.storage.BlockVolumeTransferService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.storage.block.VolumeTransfer;
import org.openstack4j.openstack.storage.block.domain.CinderVolumeTransfer;
import org.openstack4j.openstack.storage.block.domain.CinderVolumeTransferAccept;
import org.openstack4j.openstack.storage.block.internal.BaseBlockStorageServices;

public class BlockVolumeTransferServiceImpl
extends BaseBlockStorageServices
implements BlockVolumeTransferService {
    @Override
    public List<? extends VolumeTransfer> list() {
        return this.list(Boolean.TRUE);
    }

    @Override
    public List<? extends VolumeTransfer> list(boolean detailed) {
        String url = detailed ? "/os-volume-transfer/detail" : "/os-volume-transfer";
        return this.get(CinderVolumeTransfer.VolumeTransferList.class, url).execute().getList();
    }

    @Override
    public VolumeTransfer get(String transferId) {
        Preconditions.checkNotNull((Object)transferId, (Object)"TransferId must contain a value");
        return this.get(CinderVolumeTransfer.class, this.uri("/os-volume-transfer/%s", transferId)).execute();
    }

    @Override
    public VolumeTransfer create(String volumeId) {
        return this.create(volumeId, null);
    }

    @Override
    public VolumeTransfer create(String volumeId, String name) {
        Preconditions.checkNotNull((Object)volumeId, (Object)"VolumeId must contain a value");
        return this.post(CinderVolumeTransfer.class, "/os-volume-transfer").entity(CinderVolumeTransfer.create(volumeId, name)).execute();
    }

    @Override
    public VolumeTransfer accept(String transferId, String authKey) {
        Preconditions.checkNotNull((Object)transferId, (Object)"TransferId must contain a value");
        Preconditions.checkNotNull((Object)authKey, (Object)"AuthKey must contain a value");
        return this.post(CinderVolumeTransfer.class, this.uri("/os-volume-transfer/%s/accept", transferId)).entity(CinderVolumeTransferAccept.create(authKey)).execute();
    }

    @Override
    public ActionResponse delete(String transferId) {
        Preconditions.checkNotNull((Object)transferId, (Object)"TransferId must contain a value");
        return this.delete(ActionResponse.class, this.uri("/os-volume-transfer/%s", transferId)).execute();
    }
}

