/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.api;

import java.util.ServiceLoader;
import org.openstack4j.api.APIProvider;
import org.openstack4j.api.artifact.ArtifactService;
import org.openstack4j.api.barbican.BarbicanService;
import org.openstack4j.api.compute.ComputeService;
import org.openstack4j.api.dns.v2.DNSService;
import org.openstack4j.api.gbp.GbpService;
import org.openstack4j.api.heat.HeatService;
import org.openstack4j.api.identity.v2.IdentityService;
import org.openstack4j.api.image.ImageService;
import org.openstack4j.api.magnum.MagnumService;
import org.openstack4j.api.manila.ShareService;
import org.openstack4j.api.murano.v1.AppCatalogService;
import org.openstack4j.api.networking.NetworkingService;
import org.openstack4j.api.octavia.OctaviaService;
import org.openstack4j.api.sahara.SaharaService;
import org.openstack4j.api.senlin.SenlinService;
import org.openstack4j.api.tacker.TackerService;
import org.openstack4j.api.trove.TroveService;
import org.openstack4j.api.workflow.WorkflowService;

public class Apis {
    private static final APIProvider provider = Apis.initializeProvider();

    public static <T> T get(Class<T> api) {
        return provider.get(api);
    }

    public static org.openstack4j.api.identity.v3.IdentityService getIdentityV3Services() {
        return Apis.get(org.openstack4j.api.identity.v3.IdentityService.class);
    }

    public static IdentityService getIdentityV2Services() {
        return Apis.get(IdentityService.class);
    }

    public static ComputeService getComputeServices() {
        return Apis.get(ComputeService.class);
    }

    public static NetworkingService getNetworkingServices() {
        return Apis.get(NetworkingService.class);
    }

    public static OctaviaService getOctaviaService() {
        return Apis.get(OctaviaService.class);
    }

    public static ArtifactService getArtifactServices() {
        return Apis.get(ArtifactService.class);
    }

    public static TackerService getTackerServices() {
        return Apis.get(TackerService.class);
    }

    public static ImageService getImageService() {
        return Apis.get(ImageService.class);
    }

    public static org.openstack4j.api.image.v2.ImageService getImageV2Service() {
        return Apis.get(org.openstack4j.api.image.v2.ImageService.class);
    }

    public static HeatService getHeatServices() {
        return Apis.get(HeatService.class);
    }

    public static AppCatalogService getMuranoServices() {
        return Apis.get(AppCatalogService.class);
    }

    public static SaharaService getSaharaServices() {
        return Apis.get(SaharaService.class);
    }

    public static WorkflowService getWorkflowServices() {
        return Apis.get(WorkflowService.class);
    }

    public static ShareService getShareServices() {
        return Apis.get(ShareService.class);
    }

    public static GbpService getGbpServices() {
        return Apis.get(GbpService.class);
    }

    public static TroveService getTroveServices() {
        return Apis.get(TroveService.class);
    }

    public static SenlinService getSenlinServices() {
        return Apis.get(SenlinService.class);
    }

    public static MagnumService getMagnumService() {
        return Apis.get(MagnumService.class);
    }

    public static BarbicanService getBarbicanServices() {
        return Apis.get(BarbicanService.class);
    }

    public static DNSService getDNSService() {
        return Apis.get(DNSService.class);
    }

    private static APIProvider initializeProvider() {
        APIProvider p = ServiceLoader.load(APIProvider.class, Apis.class.getClassLoader()).iterator().next();
        p.initialize();
        return p;
    }
}

