/****************************************************************************/
/* GF85 ( 移行DB対応明細 )                                                  */
/*                                                                          */
/* Created : 2019/09/02 09:36:21                                            */
/****************************************************************************/
CREATE TABLE GF85 (
   SYSTEM_ID    VARCHAR2 (   10 )                   NOT NULL            /*  10 ｼｽﾃﾑID       */
 , TBLSYU       VARCHAR2 (    1 )                   NOT NULL            /*  20 ﾃｰﾌﾞﾙ種別    */
 , TABLE_NAME   VARCHAR2 (   50 )                   NOT NULL            /*  30 ﾃｰﾌﾞﾙ名      */
 , CLM          VARCHAR2 (   30 )                   NOT NULL            /*  40 項目         */
 , SEQNO        NUMBER   (    7 )       DEFAULT 0   NOT NULL            /*  50 表示順       */
 , NAME_JA      VARCHAR2 (  200 )                                       /*  60 名称         */
 , CLS_NAME     VARCHAR2 (   10 )                   NOT NULL            /*  70 DBｸﾗｽ        */
 , USE_LENGTH   VARCHAR2 (    9 )                                       /*  80 使用桁数     */
 , DATA_DEFAULT VARCHAR2 (  200 )                                       /*  90 初期値       */
 , NOT_NULL     VARCHAR2 (    1 )                                       /* 100 ﾉｯﾄﾇﾙ        */
 , FGCOM        VARCHAR2 (    1 )       DEFAULT '0' NOT NULL            /* 110 共通項目F    */
 , BIKO         VARCHAR2 ( 2000 )                                       /* 120 備考         */
 , NOJUN        NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 130 対応順       */
 , CONV_FUNC    VARCHAR2 (  500 )                                       /* 140 変換関数     */
 , F_CONST      VARCHAR2 (  200 )                                       /* 150 元固定値     */
 , F_SYSTEM_ID  VARCHAR2 (   10 )                                       /* 160 元ｼｽﾃﾑID     */
 , F_TABLE_NAME VARCHAR2 (   50 )                                       /* 170 元ﾃｰﾌﾞﾙ名    */
 , F_CLM        VARCHAR2 (   30 )                                       /* 180 元項目       */
 , F_SEQNO      NUMBER   (    7 )       DEFAULT 0   NOT NULL            /* 190 元表示順     */
 , F_NAME_JA    VARCHAR2 (  200 )                                       /* 200 元名称       */
 , F_CLS_NAME   VARCHAR2 (   10 )                                       /* 210 元DBｸﾗｽ      */
 , F_USE_LENGTH VARCHAR2 (    9 )                                       /* 220 元使用桁数   */
 , F_BIKO       VARCHAR2 ( 2000 )                                       /* 230 元備考       */
 , DESCRIPTION  VARCHAR2 ( 4000 )                                       /* 240 概要説明     */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET        VARCHAR2 (   14 )                                       /* 820 登録日時     */
 , PGSET        VARCHAR2 (   10 )                                       /* 830 作成PG       */
 , PGPSET       VARCHAR2 (   10 )                                       /* 840 作成親PG     */
 , USRSET       VARCHAR2 (   10 )                                       /* 850 作成社員     */
 , DYUPD        VARCHAR2 (   14 )                                       /* 860 更新日時     */
 , PGUPD        VARCHAR2 (   10 )                                       /* 870 更新PG       */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 880 更新親PG     */
 , USRUPD       VARCHAR2 (   10 )                                       /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K );

CREATE SEQUENCE GF85S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF85T00 
  BEFORE INSERT ON GF85
  FOR EACH ROW 
  BEGIN 
    SELECT GF85S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
