<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9400"
	title	= "標準(PLSQL)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck  command = "{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		SELECT	(CASE KBSAKU WHEN '0' THEN 0 ELSE 1 END) AS WRITABLE	<!-- 書込制御 -->
				,SYSTEM_ID												<!-- ｼｽﾃﾑID -->
				,LANG													<!-- 言語 -->
				,CLM													<!-- 項目 -->
				,NAME_JA												<!-- 名称(漢字) -->
				,LABEL_NAME												<!-- 表示名称 -->
				,KBSAKU													<!-- 作成区分 -->
				,CDTAN													<!-- 担当者 -->
				,UNIQ													<!-- (非表示)ﾕﾆｰｸ -->
		FROM	GF41
	<og:where>
		<og:and value = "FGJ        IN   ('0','1')"        />			<!-- GF41》状態F      IN   ('0','1') -->
		<og:and value = "SYSTEM_ID  =    '{@SYSTEM_ID}'"   />			<!-- GF41》ｼｽﾃﾑID     ＝   画面》ｼｽﾃﾑID-->
		<og:and value = "LANG       =    '{@LANG}'"        />			<!-- GF41》言語       ＝   画面》言語-->
		<og:and value = "CLM        LIKE '{@CLM}%'"        />			<!-- GF41》項目       LIKE 画面》項目-->
		<og:and value = "NAME_JA    LIKE '{@NAME_JA}%'"    />			<!-- GF41》名称(漢字) LIKE 画面》名称(漢字) -->
		<og:and value = "LABEL_NAME LIKE '{@LABEL_NAME}%'" />			<!-- GF41》表示名称   LIKE 画面》表示名称 -->
		<og:and value = "KBSAKU     =    '{@KBSAKU}'"      />			<!-- GF41》作成区分   ＝   画面》作成区分 -->
	</og:where>
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:columnEditor columns="SYSTEM_ID,LANG,CLM" must="true" />

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GF9000" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,LANG,CLM,KBSAKU,IMAGE"
		vals="NEW,{@SYSTEM_ID},[LANG],[CLM],[KBSAKU],true" />
</og:viewLink>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<!-- ここでは、すべてを、update.jsp に転送している為、command属性を設定しています。-->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "HTMLTable" 
	command      = "{@command}" 
	noDisplay    = "UNIQ"
	noWritable   = "SYSTEM_ID,LANG,CLM"
	writable     = "true"
	checked      = "true"/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
