/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyPair;

public final class CloudStorageConfig
implements Cloneable {
    private String serviceName;
    private URL serviceUrl;
    private String user;
    private char[] creds = null;
    private KeyPair keyPair;
    private String provider;
    private int chunkSize;
    private String httpProxyUri;
    private int connectTimeout = -1;
    private int readTimeout = -1;
    private String logFilter;
    private String authProvider;
    private String servicePrefix;
    private boolean newestCopyRetrievalEnabled;

    public String getServiceName() {
        return this.serviceName;
    }

    public CloudStorageConfig setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public URL getServiceUrl() {
        return this.serviceUrl;
    }

    public CloudStorageConfig setServiceUrl(String serviceUrl) throws MalformedURLException {
        this.serviceUrl = new URL(serviceUrl);
        return this;
    }

    public CloudStorageConfig setServiceUrl(URL url) {
        this.serviceUrl = url;
        return this;
    }

    public String getUsername() {
        return this.user;
    }

    public CloudStorageConfig setUsername(String user) {
        this.user = user;
        return this;
    }

    public CloudStorageConfig setPassword(char[] pass) {
        char[] copy = (char[])pass.clone();
        this.creds = copy;
        return this;
    }

    public char[] getPassword() {
        char[] copy = this.creds;
        return copy;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public CloudStorageConfig setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public String getHttpProxyUri() {
        return this.httpProxyUri;
    }

    public void setHttpProxyUri(String httpProxyUri) {
        this.httpProxyUri = httpProxyUri;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public CloudStorageConfig setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public CloudStorageConfig setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public String getLogFilter() {
        return this.logFilter;
    }

    public CloudStorageConfig setLogFilter(String logFilter) {
        this.logFilter = logFilter;
        return this;
    }

    public String getAuthProvider() {
        return this.authProvider;
    }

    public CloudStorageConfig setAuthProvider(String authProvider) {
        this.authProvider = authProvider;
        return this;
    }

    public String getServicePrefix() {
        return this.servicePrefix;
    }

    public CloudStorageConfig setServicePrefix(String servicePrefix) {
        this.servicePrefix = servicePrefix;
        return this;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public CloudStorageConfig setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public String getProvider() {
        return this.provider;
    }

    public CloudStorageConfig setProvider(String name) {
        this.provider = name;
        return this;
    }

    public boolean isNewestCopyRetrievalEnabled() {
        return this.newestCopyRetrievalEnabled;
    }

    public void setNewestCopyRetrievalEnabled(boolean newestCopyRetrievalEnabled) {
        this.newestCopyRetrievalEnabled = newestCopyRetrievalEnabled;
    }

    public CloudStorageConfig clone() {
        CloudStorageConfig copy = new CloudStorageConfig();
        copy.authProvider = this.authProvider;
        copy.chunkSize = this.chunkSize;
        copy.httpProxyUri = this.httpProxyUri;
        copy.connectTimeout = this.connectTimeout;
        copy.readTimeout = this.readTimeout;
        copy.creds = (char[])this.creds.clone();
        copy.keyPair = this.keyPair;
        copy.logFilter = this.logFilter;
        copy.provider = this.provider;
        copy.serviceName = this.serviceName;
        copy.serviceUrl = this.serviceUrl;
        copy.servicePrefix = this.servicePrefix;
        copy.user = this.user;
        copy.newestCopyRetrievalEnabled = this.newestCopyRetrievalEnabled;
        return copy;
    }
}

