/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import oracle.cloudstorage.api.UserProperties;
import oracle.cloudstorage.api.UserPropertyKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserProperties
extends UserProperties {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUserProperties.class);
    private static final String defaultPropertiesDir = "/etc/oracle/cloudstorage";
    protected static final String defaultPropertiesFilename = "user.properties";
    public static final String propertiesFileKey = UserPropertyKeys.class.getPackage().getName() + ".userPropertiesFile";

    public DefaultUserProperties() {
        this(defaultPropertiesFilename);
    }

    public DefaultUserProperties(String defaultPropertiesFilename) {
        super(new Properties());
        String msg = DefaultUserProperties.load(defaultPropertiesFilename, this.getProperties());
        logger.warn(msg);
    }

    public static String load(String defaultPropertiesFilename, Properties properties) {
        String env = System.getProperty(UserPropertyKeys.env);
        StringBuilder msg = new StringBuilder("System propertes:").append("\n  ").append(propertiesFileKey);
        String path = System.getProperty(propertiesFileKey);
        if (path == null || path.trim().isEmpty()) {
            path = defaultPropertiesFilename;
            msg.append(" was not set, using ").append(defaultPropertiesFilename);
        } else {
            msg.append(" set to ").append(path);
        }
        msg.append("\n  ").append(UserPropertyKeys.env).append(" is ").append(env);
        String loaded = DefaultUserProperties.load(null, msg, new File(path), properties);
        loaded = DefaultUserProperties.load(null, msg, new File(defaultPropertiesDir, path), properties);
        InputStream resource = ClassLoader.getSystemResourceAsStream(path);
        if (resource == null) {
            msg.append("\n    ").append("No classpath resource ").append(path).append(".");
        } else {
            if (loaded == null) {
                try {
                    properties.load(resource);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                loaded = "classpath resource " + path;
            } else {
                msg.append("\n    ").append("Classpath resource ").append(path).append(" ignored, properties already loaded from ").append(loaded).append(".");
            }
            try {
                resource.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (env != null) {
            properties.setProperty(UserPropertyKeys.env, env);
        }
        if (loaded == null) {
            throw new IllegalArgumentException(msg.insert(0, "No user properties found.\n").toString());
        }
        env = properties.getProperty(UserPropertyKeys.env);
        msg.append("\nLoaded ").append(loaded).append(" with env ");
        if (env == null || env.trim().isEmpty()) {
            msg.append("unset.");
        } else {
            msg.append("set to '").append(env).append("'.");
        }
        return msg.toString();
    }

    private static String load(String loaded, StringBuilder msg, File file, Properties properties) {
        if (!file.exists()) {
            msg.append("\n    ").append(file.getPath()).append(" does not exist.");
            return loaded;
        }
        if (!file.isFile()) {
            msg.append("\n    ").append(file.getPath()).append(" is not a file.");
            return loaded;
        }
        if (!file.canRead()) {
            msg.append("\n    ").append(file.getPath()).append(" cannot be read.");
            return loaded;
        }
        if (loaded != null) {
            msg.append("\n    ").append(file.getPath()).append(" ignored, properties already loaded from " + loaded + ".");
            return loaded;
        }
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            properties.load(reader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file.getPath();
    }
}

