/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.StringUtil;

public final class FileUtil {
    public static final int STABLE_SLEEP_TIME = 2000;
    public static final int STABLE_RETRY_COUNT = 10;
    public static final int LOCK_SLEEP_TIME = 2000;
    public static final int LOCK_RETRY_COUNT = 10;
    public static final Charset WINDOWS_31J = Charset.forName("Windows-31J");
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final OpenOption[] CREATE = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final OpenOption[] APPEND = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND};
    private static final Object STATIC_LOCK = new Object();
    private static final FileVisitor<Path> DELETE_VISITOR = new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            Files.deleteIfExists(path);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
            if (iOException == null) {
                Files.deleteIfExists(path);
                return FileVisitResult.CONTINUE;
            }
            throw iOException;
        }
    };

    private FileUtil() {
    }

    public static Path readPath(String string, String ... stringArray) {
        Path path = Paths.get(string, stringArray).toAbsolutePath().normalize();
        if (!Files.exists(path, new LinkOption[0])) {
            throw MsgUtil.throwException("MSG0002", path);
        }
        return path;
    }

    public static Path writePath(String string, String ... stringArray) {
        Path path = Paths.get(string, stringArray).toAbsolutePath().normalize();
        FileUtil.mkdirs(path);
        return path;
    }

    public static Path newPath(Path path, String string) {
        if (string == null || string.isEmpty()) {
            return path;
        }
        if (FileUtil.isAbsolute(string)) {
            return new File(string).toPath();
        }
        return path.resolve(string);
    }

    public static boolean isAbsolute(String string) {
        return string != null && (string.charAt(0) == '/' || string.charAt(0) == '\\' || string.length() > 1 && string.charAt(1) == ':');
    }

    public static void mkdirs(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            Path path2;
            Path path3 = path.getFileName();
            if (path3 == null) {
                throw MsgUtil.throwException("MSG0007", path.toString());
            }
            boolean bl = path3.toString().contains(".");
            Path path4 = path2 = bl ? path.getParent() : path;
            if (path2 == null) {
                throw MsgUtil.throwException("MSG0007", path.toString());
            }
            if (Files.notExists(path2, new LinkOption[0])) {
                try {
                    Files.createDirectories(path2, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    throw MsgUtil.throwException(iOException, "MSG0007", path2);
                }
            }
        }
    }

    public static void copy(Path path, Path path2) {
        FileUtil.copy(path, path2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Path path, Path path3, boolean bl) {
        if (Files.exists(path, new LinkOption[0])) {
            FileUtil.mkdirs(path3);
            Path path4 = path3.getFileName();
            if (path4 == null) {
                throw MsgUtil.throwException("MSG0008", path.toString(), path3.toString());
            }
            boolean bl2 = path4.toString().contains(".");
            Path path5 = bl2 ? path3 : path3.resolve(path.getFileName());
            Object object = STATIC_LOCK;
            synchronized (object) {
                if (bl) {
                    FileUtil.lockPath(path, path2 -> FileUtil.localCopy(path2, path5));
                } else {
                    FileUtil.localCopy(path, path5);
                }
            }
        } else {
            MsgUtil.errPrintln("MSG0002", path);
        }
    }

    private static void localCopy(Path path, Path path2) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException iOException) {
            MsgUtil.errPrintln(iOException, "MSG0012", path, path2);
        }
    }

    public static void move(Path path, Path path2) {
        FileUtil.move(path, path2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void move(Path path, Path path3, boolean bl) {
        if (path == null || path3 == null) {
            return;
        }
        if (Files.exists(path, new LinkOption[0])) {
            FileUtil.mkdirs(path3);
            Path path4 = path3.getFileName();
            if (path4 == null) {
                throw MsgUtil.throwException("MSG0008", path3.toString());
            }
            boolean bl2 = path4.toString().contains(".");
            Path path5 = bl2 ? path3 : path3.resolve(path.getFileName());
            Object object = STATIC_LOCK;
            synchronized (object) {
                if (bl) {
                    FileUtil.lockPath(path, path2 -> FileUtil.localMove(path2, path5));
                } else {
                    FileUtil.localMove(path, path5);
                }
            }
        } else {
            MsgUtil.errPrintln("MSG0002", path);
        }
    }

    private static void localMove(Path path, Path path2) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException iOException) {
            MsgUtil.errPrintln(iOException, "MSG0008", path, path2);
        }
    }

    public static Path backup(Path path, Path path2, String string) {
        return FileUtil.backup(path, path2, true, false, string);
    }

    public static Path backup(Path path, Path path2) {
        return FileUtil.backup(path, path2, true, true, null);
    }

    public static Path backup(Path path, Path path2, boolean bl, boolean bl2, String string) {
        String string2;
        int n;
        Path path3;
        Path path4 = path3 = path2 == null ? path.getParent() : path2;
        if (path3 == null) {
            throw MsgUtil.throwException("MSG0007", path.toString());
        }
        Path path5 = path.getFileName();
        if (path5 == null) {
            throw MsgUtil.throwException("MSG0002", path.toString());
        }
        Path path6 = path3.resolve(path5);
        Path path7 = bl2 && Files.notExists(path6, new LinkOption[0]) ? path6 : ((n = (string2 = path5.toString()).lastIndexOf(46)) > 0 ? path3.resolve(string2.substring(0, n) + "_" + StringUtil.nval(string, StringUtil.getTimeFormat()) + string2.substring(n)) : null);
        FileUtil.move(path, path7, bl);
        return path7;
    }

    public static void delete(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.walkFileTree(path, DELETE_VISITOR);
            }
        }
        catch (IOException iOException) {
            throw MsgUtil.throwException(iOException, "MSG0011", path);
        }
    }

    public static boolean stablePath(Path path) {
        return FileUtil.stablePath(path, 2000L, 10);
    }

    public static boolean stablePath(Path path, long l, int n) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                for (int i = 0; i < n; ++i) {
                    if (Files.notExists(path, new LinkOption[0])) {
                        return false;
                    }
                    long l2 = Files.size(path);
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (Files.notExists(path, new LinkOption[0])) {
                        return false;
                    }
                    long l3 = Files.size(path);
                    if (l2 == 0L || l2 != l3) continue;
                    return true;
                }
            }
            catch (IOException iOException) {
                MsgUtil.errPrintln(iOException, "MSG0005", path);
            }
        }
        return false;
    }

    public static void lockPath(Path path, Consumer<Path> consumer) {
        if (Files.exists(path, new LinkOption[0])) {
            try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);){
                for (int i = 0; i < 10; ++i) {
                    try {
                        if (fileChannel.tryLock(0L, Long.MAX_VALUE, true) != null) {
                            consumer.accept(path);
                            return;
                        }
                    }
                    catch (OverlappingFileLockException overlappingFileLockException) {
                        System.err.println(overlappingFileLockException.getMessage());
                    }
                    try {
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (IOException iOException) {
                throw MsgUtil.throwException(iOException, "MSG0005", path);
            }
            MsgUtil.errPrintln("MSG0015", path, 2000, 10);
        }
    }

    public static void forEach(Path path, Consumer<String> consumer) {
        FileUtil.forEach(path, UTF_8, consumer);
    }

    public static void forEach(Path path, Charset charset, Consumer<String> consumer) {
        if (Files.exists(path, new LinkOption[0])) {
            String string = null;
            int n = 0;
            try (FileInputStream fileInputStream = new FileInputStream(path.toFile());
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                while ((string = bufferedReader.readLine()) != null) {
                    consumer.accept(string);
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw MsgUtil.throwException(iOException, "MSG0016", path, n, string);
            }
        }
    }

    public static void lockForEach(Path path2, Consumer<String> consumer) {
        FileUtil.lockPath(path2, path -> FileUtil.forEach(path, UTF_8, consumer));
    }

    public static void lockForEach(Path path2, Charset charset, Consumer<String> consumer) {
        FileUtil.lockPath(path2, path -> FileUtil.forEach(path, charset, consumer));
    }

    public static void save(Path path, List<String> list) {
        FileUtil.save(path, list, false, UTF_8);
    }

    public static void save(Path path, List<String> list, boolean bl, Charset charset) {
        Path path2 = path.getParent();
        if (path2 == null) {
            throw MsgUtil.throwException("MSG0007", path.toString());
        }
        FileUtil.mkdirs(path2);
        String string = null;
        int n = 0;
        try (PrintWriter printWriter = new PrintWriter(Files.newBufferedWriter(path, charset, bl ? APPEND : CREATE));){
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2;
                string = string2 = iterator.next();
                ++n;
                printWriter.println(string);
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            throw MsgUtil.throwException(iOException, "MSG0017", path, n, string);
        }
    }

    public static String timeStamp(Path path, String string) {
        long l = 0L;
        try {
            if (Files.exists(path, new LinkOption[0])) {
                l = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            }
        }
        catch (IOException iOException) {
            MsgUtil.errPrintln(iOException, "MSG0018", path, iOException.getMessage());
        }
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        return StringUtil.getTimeFormat(l, string);
    }
}

