/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.List;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.Layer;
import org.opengion.hayabusa.io.ChartCreate;
import org.opengion.hayabusa.io.ChartDataset;
import org.opengion.hayabusa.io.ChartPlot;
import org.opengion.hayabusa.io.HybsCategoryPlot;
import org.opengion.hayabusa.io.HybsURLGenerator;

public class ChartPlot_Category
implements ChartPlot {
    private static final BasicStroke DOT_LINE = new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{10.0f, 6.0f}, 0.0f);

    @Override
    public Plot getPlot(ChartCreate chartCreate) {
        int n = chartCreate.getSeriesPikup();
        HybsCategoryPlot hybsCategoryPlot = chartCreate.makeCategoryPlot();
        HybsURLGenerator hybsURLGenerator = chartCreate.getURLGenerator();
        boolean bl = chartCreate.isUseToolTip();
        List<ChartDataset> list = chartCreate.getDatasetList();
        for (int i = 0; i < list.size(); ++i) {
            int n2;
            ChartDataset chartDataset = list.get(i);
            CategoryDataset categoryDataset = (CategoryDataset)chartDataset.getDataset();
            int n3 = categoryDataset.getRowCount();
            hybsCategoryPlot.setDataset(i, categoryDataset);
            CategoryAxis categoryAxis = chartCreate.makeCategoryAxis();
            hybsCategoryPlot.setDomainAxis(i, categoryAxis, false);
            if (i > 0) {
                categoryAxis.setVisible(false);
            }
            CategoryItemRenderer categoryItemRenderer = chartDataset.getRenderer(n, hybsURLGenerator);
            hybsCategoryPlot.setRenderer(i, categoryItemRenderer, false);
            NumberAxis numberAxis = chartDataset.makeNumberAxis();
            hybsCategoryPlot.setRangeAxis(i, (ValueAxis)numberAxis, false);
            ValueMarker[] valueMarkerArray = chartDataset.getValueMarkers();
            for (int j = 0; j < valueMarkerArray.length; ++j) {
                hybsCategoryPlot.addRangeMarker(i, (Marker)valueMarkerArray[j], Layer.FOREGROUND);
            }
            String string = chartDataset.getBarWidth();
            if (string != null) {
                hybsCategoryPlot.setBarWidth(i, Double.valueOf(string));
            }
            Color[] colorArray = chartDataset.getSeriesColors();
            if (n < 0 && colorArray != null && colorArray.length > 0) {
                n2 = colorArray.length;
                for (int j = 0; j < n3; ++j) {
                    categoryItemRenderer.setSeriesPaint(j, (Paint)colorArray[j % n2]);
                }
            }
            if (n >= 0 && n < n3) {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (n2 == n) continue;
                    categoryItemRenderer.setSeriesPaint(n2, (Paint)Color.CYAN);
                }
                categoryItemRenderer.setSeriesPaint(n, (Paint)Color.RED);
            }
            if (chartDataset.isUseGradient()) {
                for (n2 = 0; n2 < n3; ++n2) {
                    Color color = (Color)categoryItemRenderer.getSeriesPaint(n2);
                    if (color == null) continue;
                    Color color2 = color.brighter().brighter();
                    Color color3 = color.darker().darker();
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color2, 0.0f, 0.0f, color3);
                    categoryItemRenderer.setSeriesPaint(n2, (Paint)gradientPaint);
                }
            }
            if (chartDataset.isUseDottedLine()) {
                for (n2 = 0; n2 < n3; ++n2) {
                    categoryItemRenderer.setSeriesStroke(n2, (Stroke)DOT_LINE);
                }
            }
            if (!bl) continue;
            categoryItemRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        return hybsCategoryPlot;
    }
}

