/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.StringUtil;
import org.opengion.fukurou.fileexec.XLogger;

public final class FileUtil {
    private static final XLogger LOGGER = XLogger.getLogger(FileUtil.class.getSimpleName());
    public static final int STABLE_SLEEP_TIME = 2000;
    public static final int STABLE_RETRY_COUNT = 10;
    public static final int LOCK_SLEEP_TIME = 2000;
    public static final int LOCK_RETRY_COUNT = 10;
    public static final Charset WINDOWS_31J = Charset.forName("Windows-31J");
    private static final OpenOption[] CREATE = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final OpenOption[] APPEND = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND};
    private static final Object STATIC_LOCK = new Object();
    private static final FileVisitor<Path> DELETE_VISITOR = new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            Files.deleteIfExists(path);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
            if (iOException == null) {
                Files.deleteIfExists(path);
                return FileVisitResult.CONTINUE;
            }
            throw iOException;
        }
    };

    private FileUtil() {
    }

    public static Path readPath(String string, String ... stringArray) {
        Path path = Paths.get(string, stringArray).toAbsolutePath().normalize();
        if (!FileUtil.exists(path)) {
            String string2 = "FileUtil#readPath : Path=" + path;
            throw MsgUtil.throwException("MSG0002", string2);
        }
        return path;
    }

    public static Path writePath(String string, String ... stringArray) {
        Path path = Paths.get(string, stringArray).toAbsolutePath().normalize();
        FileUtil.mkdirs(path);
        return path;
    }

    public static Path newPath(Path path, String string) {
        if (string == null || string.isEmpty()) {
            return path;
        }
        if (FileUtil.isAbsolute(string)) {
            return new File(string).toPath();
        }
        return path.resolve(string);
    }

    public static boolean isAbsolute(String string) {
        return string != null && !string.isEmpty() && (string.charAt(0) == '/' || string.charAt(0) == '\\' || string.length() > 1 && string.charAt(1) == ':');
    }

    public static void mkdirs(Path path) {
        if (!FileUtil.exists(path)) {
            Path path2;
            Path path3 = path.getFileName();
            if (path3 == null) {
                throw MsgUtil.throwException("MSG0007", path.toString());
            }
            boolean bl = path3.toString().contains(".");
            Path path4 = path2 = bl ? path.getParent() : path;
            if (path2 == null) {
                throw MsgUtil.throwException("MSG0007", path.toString());
            }
            if (!FileUtil.exists(path2)) {
                try {
                    Files.createDirectories(path2, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    throw MsgUtil.throwException(iOException, "MSG0007", path2);
                }
            }
        }
    }

    public static void copy(Path path, Path path2) {
        FileUtil.copy(path, path2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Path path, Path path3, boolean bl) {
        if (FileUtil.exists(path)) {
            FileUtil.mkdirs(path3);
            Path path4 = path3.getFileName();
            if (path4 == null) {
                throw MsgUtil.throwException("MSG0008", path.toString(), path3.toString());
            }
            boolean bl2 = path4.toString().contains(".");
            Path path5 = bl2 ? path3 : path3.resolve(path.getFileName());
            Object object = STATIC_LOCK;
            synchronized (object) {
                if (bl) {
                    FileUtil.lockPath(path, path2 -> FileUtil.localCopy(path2, path5));
                } else {
                    FileUtil.localCopy(path, path5);
                }
            }
        } else {
            String string = "FileUtil#copy : from=" + path;
            LOGGER.warning("MSG0002", string);
        }
    }

    private static void localCopy(Path path, Path path2) {
        try {
            if (FileUtil.exists(path)) {
                Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException iOException) {
            LOGGER.warning(iOException, "MSG0012", path, path2);
        }
    }

    public static void move(Path path, Path path2) {
        FileUtil.move(path, path2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void move(Path path, Path path3, boolean bl) {
        if (path == null || path3 == null) {
            return;
        }
        if (FileUtil.exists(path)) {
            FileUtil.mkdirs(path3);
            Path path4 = path3.getFileName();
            if (path4 == null) {
                throw MsgUtil.throwException("MSG0008", path3.toString());
            }
            boolean bl2 = path4.toString().contains(".");
            Path path5 = bl2 ? path3 : path3.resolve(path.getFileName());
            Object object = STATIC_LOCK;
            synchronized (object) {
                if (bl) {
                    FileUtil.lockPath(path, path2 -> FileUtil.localMove(path2, path5));
                } else {
                    FileUtil.localMove(path, path5);
                }
            }
        } else {
            String string = "FileUtil#move : from=" + path;
            LOGGER.warning("MSG0002", string);
        }
    }

    private static void localMove(Path path, Path path2) {
        try {
            if (FileUtil.exists(path)) {
                Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            LOGGER.warning("MSG0008", path, path2);
        }
        catch (IOException iOException) {
            LOGGER.warning(iOException, "MSG0008", path, path2);
        }
    }

    public static Path backup(Path path, Path path2, String string) {
        return FileUtil.backup(path, path2, true, false, string);
    }

    public static Path backup(Path path, Path path2) {
        return FileUtil.backup(path, path2, true, true, null);
    }

    public static Path backup(Path path, Path path2, boolean bl, boolean bl2, String string) {
        String string2;
        int n;
        Path path3;
        Path path4 = path3 = path2 == null ? path.getParent() : path2;
        if (path3 == null) {
            throw MsgUtil.throwException("MSG0007", path.toString());
        }
        String string3 = path3.toString();
        string3 = StringUtil.replaceText(string3);
        path3 = Paths.get(string3, new String[0]);
        Path path5 = path.getFileName();
        if (path5 == null) {
            throw MsgUtil.throwException("MSG0002", path.toString());
        }
        Path path6 = path3.resolve(path5);
        Path path7 = bl2 && Files.notExists(path6, new LinkOption[0]) ? path6 : ((n = (string2 = path5.toString()).lastIndexOf(46)) > 0 ? path3.resolve(string2.substring(0, n) + "_" + StringUtil.nval(string, StringUtil.getTimeFormat()) + string2.substring(n)) : null);
        FileUtil.move(path, path7, bl);
        return path7;
    }

    public static void mergeFile(Path path, Path path2) {
        if (FileUtil.exists(path2) && !path2.equals(path)) {
            try {
                String string;
                List<String> list = FileUtil.readAllLines(path2);
                if (list.size() >= 2 && (string = list.get(0)).contains("COUNT") && string.contains("DATE") && string.contains("TIME")) {
                    list.remove(0);
                }
                FileUtil.save(path, list, true, StandardCharsets.UTF_8);
                Files.deleteIfExists(path2);
            }
            catch (IOException iOException) {
                throw MsgUtil.throwException(iOException, "MSG0003", path2.toAbsolutePath().normalize());
            }
        }
    }

    public static void delete(Path path) {
        try {
            if (FileUtil.exists(path)) {
                Files.walkFileTree(path, DELETE_VISITOR);
            }
        }
        catch (IOException iOException) {
            throw MsgUtil.throwException(iOException, "MSG0011", path);
        }
    }

    public static boolean stablePath(Path path) {
        return FileUtil.stablePath(path, 2000L, 10);
    }

    public static boolean stablePath(Path path, long l, int n) {
        if (FileUtil.exists(path)) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                for (int i = 0; i < n && FileUtil.exists(path); ++i) {
                    long l2 = Files.size(path);
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (FileUtil.exists(path)) {
                        long l3 = Files.size(path);
                        if (l2 == 0L || l2 != l3) continue;
                        return true;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                MsgUtil.errPrintln(iOException, "MSG0005", path);
            }
        }
        return false;
    }

    public static void lockPath(Path path, Consumer<Path> consumer) {
        if (FileUtil.exists(path)) {
            try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);){
                for (int i = 0; i < 10; ++i) {
                    block16: {
                        try {
                            if (fileChannel.tryLock(0L, Long.MAX_VALUE, true) != null) {
                                consumer.accept(path);
                                return;
                            }
                        }
                        catch (OverlappingFileLockException overlappingFileLockException) {
                            if (i < 3) break block16;
                            LOGGER.warning("MSG0104", path);
                        }
                    }
                    try {
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (IOException iOException) {
                throw MsgUtil.throwException(iOException, "MSG0005", path);
            }
            LOGGER.warning("MSG0015", path, 2000, 10);
        }
    }

    public static void forEach(Path path, Consumer<String> consumer) {
        FileUtil.forEach(path, StandardCharsets.UTF_8, consumer);
    }

    public static void forEach(Path path, Charset charset, Consumer<String> consumer) {
        if (FileUtil.exists(path)) {
            String string = null;
            int n = 0;
            try (FileInputStream fileInputStream = new FileInputStream(path.toFile());
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                while ((string = bufferedReader.readLine()) != null) {
                    if (n == 0 && !string.isEmpty() && string.charAt(0) == '\ufeff') {
                        System.out.println(MsgUtil.getMsg("MSG0105", path));
                        string = string.substring(1);
                    }
                    consumer.accept(string);
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw MsgUtil.throwException(iOException, "MSG0016", path, n, string);
            }
        }
    }

    public static void lockForEach(Path path2, Consumer<String> consumer) {
        FileUtil.lockPath(path2, path -> FileUtil.forEach(path, StandardCharsets.UTF_8, consumer));
    }

    public static void lockForEach(Path path2, Charset charset, Consumer<String> consumer) {
        FileUtil.lockPath(path2, path -> FileUtil.forEach(path, charset, consumer));
    }

    public static void save(Path path, List<String> list) {
        FileUtil.save(path, list, false, StandardCharsets.UTF_8);
    }

    public static void save(Path path, List<String> list, boolean bl, Charset charset) {
        Path path2 = path.getParent();
        if (path2 == null) {
            throw MsgUtil.throwException("MSG0007", path.toString());
        }
        FileUtil.mkdirs(path2);
        String string = null;
        int n = 0;
        try (PrintWriter printWriter = new PrintWriter(Files.newBufferedWriter(path, charset, bl ? APPEND : CREATE));){
            for (String string2 : list) {
                string = !string2.isEmpty() && string2.charAt(0) == '\ufeff' ? string2.substring(1) : string2;
                ++n;
                printWriter.println(string);
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            throw MsgUtil.throwException(iOException, "MSG0017", path, n, string);
        }
    }

    public static String timeStamp(Path path, String string) {
        long l = 0L;
        try {
            if (FileUtil.exists(path)) {
                l = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            }
        }
        catch (IOException iOException) {
            LOGGER.warning(iOException, "MSG0018", path);
        }
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        return StringUtil.getTimeFormat(l, string);
    }

    public static List<String> readAllLines(Path path) throws IOException {
        try {
            return Files.readAllLines(path);
        }
        catch (MalformedInputException malformedInputException) {
            LOGGER.warning("MSG0030", path);
            return Files.readAllLines(path, WINDOWS_31J);
        }
    }

    public static boolean exists(Path path) {
        return path != null && path.toFile().exists();
    }
}

