<?xml version="1.0" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useAjaxSubmit="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP05"
	title    = "定義マスタ"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
>
	2018/05/31	T.OTA	05200-180522-02	一覧にﾒｰﾙ不要ﾌﾗｸﾞ項目を追加。
</og:comment>

<!-- 変更はここからです。 -->

<!-- データが選ばれていなければエラー -->
<og:columnCheck minRowCount="1" command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- forward.jsp から command = "MODIFY" がセットされて遷移してくるので、変更画面となります。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command = "{@command}" >
	<og:columnSet command="{@command}" columnId="RDC_CODE"  action="SET"     value="{@USER.RDC_CODE}" />
</og:entry>

<!-- メッセージ表示を行います。必ずリソースファイルに表示するメッセージを登録し、 -->
<!-- lbl属性を使用して表示させて下さい。 -->
<og:message lbl="MSG0046" comment="変更処理を行います。" /><br />

<form method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />

</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
<!--  2018/05/31 MODIFY columnWritable属性にFGNOMLを追加 -->
<og:view
	viewFormType   = "HTMLTable"
	command        = "{@command}"
	columnWritable = "LISTNAME,MODELDIR,MODELFILE,FGCUT,COMMENTS,RELEASE_NOTES,FGLOCAL,FGDIRECT,OPTIONS,FGNOML"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"
	columnBulkSet= "LISTNAME,MODELDIR,MODELFILE,FGCUT,COMMENTS,RELEASE_NOTES,FGLOCAL,FGDIRECT,FGNOML"
/>

<!-- 2018/05/31 MODIFY FGNOMLを追加 -->
<og:hidden name="SQL" >
	update GE54
	set
		LISTNAME	= [LISTNAME] ,
		MODELDIR	= [MODELDIR] ,
		MODELFILE	= [MODELFILE] ,
		FGCUT		= [FGCUT]	 ,
		COMMENTS	= [COMMENTS] ,
		FGLOCAL		= [FGLOCAL]	 ,
		FGDIRECT	= [FGDIRECT] ,
		RELEASE_NOTES	= [RELEASE_NOTES] ,
		OPTIONS		= [OPTIONS] ,
		FGNOML		= [FGNOML] ,
		FGJ			= '1',
		RDC_CODE	= '{@USER.RDC_CODE}',
		DYUPD		= '{@USER.YMDH}' ,
		USRUPD		= '{@USER.ID}' ,
		PGUPD		= '{@GUI.KEY}'
	where 	SYSTEM_ID	= [SYSTEM_ID]
	and		LISTID		= [LISTID]
</og:hidden>

</form>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
