<jsp:directive.page pageEncoding="UTF-8" />
<!-- ユーザー別総計表示(JOIN) -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select B.USERID,B.NAME_JA
				, sum(COALESCE(A.USED_TIME,0))		AS USED_TIME
				, sum(COALESCE(A.CNT_ACCESS,0))		AS SUM_ACCESS
				, sum(COALESCE(A.CNT_ERROR,0))		AS SUM_ERROR
				, sum(COALESCE(A.CNT_READ,0))		AS SUM_READ
				, sum(COALESCE(A.CNT_WRITE,0))  	AS SUM_WRITE
				, sum(COALESCE(A.TM_TOTAL_QUERY,0)) AS SUM_TOTAL_QUERY
				, max(COALESCE(A.TM_MAX_QUERY,0))	AS TM_MAX_QUERY
		from GEA10 B left outer join GE15 A
		on      A.SYSTEM_ID = B.SYSTEM_ID
		and     A.USERID    = B.USERID
	<og:where>
		<og:and value = "B.SYSTEM_ID	=	'{@SYSTEM_ID}'"	/>
		<og:and value = "B.USERID		=	'{@USERID}'" 	/>
		<og:and value = "A.DYLOGIN		like '{@DATE}%'"	/>
	</og:where>
	group by B.SYSTEM_ID,B.USERID,B.NAME_JA
	order by B.SYSTEM_ID,{@SORT} SUM_ACCESS DESC,B.USERID
</og:query>

<og:viewLink command="{@command}">
	<og:link column="USERID" gamenId="GE0001" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,USERID"
		vals="NEW,{@SYSTEM_ID},[USERID]" />
	<og:link column="TM_MAX_QUERY" href="result.jsp" target="RESULT"
		keys="command,SYSTEM_ID,USERID,ACTION,TM_MAX_QUERY"
		vals="NEW,{@SYSTEM_ID},[USERID],GEM0020,[TM_MAX_QUERY]" />
</og:viewLink>

<og:view
	viewFormType = "HTMLTable"
	command      = "{@command}"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}" />
