/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Set;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.HTMLTagSupport;

public class TextareaTag
extends HTMLTagSupport {
    private static final String VERSION = "7.0.7.0 (2019/12/13)";
    private static final long serialVersionUID = 707020191213L;
    private static final Set<String> TD_SET = new ArraySet((Object[])new String[]{"yes", "no", "false"});
    private final String CLM = HybsSystem.sysBool("HTML_LABEL_SEPARATOR") ? ":" : "";
    private String tdFlag = "yes";
    private String colspan = "";
    private String rowspan = "";

    @Override
    public int doStartTag() {
        return this.useTag() ? 2 : 0;
    }

    @Override
    public int doAfterBody() {
        String string;
        String string2 = this.getBodyString();
        if (string2 != null && string2.length() > 0 && (string = StringUtil.htmlFilter((String)string2)) != null && string.length() > 0) {
            this.set("body", string);
        }
        return 0;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tdFlag = "yes";
        this.colspan = "";
        this.rowspan = "";
    }

    @Override
    protected String makeTag() {
        String string = this.get("name");
        if (this.getMsglbl() == null) {
            this.setLbl(string);
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        if ("yes".equals(this.tdFlag)) {
            stringBuilder.append("<td class=\"label\" ").append(this.rowspan).append('>').append(this.getLongLabel()).append("</td><td ").append(this.colspan).append(this.rowspan).append('>').append(XHTMLTag.textarea((Attributes)this.getAttributes())).append("</td>").append(this.makeAimaiPicker(string)).append(this.makeMustHidden(string));
        } else if ("no".equals(this.tdFlag)) {
            stringBuilder.append("<span class=\"label\">").append(this.getLongLabel()).append(this.CLM).append("</span>").append(XHTMLTag.textarea((Attributes)this.getAttributes())).append(this.makeAimaiPicker(string)).append(this.makeMustHidden(string));
        } else {
            stringBuilder.append(XHTMLTag.textarea((Attributes)this.getAttributes())).append(this.makeAimaiPicker(string)).append(this.makeMustHidden(string));
        }
        return stringBuilder.toString();
    }

    public void setName(String string) {
        this.set("name", this.getRequestParameter(string));
    }

    public void setRows(String string) {
        this.set("rows", this.getRequestParameter(string));
    }

    public void setCols(String string) {
        this.set("cols", this.getRequestParameter(string));
    }

    public void setTd(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tdFlag);
        if (!this.check(string2, TD_SET)) {
            String string3 = "Error in SelectTag [td]: " + string2 + "  in [" + String.join((CharSequence)", ", TD_SET) + "] only used.";
            throw new HybsSystemException(string3);
        }
        this.tdFlag = string2;
    }

    public void setColspan(String string) {
        this.colspan = StringUtil.nval((String)this.getRequestParameter(string), (String)this.colspan);
        if (this.colspan.length() > 0) {
            this.colspan = " colspan=\"" + this.colspan + "\" ";
        }
    }

    public void setRowspan(String string) {
        this.rowspan = StringUtil.nval((String)this.getRequestParameter(string), (String)this.rowspan);
        if (this.rowspan.length() > 0) {
            this.rowspan = " rowspan=\"" + this.rowspan + "\" ";
        }
    }

    public void setUseRealTimeCheck(String string) {
        String string2 = this.getRequestParameter(string);
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string2})) {
            this.add("optionAttributes", "realTimeChk=\"" + string2 + "\"");
        }
    }
}

