/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.opengion.fukurou.fileexec.CommandLine;
import org.opengion.fukurou.fileexec.FileExec;
import org.opengion.fukurou.fileexec.StringUtil;
import org.opengion.fukurou.fileexec.XLogger;
import org.opengion.fukurou.system.HybsConst;

public final class MainProcess
implements Runnable {
    private static final XLogger LOGGER = XLogger.getLogger(MainProcess.class.getSimpleName());
    public static final long WAIT_TIME = 30000L;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(5);
    private static final Set<ScheduledFuture<?>> futureSet = new HashSet();
    private static volatile boolean isStart;
    private static MainProcess mainPrcs;
    private final ConcurrentMap<String, FileExec> execMap = new ConcurrentHashMap<String, FileExec>();
    private int cnt;

    private MainProcess() {
        LOGGER.info(() -> "MainProcess Start! ");
    }

    public static synchronized MainProcess getInstance() {
        if (mainPrcs == null) {
            mainPrcs = new MainProcess();
        }
        return mainPrcs;
    }

    public static synchronized void start() {
        try {
            if (futureSet.isEmpty()) {
                MainProcess mainProcess = MainProcess.getInstance();
                String string = HybsConst.getenv("loop");
                long l = string == null || string.isEmpty() ? 30L : Long.parseLong(string);
                futureSet.add(scheduler.scheduleWithFixedDelay(mainProcess, 0L, l, TimeUnit.SECONDS));
                isStart = true;
            }
        }
        catch (Throwable throwable) {
            LOGGER.warning(throwable, "MSG0021", "MainProcess#start");
            MainProcess.shutdown(false);
        }
    }

    public static synchronized void shutdown(boolean bl) {
        LOGGER.info(() -> "MainProcess Shutdown Starting ...");
        isStart = false;
        futureSet.forEach(scheduledFuture -> scheduledFuture.cancel(true));
        futureSet.clear();
        if (bl) {
            scheduler.shutdownNow();
        }
        if (mainPrcs != null) {
            mainPrcs.watchStop();
        }
        mainPrcs = null;
        LOGGER.info(() -> "MainProcess Shutdown Complete.");
    }

    public static boolean isStarted() {
        return isStart;
    }

    private void startTask(CommandLine commandLine) {
        String string = commandLine.getValue(CommandLine.GE70.SYSTEM_ID);
        String string2 = commandLine.getValue(CommandLine.GE70.RSRV_NO);
        String string3 = string + "_" + string2;
        this.stopTask(string3);
        String string4 = commandLine.getValue(CommandLine.GE70.FGYKAN);
        if ("1".equals(string4)) {
            FileExec fileExec = new FileExec(commandLine);
            LOGGER.info(() -> "startTask: yoyakuNo=[" + string3 + "]");
            fileExec.watchStart();
            this.execMap.put(string3, fileExec);
        } else {
            LOGGER.warning(() -> "\u3010WARNING\u3011startTask: yoyakuNo=[" + string3 + "] , fgkan=[" + string4 + "]");
        }
    }

    private void stopTask(String string) {
        FileExec fileExec = (FileExec)this.execMap.remove(string);
        if (fileExec != null) {
            fileExec.watchStop();
        }
        LOGGER.info(() -> "stopTask: yoyakuNo=[" + string + "]");
    }

    public void watchStop() {
        this.execMap.forEach((string, fileExec) -> fileExec.watchStop());
    }

    @Override
    public void run() {
        try {
            List<CommandLine> list = CommandLine.dbCommand();
            list.forEach(commandLine -> this.startTask((CommandLine)commandLine));
            System.out.println(StringUtil.getTimeFormat("yyyy/MM/dd HH:mm:ss [" + this.cnt++ + "]"));
        }
        catch (Throwable throwable) {
            LOGGER.warning(throwable, "MSG0021", "MainProcess#run");
            MainProcess.shutdown(true);
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

