<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0007"
	title    = "システムパラメータ"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command = "{@command}" debug="{@debug}" dbid="{@DBID}" maxRowCount="{@maxRowCount}">
	select CASE WHEN PARAM_LVL &gt;= '8' THEN '0' ELSE '1' END as WRITABLE,
			SYSTEM_ID,KBSAKU,CONTXT_PATH,PARAM_LVL,SEQNO,PARAM_ID,PARAM,TITLE,UNIQ,CONTENTS,FGJ
	from GE12
	where SYSTEM_ID in ( '{@SYSTEM_ID}','{@AST}' )
	<og:where startKey="and">
		<og:and value = "FGJ		=		'{@FGJ}'"			/>
		<og:and value = "TITLE		like	'{@TITLE}'"		/>
		<og:and value = "PARAM_ID	like	'{@PARAM_ID}'"		/>
		<og:and value = "CONTENTS	like	'{@CONTENTS}'"		/>
		<og:and value = "PARAM		like	'{@PARAM}'" 		/>
		<og:and value = "CONTXT_PATH like	'{@CONTXT_PATH}'"	/>
		<og:and value = "KBSAKU		=		'{@KBSAKU}'"		/>
		<og:and value = "PARAM_LVL	=		'{@PARAM_LVL}'"		/>
		<og:and value = "PARAM_LVL	!=		'{@OMIT_AUTO}'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "CONTXT_PATH,PARAM_ID,SYSTEM_ID DESC,KBSAKU DESC" />
</og:query>

<!-- PARAM_ID キーでグループ化します。先行優先です。-->
<og:tableMerge
	action		= "GROUP"
	masterKeys	= "PARAM_ID,CONTXT_PATH"
	display		= "false"
/>

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<og:columnMarker column="PARAM" onMark="PASS" markList="[PARAM_ID]" >
		<span>****</span>
	</og:columnMarker>
	<og:columnMarker column="PARAM_ID" onMark="[PARAM_LVL]" markList="5" >
		<span style="background-color:#ccff00;">[PARAM_ID]</span>
	</og:columnMarker>
	<og:columnMarker column="PARAM_LVL" onMark="[PARAM_LVL]" markList="012" >
		<span style="background-color:#ff66cc;">[PARAM_LVL]</span>
	</og:columnMarker>
</og:viewMarker>

<og:columnEditor columns="SYSTEM_ID,SEQNO,CONTXT_PATH"	size="5" />
<og:columnEditor columns="PARAM_ID,PARAM,TITLE"			clazz="W100" />
<og:columnEditor column="CONTENTS" editor="AUTOAREA" param="3-15,100-100" />

<form method="POST" action="forward.jsp" target="RESULT">
	<og:writeCheck>
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="null" />
		<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,PARAM_ID,PARAM_LVL"				caseNull="{@AST}" />
		<og:submit  action="DELETE"  columnWritable="null" keys="logicalDelete" vals="true"	caseNull="{@AST}" />
		<og:submit  action="DELETE"  columnWritable="null" lbl="DELETE_PH" roles="DEL"		caseNull="{@AST}" />

		<og:equals val1="{@ACTION}" val2="{@ACTION}" notEquals="true">
			<fieldset style="display:inline;">
				<legend><strong><og:message lbl="INSERT_GE12" /></strong></legend>
				<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
				<og:submit  action="COPY" noWritable="null" lbl="SYS{@LBL.COPY}" keys="sysins" vals="true"  />
			</fieldset>
		</og:equals>
		<br />
	</og:writeCheck>

	<og:view
		viewFormType = "HTMLCustomTable"
		command    = "{@command}"
		noDisplay  = "UNIQ"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
	>
		<jsp:directive.include file="view.jsp" />
	</og:view>

	<og:hidden name="VIEW" value="true" />	<!-- update.jsp では、必ず表示しておく -->

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
