/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.GUIData;

final class GUIDataLoader {
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final String QUERY = "select A.GUIKEY,A.GUILVL,A.LABEL_CLM,A.ADDRESS,A.SEQNO,A.GROUPS,'' as CLASSIFY,A.ROLES,A.RWMODE,A.TARGET,A.PARAM,A.KBLINK,A.DYUPD,A.SYSTEM_ID,A.SNO,A.KBSAKU from (  select 0 as SNO,B.* from GEA11 B where B.SYSTEM_ID='**'  union all  select 1 as SNO,B.* from GEA11 B where B.SYSTEM_ID IN (?,?) ) A where A.FGJ='1' order by A.SNO,A.KBSAKU,A.SEQNO,A.GUIKEY";
    final Map<String, GUIData> guiMap = Collections.synchronizedMap(new LinkedHashMap());
    private final String SYSTEM_ID;
    private final String BASE_SYS_ID;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;

    GUIDataLoader(String string, String string2) {
        this.SYSTEM_ID = string;
        this.BASE_SYS_ID = string2;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("GUIDataLoader", null, null);
        } else {
            this.appInfo = null;
        }
        this.loadDBResource();
    }

    private void loadDBResource() {
        int n;
        String[] stringArray = new String[]{this.BASE_SYS_ID, this.SYSTEM_ID};
        String[][] stringArray2 = DBUtil.dbExecute((String)QUERY, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
        int[] nArray = new int[3];
        int n2 = stringArray2.length;
        String string = "";
        for (n = 0; n < n2; ++n) {
            String[] stringArray3 = stringArray2[n];
            int n3 = Integer.parseInt(stringArray3[14]);
            int n4 = Integer.parseInt(stringArray3[1]);
            if (n4 == 2) {
                string = stringArray3[0];
            } else if (n4 >= 3) {
                stringArray3[6] = string;
            }
            if ((n4 == 1 || n4 == 2) && StringUtil.isEmpty((CharSequence[])new CharSequence[]{stringArray3[3]})) {
                stringArray3[7] = null;
            }
            String string2 = stringArray3[0] + "_" + stringArray3[7];
            this.guiMap.put(string2, new GUIData(stringArray3));
            int n5 = n3;
            nArray[n5] = nArray[n5] + 1;
        }
        n = this.guiMap.size();
        System.out.println("  GUIDataLoader [" + n + "]  ** [" + nArray[0] + "] " + this.BASE_SYS_ID + " [" + nArray[1] + "] " + this.SYSTEM_ID + " [" + nArray[2] + "] loaded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUIData[] getAllData() {
        Map<String, GUIData> map = this.guiMap;
        synchronized (map) {
            if (this.guiMap.isEmpty()) {
                this.loadDBResource();
            }
            return this.guiMap.values().toArray(new GUIData[this.guiMap.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, GUIData> map = this.guiMap;
        synchronized (map) {
            this.guiMap.clear();
        }
    }
}

