/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletContext;
import org.opengion.fukurou.model.POIUtil;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.ZipArchive;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class FileTag
extends CommonTagSupport {
    private static final String VERSION = "7.2.6.3 (2020/08/07)";
    private static final long serialVersionUID = 726320200807L;
    public static final String ACT_CANREAD = "canRead";
    public static final String ACT_CANWRITE = "canWrite";
    public static final String ACT_CREATENEWFILE = "createNewFile";
    public static final String ACT_DELETE = "delete";
    public static final String ACT_EXISTS = "exists";
    public static final String ACT_ISDIRECTORY = "isDirectory";
    public static final String ACT_ISFILE = "isFile";
    public static final String ACT_ISHIDDEN = "isHidden";
    public static final String ACT_MKDIR = "mkdir";
    public static final String ACT_MKDIRS = "mkdirs";
    public static final String ACT_RENAMETO = "renameTo";
    public static final String ACT_READ = "read";
    public static final String ACT_EXISTSLENGTH = "existsLength";
    public static final String ACT_COPY = "copy";
    public static final String ACT_COPYST = "copyST";
    public static final String ACT_LIST = "list";
    public static final String ACT_ZIP = "zip";
    public static final String ACT_TIMESTAMP = "timeStamp";
    private static final Set<String> ACTION_SET = new ArraySet((Object[])new String[]{"canRead", "canWrite", "createNewFile", "delete", "exists", "isDirectory", "isFile", "isHidden", "mkdir", "mkdirs", "renameTo", "read", "existsLength", "copy", "copyST", "list", "zip", "timeStamp"});
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String file1 = "";
    private String file2;
    private String action;
    private boolean rtnCode;
    private boolean notEquals;
    private boolean useStop = true;
    private String encode;

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            try {
                this.rtnCode = this.notEquals ^ this.actionExec(this.action);
            }
            catch (IOException iOException) {
                String string = "\u6307\u5b9a\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc" + CR + "\t  action=[" + this.action + "]" + CR + "\t  fileURL=[" + this.fileURL + "]" + CR + "\t  file1=[" + this.file1 + "]" + CR + "\t  file2=[" + this.file2 + "]" + CR;
                throw new HybsSystemException(string, iOException);
            }
            if (this.rtnCode) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        return this.useTag() && this.useStop && !this.rtnCode ? 5 : 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.file1 = "";
        this.file2 = null;
        this.action = null;
        this.rtnCode = false;
        this.notEquals = false;
        this.useStop = true;
        this.encode = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean actionExec(String string) throws IOException {
        if (string == null) {
            String string2 = "\u30a2\u30af\u30b7\u30e7\u30f3\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u30a2\u30af\u30b7\u30e7\u30f3 NULL \u30a8\u30e9\u30fc" + CR + "\t  file=[" + this.file1 + "]" + CR + "\t  matches=[" + this.file2 + "]" + CR;
            throw new HybsSystemException(string2);
        }
        String string3 = HybsSystem.url2dir(this.fileURL);
        File file = new File(StringUtil.urlAppend((CharSequence)string3, (CharSequence[])new CharSequence[]{this.file1}));
        boolean bl = false;
        if (ACT_CANREAD.equalsIgnoreCase(string)) {
            return file.canRead();
        }
        if (ACT_CANWRITE.equalsIgnoreCase(string)) {
            return file.canWrite();
        }
        if (ACT_CREATENEWFILE.equalsIgnoreCase(string)) {
            return file.createNewFile();
        }
        if (ACT_DELETE.equalsIgnoreCase(string)) {
            return FileUtil.deleteFiles((File)file);
        }
        if (ACT_EXISTS.equalsIgnoreCase(string)) {
            return file.exists();
        }
        if (ACT_ISDIRECTORY.equalsIgnoreCase(string)) {
            return file.isDirectory();
        }
        if (ACT_ISFILE.equalsIgnoreCase(string)) {
            return file.isFile();
        }
        if (ACT_ISHIDDEN.equalsIgnoreCase(string)) {
            return file.isHidden();
        }
        if (ACT_MKDIR.equalsIgnoreCase(string)) {
            if (!file.isDirectory()) return file.mkdir();
            return true;
        }
        if (ACT_MKDIRS.equalsIgnoreCase(string)) {
            if (!file.isDirectory()) return file.mkdirs();
            return true;
        }
        if (ACT_RENAMETO.equalsIgnoreCase(string)) {
            if (this.file2 == null) return bl;
            File file2 = new File(StringUtil.urlAppend((CharSequence)string3, (CharSequence[])new CharSequence[]{this.file2}));
            if (!file2.exists()) return file.renameTo(file2);
            if (file2.delete()) return file.renameTo(file2);
            String string4 = "\u6240\u5b9a\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + file2 + "]";
            throw new OgRuntimeException(string4);
        }
        if (ACT_READ.equalsIgnoreCase(string)) {
            String string5;
            if (!file.isFile()) {
                String string6 = "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u306a\u3044\u304b\u3001\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" + CR + "\t  action=[" + string + "]" + CR + "\t  fileURL=[" + this.fileURL + "]" + CR + "\t  directory=[" + string3 + "]" + CR + "\t  file1=[" + this.file1 + "]" + CR;
                throw new HybsSystemException(string6);
            }
            if (POIUtil.isPOI((File)file)) {
                string5 = POIUtil.extractor((File)file);
            } else {
                String string7 = this.encode == null ? "UTF-8" : this.encode;
                string5 = POIUtil.extractor((File)file, (String)string7);
            }
            bl = true;
            this.setRequestAttribute(ACT_READ, string5);
            return bl;
        }
        if (ACT_EXISTSLENGTH.equalsIgnoreCase(string)) {
            if (!file.exists()) return false;
            if (file.length() <= 0L) return false;
            return true;
        }
        if (ACT_COPY.equalsIgnoreCase(string) && this.file2 != null) {
            File file3 = new File(StringUtil.urlAppend((CharSequence)string3, (CharSequence[])new CharSequence[]{this.file2}));
            if (file.exists()) {
                return FileUtil.copy((File)file, (File)file3);
            }
            String string8 = "copy\u5143(file1)\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" + CR + "\t  action=[" + string + "]" + CR + "\t  fileURL=[" + this.fileURL + "]" + CR + "\t  directory=[" + string3 + "]" + CR + "\t  file1=[" + this.file1 + "]" + CR + "\t  file2=[" + this.file2 + "]" + CR;
            throw new HybsSystemException(string8);
        }
        if (ACT_COPYST.equalsIgnoreCase(string) && this.file2 != null) {
            File file4 = new File(StringUtil.urlAppend((CharSequence)string3, (CharSequence[])new CharSequence[]{this.file2}));
            ServletContext servletContext = this.pageContext.getServletContext();
            bl = FileUtil.copy((InputStream)servletContext.getResourceAsStream(this.file1), (File)file4);
            if (bl) return bl;
            String string9 = string + " \u30a2\u30af\u30b7\u30e7\u30f3\u304c\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "\t  action=[" + string + "]" + CR + "\t  fileURL=[" + this.fileURL + "]" + CR + "\t  directory=[" + string3 + "]" + CR + "\t  file1=[" + this.file1 + "]" + CR + "\t  file2=[" + this.file2 + "]" + CR;
            throw new HybsSystemException(string9);
        }
        if (ACT_LIST.equalsIgnoreCase(string)) {
            String[] stringArray;
            if (file.isDirectory()) {
                stringArray = file.list();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = file.getName();
            }
            String[] stringArray3 = stringArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray3 != null) {
                boolean bl2 = this.file2 == null || this.file2.isEmpty();
                for (String string10 : stringArray3) {
                    if (!bl2 && !string10.matches(this.file2)) continue;
                    arrayList.add(string10);
                }
            }
            this.setRequestAttribute(ACT_LIST, arrayList);
            return true;
        }
        if (ACT_ZIP.equalsIgnoreCase(string) && this.file2 != null) {
            File file5;
            File file6;
            if (this.file2.toLowerCase(Locale.JAPAN).indexOf(".zip") < 0) {
                this.file2 = this.file2 + ".zip";
            }
            if ((file6 = (file5 = new File(StringUtil.urlAppend((CharSequence)string3, (CharSequence[])new CharSequence[]{this.file2}))).getParentFile()) == null || !file6.exists() && !file6.mkdirs()) {
                String string11 = "zipFile\u30d5\u30a1\u30a4\u30eb\u306e\u89aa\u30d5\u30a9\u30eb\u30c0\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + " zipFile=[" + file5 + "]" + CR;
                throw new HybsSystemException(string11);
            }
            List list = ZipArchive.compress((File)file, (File)file5);
            if (list.isEmpty()) return false;
            return true;
        }
        if (!ACT_TIMESTAMP.equalsIgnoreCase(string)) return bl;
        return file.setLastModified(System.currentTimeMillis());
    }

    public void setAction(String string) {
        this.action = this.getRequestParameter(string);
        if (!this.check(this.action, ACTION_SET)) {
            String string2 = "\u6307\u5b9a\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc" + CR + "\t  action=[" + this.action + "]" + CR + "\t  actionList=" + String.join((CharSequence)", ", ACTION_SET);
            throw new HybsSystemException(string2);
        }
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.fileURL = StringUtil.urlAppend((CharSequence)this.fileURL, (CharSequence[])new CharSequence[]{string2});
        }
    }

    public void setFile1(String string) {
        this.file1 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.file1);
    }

    public void setFile2(String string) {
        this.file2 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.file2);
    }

    public void setNotEquals(String string) {
        this.notEquals = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.notEquals);
    }

    public void setUseStop(String string) {
        this.useStop = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useStop);
    }

    public void setEncode(String string) {
        this.encode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.encode);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("fileURL", (Object)this.fileURL).println("file1", (Object)this.file1).println("file2", (Object)this.file2).println("action", (Object)this.action).println("rtnCode", (Object)this.rtnCode).println("notEquals", (Object)this.notEquals).println("useStop", (Object)this.useStop).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

