<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0001"
	title    = "ユーザー定義"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}" />

<!-- 物理削除以外の場合は、自身の行が、活動中かどうかをﾁｪｯｸします。 -->
<og:equals val1="DELETE" val2="{@sqlType}" notEquals="true" >
	<og:dataCheck
		dbid		= "{@MEM.TO_DBID}"
		command 	= "{@command}"
		from		= "GEA10"
		where		= "UNIQ=[UNIQ] AND SYSTEM_ID=[SYSTEM_ID]"
		errRemove	= "{@errRemove}"
	/>
</og:equals>

<og:equals val1="{@sqlType}" val2="COPY" >
	<!-- COPY の場合は、すでに、同一論理キーのデータが存在すれば、エラーにします。 -->
	<og:dataCheck
		dbid	= "{@MEM.TO_DBID}"
		command	= "{@command}"
		from	= "GEA10"
		where	= "SYSTEM_ID=[SYSTEM_ID] AND USERID=[USERID] AND ROLES=[ROLES] AND FGJ='1'"
	/>

	<og:dataCheck
		dbid	= "{@MEM.TO_DBID}"
		command	= "{@command}"
		exist	= "false"
		conditionKey = "FGDEFAULT"
		conditionList = "0">
			SELECT COUNT(*) FROM GEA10
			WHERE SYSTEM_ID=[SYSTEM_ID] AND USERID=[USERID] AND FGDEFAULT='0' AND FGJ = '1'
	</og:dataCheck>

	<!-- メモリ内での重複ﾁｪｯｸ -->
	<og:dataCheck
		command			= "{@command}"
		uniqCheckClms	= "SYSTEM_ID,USERID"
	/>
</og:equals>

<og:tableUpdate
	dbid			= "{@MEM.TO_DBID}"
	command			= "{@command}"
	queryType		= "JDBCTableUpdate">
	<og:tableUpdateParam
		sqlType			= "{@sqlType}"
		table			= "GEA10"
		where			= "UNIQ=[UNIQ] AND SYSTEM_ID=[SYSTEM_ID]"
		names			= "SYSTEM_ID,USERID,PASSWD,LANG,NAME_JA,ROLES,COMMENTS,DYPASSWD,DYVALID,FGDEFAULT,DROLES,MAILAD"
		logicalDelete	= "{@logicalDelete}"
	/>
</og:tableUpdate>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
