<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0003"
	title    = "カラム"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}">
	<og:columnSet command="{@command}" columnId="EXIST_GEA08" action="SET" value="0" />
	<og:columnSet command="{@command}" columnId="UNIQ_GEA08"  action="SET" value="-1" />
</og:entry>

<!-- COPY の場合は、すでに、同一論理キーのデータが存在すれば、エラーにします。 -->
<og:equals val1="COPY|INSERT" val2="{@sqlType}" contains="true" >
	<og:dataCheck
		dbid		= "{@MEM.TO_DBID}"
		command 	= "{@command}"
		from		= "GEA03"
		where		= "SYSTEM_ID=[SYSTEM_ID] AND CLM=[CLM] AND KBSAKU=[KBSAKU] AND FGJ in ('0','1')"
		errRemove	= "{@errRemove}"
	/>

	<!-- メモリ内での重複ﾁｪｯｸ -->
	<og:dataCheck
		command			= "{@command}"
		uniqCheckClms	= "SYSTEM_ID,CLM,KBSAKU"
	/>
</og:equals>

<og:tableFilter classId="DBSELECT" dbid="{@MEM.TO_DBID}">
	select '1' as EXIST_GEA08, A.UNIQ as UNIQ_GEA08
	from GEA08 A
	where A.SYSTEM_ID	= [SYSTEM_ID]
	and   A.CLM			= [CLM]
	and   A.LANG		= [LANG]
	and   A.KBSAKU		= [KBSAKU]
--	and   A.FGJ      in ('0','1')
	order by A.SYSTEM_ID, A.KBSAKU
</og:tableFilter>

<og:transaction>
	<og:equals val1="COPY|MODIFY|INSERT" val2="{@sqlType}" contains="true">
		<og:tableUpdate
			dbid			= "{@MEM.TO_DBID}"
			command			= "{@command}"
			queryType		= "JDBCTableUpdate"
			conditionKey	= "EXIST_GEA08"
			conditionList	= "0"
			commitTableModel= "false">
			<og:tableUpdateParam
				sqlType		= "INSERT"
				table		= "GEA08"
				names		= "SYSTEM_ID,CLM,LANG,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,RELEASE_NOTES,RDC_CODE,FGLOAD,CDKH"
				constKeys	= "KBLBL"
				constVals	= "1"
			/>
		</og:tableUpdate>
		<og:tableUpdate
			dbid			= "{@MEM.TO_DBID}"
			command			= "{@command}"
			queryType		= "JDBCTableUpdate"
			conditionKey	= "EXIST_GEA08"
			conditionList	= "1"
			commitTableModel= "false">
			<og:tableUpdateParam
				sqlType		= "UPDATE"
				table		= "GEA08"
				names		= "SYSTEM_ID,CLM,LANG,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,RELEASE_NOTES,RDC_CODE,FGLOAD,CDKH"
				where		= "UNIQ=[UNIQ_GEA08]"
				constKeys	= "KBLBL"
				constVals	= "1"
			/>
		</og:tableUpdate>
	</og:equals>

	<og:equals val1="DELETE" val2="{@sqlType}">
		<!-- 削除は、すべての LANG に対して実施するので、UNIQ_GEA08 は使わない -->
		<og:tableUpdate
			dbid			= "{@MEM.TO_DBID}"
			command			= "{@command}"
			queryType		= "JDBCTableUpdate"
			commitTableModel= "false">
			<og:tableUpdateParam
				sqlType			= "{@sqlType}"
				table			= "GEA08"
				where			= "SYSTEM_ID=[SYSTEM_ID] AND CLM=[CLM] AND KBSAKU=[KBSAKU]"
				names			= "CDKH"
				logicalDelete	= "{@logicalDelete}"
			/>
		</og:tableUpdate>
	</og:equals>

<!--
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		queryType		= "JDBCTableUpdate"
		commitTableModel= "false">
		<og:tableUpdateParam
			sqlType		= "{@sqlType}"
			table		= "GEA08"
			names		= "SYSTEM_ID,CLM,LANG,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,RELEASE_NOTES,RDC_CODE,FGLOAD,CDKH"
			where		= "UNIQ = [UNIQ_GEA08]"
			constKeys	= "KBLBL"
			constVals	= "1"
			logicalDelete	= "{@logicalDelete}"
		/>
	</og:tableUpdate>
-->

<!--	<og:value command="SETTBL" key="CLM" action="APPEND"/>	-->
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		queryType		= "JDBCTableUpdate"
		resourceType	= "GEA03">
		<og:tableUpdateParam
			sqlType			= "{@sqlType}"
			table			= "GEA03"
			omitNames		= "LNAME,SNAME,LANG,DESCRIPTION,EXIST_GEA08,UNIQ_GEA08"
			where			= "UNIQ=[UNIQ] AND SYSTEM_ID=[SYSTEM_ID] AND CLM=[CLM]"
			logicalDelete	= "{@logicalDelete}"
		/>
	</og:tableUpdate>
</og:transaction>

<!--他システムIDのリソース更新ここから-->
<og:value command="SET" key="remocommand" value="COLUMN"/>
<jsp:directive.include file="/jsp/common/remoteResource.jsp" />
<!--他システムリソース更新ここまで-->

<og:value command="REMOVE" key="CLM" />

<og:forward page="result.jsp" keys="command" vals="RENEW" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
