<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0004"
	title    = "コード"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}">
	<og:columnSet command="{@command}" columnId="CLM_T"       action="TBLSET" value="[CLM]" />
	<og:columnSet command="{@command}" columnId="CODE_T"      action="TBLSET" value="[CLM].[CODE]" />
	<og:columnSet command="{@command}" columnId="EXIST_GEA08" action="SET"    value="0" />
	<og:columnSet command="{@command}" columnId="UNIQ_GEA08"  action="SET"    value="-1" />
</og:entry>

<!-- COPY の場合は、すでに、同一論理キーのデータが存在すれば、エラーにします。 -->
<!-- 7.2.9.2 (2020/10/30) 条件に、INSERT も追加 -->
<og:equals val1="COPY|INSERT" val2="{@sqlType}" contains="true">
	<og:dataCheck
		dbid	= "{@MEM.TO_DBID}"
		command = "{@command}"
		exist	= "false"
		from	= "GEA04"
		where	= "SYSTEM_ID=[SYSTEM_ID] AND CLM=[CLM] AND CODE=[CODE] AND KBSAKU=[KBSAKU] AND FGJ in ('0','1')"
	/>

	<!-- メモリ内での重複ﾁｪｯｸ -->
	<og:dataCheck
		command			= "{@command}"
		uniqCheckClms	= "SYSTEM_ID,CLM,CODE,KBSAKU"
	/>
</og:equals>

<og:entry command="{@command}">
	<og:columnSet command="{@command}" columnId="NAME_JA" action="TBLSET" value="[LNAME]" />
</og:entry>

<og:tableFilter classId="DBSELECT" dbid="{@MEM.TO_DBID}">
	select '1' EXIST_GEA08, A.UNIQ UNIQ_GEA08
	from GEA08 A
	where A.SYSTEM_ID = [SYSTEM_ID]
	and   A.CLM       = [CODE_T]
	and   A.KBSAKU    = [KBSAKU]
	and   A.LANG      = [LANG]
--	and   A.FGJ      in ('0','1')
	order by A.SYSTEM_ID DESC, A.KBSAKU DESC
</og:tableFilter>

<og:transaction>
	<og:equals val1="COPY|MODIFY|INSERT" val2="{@sqlType}" contains="true">
		<og:tableUpdate
			dbid			= "{@MEM.TO_DBID}"
			command			= "{@command}"
			queryType		= "JDBCTableUpdate"
			conditionKey	= "EXIST_GEA08"
			conditionList	= "0"
			commitTableModel= "false">
			<og:tableUpdateParam
				sqlType		= "INSERT"
				table		= "GEA08"
				names		= "SYSTEM_ID,CODE_T,LANG,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,RELEASE_NOTES,CDKH,RDC_CODE"
				constKeys	= "KBLBL,FGLOAD"
				constVals	= "6,0"
				asNames		= "CODE_T"
				orgNames	= "CLM"
			/>
		</og:tableUpdate>
		<og:tableUpdate
			dbid			= "{@MEM.TO_DBID}"
			command			= "{@command}"
			queryType		= "JDBCTableUpdate"
			conditionKey	= "EXIST_GEA08"
			conditionList	= "1"
			commitTableModel= "false">
			<og:tableUpdateParam
				sqlType		= "UPDATE"
				table		= "GEA08"
				where		= "UNIQ=[UNIQ_GEA08]"
				names		= "SYSTEM_ID,CODE_T,LANG,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,RELEASE_NOTES,CDKH,RDC_CODE"
				constKeys	= "KBLBL,FGLOAD"
				constVals	= "6,0"
				asNames		= "CODE_T"
				orgNames	= "CLM"
			/>
		</og:tableUpdate>
	</og:equals>

	<og:equals val1="DELETE" val2="{@sqlType}">
		<!-- 削除は、すべての LANG に対して実施するので、UNIQ_GEA08 は使わない -->
		<og:tableUpdate
			dbid			= "{@MEM.TO_DBID}"
			command			= "{@command}"
			queryType		= "JDBCTableUpdate"
			commitTableModel= "false">
			<og:tableUpdateParam
				sqlType		= "{@sqlType}"
				table		= "GEA08"
				where		= "SYSTEM_ID=[SYSTEM_ID] AND CLM=[CODE_T] AND KBSAKU=[KBSAKU]"
				names		= "CDKH"
				logicalDelete	= "{@logicalDelete}"
			/>
		</og:tableUpdate>
	</og:equals>

	<!--	<og:value command="SETTBL" key="CLM" action="APPEND"/>	-->
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		resourceType	= "GEA04"
		queryType		= "JDBCTableUpdate">
		<og:tableUpdateParam
			sqlType		= "{@sqlType}"
			table		= "GEA04"
			where		= "UNIQ=[UNIQ] AND SYSTEM_ID=[SYSTEM_ID]"
			names		= "SYSTEM_ID,CLM_T,CODE,SEQNO,CODELVL,CODEGRP,CODE_PARAM,KBSAKU,RELEASE_NOTES,RDC_CODE,COMMENTS,CDKH"
			asNames		= "CLM_T"
			orgNames	= "CLM"
			logicalDelete	= "{@logicalDelete}"
		/>
	</og:tableUpdate>
</og:transaction>

<!--他システムIDのリソース更新ここから-->
<og:value command="SET" key="remocommand" value="CODE"/>
<jsp:directive.include file="/jsp/common/remoteResource.jsp" />
<!--他システムリソース更新ここまで-->

<og:value command="REMOVE" key="CLM" />

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
