<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0018"
	title    = "データロール"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}" />

<!-- 7.2.9.2 (2020/10/30) 条件に、INSERT も追加 -->
<og:equals val1="COPY|INSERT" val2="{@sqlType}" contains="true">
	<og:dataCheck
		command	= "{@command}"
		from	= "GEA05"
		exist	= "true"
		where	= "SYSTEM_ID=[SYSTEM_ID] AND ROLES=[DROLE] AND KBROLE='2' AND FGJ = '1'"
	/>
</og:equals>

<og:equals val1="{@sqlType}" val2="DELETE" notEquals="true" >
	<og:dataCheck
		command	= "{@command}"
		from	= "GEA06"
		where	= "SYSTEM_ID=[SYSTEM_ID] AND DROLE=[DROLE] AND CVALUE=[CVALUE] AND CLM=[CLM] AND FGJ = '1'"
	/>
</og:equals>

<og:tableUpdate
	command			= "{@command}"
	queryType		= "JDBCTableUpdate">
	<og:tableUpdateParam
		sqlType			= "{@sqlType}"
		table			= "GEA06"
		where			= "UNIQ=[UNIQ] AND SYSTEM_ID=[SYSTEM_ID]"
		names			= "SYSTEM_ID,DROLE,CLM,CVALUE,VALCDTN"
		logicalDelete	= "{@logicalDelete}"
	/>
</og:tableUpdate>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
