<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
			  omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="TBLSYU"    select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />
  <xsl:param name="DYSET"     select="" />

  <xsl:param name="row_header" >
	 <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
	 <TBLSYU	><xsl:value-of select="$TBLSYU"    /></TBLSYU>
	 <ADDRESS	><xsl:value-of select="$ADDRESS"   /></ADDRESS>
	 <FILENAME	><xsl:value-of select="$FILENAME"  /></FILENAME>
	 <FILEPATH	><xsl:value-of select="$FILEPATH"  /></FILEPATH>
	 <MODIFIED	><xsl:value-of select="$MODIFIED"  /></MODIFIED>
	 <DYSET		><xsl:value-of select="$DYSET"     /></DYSET>
	 <PGSET		>DOC18</PGSET>
  </xsl:param>

  <xsl:template match="jsp:root" >
	<xsl:if test="(number(@version) &lt; 2.0)" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >ERROR01</MSGCD>
		<MSGTXT >jsp:root タグのversion属性は、2.0 以上を指定してください。(Tomcat5=2.0,Tomcat6=2.1,Tomcat7=2.2,Tomcat8=2.3,Tomcat9=2.3)</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>

	<xsl:apply-templates select="//og:sql | //og:update | //og:tableExist | //og:tabTable | //og:tab | //og:stackHeader" />
	<xsl:apply-templates select="//og:link" />
	<xsl:apply-templates select="//og:head" />
	<xsl:apply-templates select="//og:help" />
	<xsl:apply-templates select="//og:writeTable" />
	<xsl:apply-templates select="//og:option" />
	<xsl:apply-templates select="//og:value" />
	<xsl:apply-templates select="//og:hidden" />
	<xsl:apply-templates select="//og:columnEditor" />
	<xsl:apply-templates select="//og:query" />
	<xsl:apply-templates select="//og:userInfo" />
	<xsl:apply-templates select="//og:view" />
	<xsl:apply-templates select="//og:submit" />
	<xsl:apply-templates select="//og:writeCheck" />
	<xsl:apply-templates select="//og:button" />
	<xsl:apply-templates select="//og:equals" />
	<xsl:apply-templates select="//og:entry" />
	<xsl:apply-templates select="//og:viewLink" />
	<xsl:apply-templates select="//og:viewMarker[not(@isRenderer)]" />
	<xsl:apply-templates select="//og:input" />
	<xsl:apply-templates select="//og:columnCheck" />
	<xsl:apply-templates select="//og:column" />
<!-- 6.9.9.3 (2018/09/25) og:hidden を除外します。
	<xsl:apply-templates select="//og:column | //og:input | //og:select | //og:hidden | //og:submit | //og:textarea | //input | //select | //textarea" mode="form-in" />
-->
	<xsl:apply-templates select="//og:column | //og:input | //og:select | //og:submit | //og:textarea | //input | //select | //textarea" mode="form-in" />
	<xsl:apply-templates select="//form" />
	<xsl:apply-templates select="//og:frame" />
	<xsl:apply-templates select="//og:iframe" />
	<xsl:apply-templates select="//og:message" />
	<xsl:apply-templates select="//og:appear" />
	<xsl:apply-templates select="//og:forward" />
	<xsl:apply-templates select="//og:comment" />
	<xsl:apply-templates select="//og:queryButton" />
	<xsl:apply-templates select="//og:hideMenu" />
	<xsl:apply-templates select="//og:tableUpdate" />
	<xsl:apply-templates select="//og:topMenu" />

	<xsl:apply-templates select="//og:directTableInsert" />
	<xsl:apply-templates select="//og:iGanttBar" />						<!-- 6.9.9.0 (2018/08/20) Add -->
	<xsl:apply-templates select="//og:crossParam" />					<!-- 7.0.1.5 (2018/12/10) Add -->

<!-- 7.0.5.0 (2019/09/09) チェック廃止 問合・ﾄﾗﾌﾞﾙ (61200-190823-02) ②
	<xsl:apply-templates select="//og:splitView" />						7.0.1.5 (2018/12/10) Add
-->
	<xsl:apply-templates select="//og:thead" />							<!-- 7.0.2.1 (2019/02/25) Add -->

	<xsl:apply-templates select="//og:dataCheck" />						<!-- 7.0.6.4 (2019/11/29) Add -->

	<xsl:apply-templates select="//*[@msg]   | //*[@msgParamKeys]" />
	<xsl:apply-templates select="//*[@width] | //*[@height]" />

	<xsl:apply-templates select="//*[starts-with(@onClick,'window_open')]" />
	<xsl:apply-templates select="//*[@tableId]" />
	<xsl:apply-templates select="//*[@optionAttributes]" />
	<xsl:apply-templates select="//*[@style]" />
	<xsl:apply-templates select="//*[@clazz]" />					<!-- 6.2.0.0 (2015/02/21) -->
	<xsl:apply-templates select="//*[@aimai]" />					<!-- 6.4.7.1 (2016/06/17) -->
	<xsl:apply-templates select="//*[@accesskey='D']" />
	<xsl:apply-templates select="//*[@caseNN='true'] | //*[@isRenderer='true'] | //*[@markList='true'] | //*[@onLink='true'] | //*[@useGamenId='true']" />
	<xsl:apply-templates select="//*[@debug='false'] | //*[@noMessage='false'] | //*[@nullCheck='false'] | //*[@stopZero='false'] | //*[@useCache='false'] | //*[@useParam='false']" />
	<xsl:apply-templates select="//*[@debug='true']"  />			<!-- 6.3.9.1 (2015/11/27) -->
	<xsl:apply-templates select="//*[@queryType='JDBCPrepared']" />

	<xsl:apply-templates select="//jsp:text" />
	<xsl:apply-templates select="//tr" />							<!-- 5.10.13.0 (2019/07/01),7.0.4.3 (2019/07/15) -->
	<xsl:apply-templates select="//frameset" />
	<xsl:apply-templates select="//script" />
	<xsl:apply-templates select="//link" />
	<xsl:apply-templates select="//style" />
	<xsl:apply-templates select="//span[@type='jsp:directive']" />

	<xsl:apply-templates select="//iBar | //iGanttBar | //iGantt | //iHead | //iMatrix | //iTable | //iTask" mode="iSeries-in" />

	<!-- QUERY文字列から、クオート処理されていないラベルを見つけます。 -->
	<xsl:apply-templates mode="sql" select="//og:query | //og:update | //og:plsqlUpdate | //og:tableUpdate | //og:entryQuery" />
	<xsl:apply-templates mode="sql" select="//og:value[@command='SQL'] | //og:value[@command='SET'] | //og:userInfo[@command='SQL'] | //og:tableUpdateParam" />
	<xsl:apply-templates mode="sql" select="//og:writeTableParam[@key='MergeSql']" />
	<xsl:apply-templates mode="sql" select="//og:queryOption" />
	<xsl:apply-templates mode="sql" select="//og:directWriteTable" />
	<xsl:apply-templates mode="sql" select="//og:tableFilter[@classId='DBSELECT']" />
	<xsl:apply-templates mode="sql" select="//og:chartDataset[not(@useTableData='true')]" />
	<xsl:apply-templates mode="sql" select="//og:dataCheck" />
	<xsl:apply-templates mode="sql" select="//og:columnEditor[(@renderer='DBMENU' or @editor='DBMENU')]" />
	<xsl:apply-templates mode="sql" select="//og:column[(@renderer='DBMENU' or @editor='DBMENU' or @eventColumn) and @param]" />
	<xsl:apply-templates mode="sql" select="//og:hidden" />

	<xsl:if test="not(//og:comment) and (starts-with($FILENAME,'query') or starts-with($FILENAME,'result') or starts-with($FILENAME,'update') or starts-with($FILENAME,'entry'))" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >CAUTION01</MSGCD>
		<MSGTXT >og:comment タグを記述して下さい。</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>

	<xsl:if test="($FILENAME='copy.jsp') or ($FILENAME='modify.jsp') or ($FILENAME='delete.jsp') or ($FILENAME='insert.jsp')" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >WARNING10</MSGCD>
		<MSGTXT ><xsl:value-of select="$FILENAME" /> は、update.jsp として統合する方向で検討してください。</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>

	<xsl:if test="(contains($FILENAME,'コピー') or string-length($FILENAME) &gt; 20)" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >WARNING04A</MSGCD>
		<MSGTXT ><xsl:value-of select="$FILENAME" /> は、ファイル名が長すぎます(制限20字 ⇒ <xsl:value-of select="string-length($FILENAME)" />字)。
バックアップファイルならば、backup フォルダに移動してください。</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>
  </xsl:template>

  <xsl:template match="og:sql" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02A</MSGCD>
		 <MSGTXT >og:sql タグは廃止クラスです。代わりに og:valueタグを使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:update" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02B</MSGCD>
		 <MSGTXT >og:update タグは廃止クラスです。代わりに og:tableUpdateタグを使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:tableExist" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02C</MSGCD>
		 <MSGTXT >og:tableExist タグは廃止クラスです。代わりに og:dataCheckタグを使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:tabTable | og:tab" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR03A</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグは廃止クラスです。og:tabLink、og:tabList の使用をご検討ください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:stackHeader" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02E</MSGCD>
		 <MSGTXT >og:stackHeader タグは廃止クラスです。代わりに og:ganttHeaderタグを使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:link" >
	 <xsl:if test="@value" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02F</MSGCD>
		 <MSGTXT >og:link タグのvalue属性は廃止属性です。vals属性を使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@keys) and (@value | @vals)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR05</MSGCD>
		 <MSGTXT >og:link タグのvals属性とペアの keys属性が存在しません。keys,vals属性はセットで使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@gamenId) and starts-with(@href,'../') and not(@useGamenId='false')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR06</MSGCD>
		 <MSGTXT >og:link タグで別画面へ飛ばす場合は、gamenId属性を使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@keys) and contains(@href,'?')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR07</MSGCD>
		 <MSGTXT >og:link タグの href でパラメータを渡す場合、keys,vals属性を使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	<!--  2015/11/24 ERROR07A との区別が難しいので、@gamenId がない場合に限定します。-->
	 <xsl:if test="not(@href) and not(@name) and not(@gamenId)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING14</MSGCD>
		 <MSGTXT >og:link タグの href属性は、できるだけ指定してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@href) and @gamenId" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR07A</MSGCD>
		 <MSGTXT >og:link タグの href属性は、画面ID指定時(gamenId="****")は、必須です。指定してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:head" >
	 <xsl:if test="@useTimeSet | @useToggleFrame | @useInputFocus | @useHilightRow | @usePrintLine | @useRealTimeCheck | @useAutoConvert | @useFocusHilight | @useFocusFirstElm | @useAdjustFrameHeight | @useGuest" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04B</MSGCD>
		 <MSGTXT >og:head タグの属性に廃止属性
			「<xsl:for-each select="(@useTimeSet | @useToggleFrame | @useInputFocus | @useHilightRow | @usePrintLine | @useRealTimeCheck | @useAutoConvert | @useFocusHilight | @useFocusFirstElm | @useAdjustFrameHeight | @useGuest)" >
				<xsl:value-of select="name()" /> , </xsl:for-each>」が含まれます。
				代替方法はありませんので、廃止属性を削除してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@useTabstrip" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04B</MSGCD>
		 <MSGTXT >og:head タグの属性に廃止属性「useTabstrip」が含まれます。この属性は、すでに使われていません。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	<!-- jspInclude=true の場合、include が取り込まれるため、代替え span タグでチェックする。-->
	 <xsl:if test="preceding::span[@type='jsp:directive' and ( contains(@include,'query_info') or contains(@include,'result_info') )]" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR08</MSGCD>
		 <MSGTXT >og:head タグより前に、query_info/result_info がインクルードされています。og:head タグの後ろに移動してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	<!-- jspInclude=true の場合、include が取り込まれるため、代替え span タグでチェックする。-->
	 <xsl:if test="(not($FILENAME='forward.jsp') and not(//span[@type='jsp:directive' and @include='/jsp/common/htmlend.jsp']))" >
		<xsl:if test="not(@headType='simple') and not(@headType='xml')" >
		   <ROW>
			 <xsl:copy-of select="$row_header" />
			 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
			 <MSGCD  >WARNING23</MSGCD>
			 <MSGTXT >og:head タグを記述する場合は、/jsp/common/htmlend.jsp ファイルをインポートしてください。</MSGTXT>
			 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
		   </ROW>
		</xsl:if>
	 </xsl:if>
	 <xsl:if test="@useIE7Header" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04C</MSGCD>
		 <MSGTXT >og:head タグのuseIE7Header属性は廃止属性です。false固定になりました。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@useHTML5Modal" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04C</MSGCD>
		 <MSGTXT >og:head タグのuseHTML5Modal属性は廃止属性です。true固定になりました。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <!-- 6.9.5.0 (2018/04/23) -->
  <xsl:template match="og:help" >
	 <xsl:if test="@extension" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04F</MSGCD>
		 <MSGTXT >og:help タグのextension属性は廃止属性です。属性を削除してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:writeTable" >
	 <xsl:if test="@direct" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04C</MSGCD>
		 <MSGTXT >og:writeTable タグのdirect属性は廃止属性です。結果をダイレクトするとエンコード等でおかしな動きをする可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@disposition" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04C</MSGCD>
		 <MSGTXT >og:writeTable タグのdisposition属性は廃止属性です。direct属性が有効時しか、利用できませんでした。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:option" >
	 <xsl:if test="@code" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04D</MSGCD>
		 <MSGTXT >og:option タグのcode属性は廃止属性です。カラムリソースで、コードカラム属性を定義して使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="ancestor::og:queryOption" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING18</MSGCD>
		 <MSGTXT >og:option タグは、queryOption タグのBODY部に入れずに、og:select タグの直下に配置してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:value" >
	 <xsl:if test="@nullSet" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04E</MSGCD>
		 <MSGTXT >og:value タグのnullSet属性は廃止属性です。属性そのものを削除してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="last() &gt; 10 and position()=last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING02B</MSGCD>
		 <MSGTXT >og:value タグを使いすぎです(制限10個 ⇒ <xsl:value-of select="last()" />個)。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="count(//og:value[@command='SQL' and contains(*,'DUAL')]) &gt; 1" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING06</MSGCD>
		 <MSGTXT >og:value タグの SQL 構文で、DUAL を複数使用しています。まとめる事が可能か検討してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
<!-- 7.0.6.4 (2019/11/29) value の JavaScript は廃止方向 -->
	 <xsl:if test="@action='EXEC'" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR27</MSGCD>
		 <MSGTXT >新しいJavaでは、JavaScript の実行が出来なくなる可能性があります。action='EXEC' は廃止です。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:hidden" >
	 <xsl:if test="@names" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02G</MSGCD>
		 <MSGTXT >og:hidden タグのnames属性は廃止属性です。keys属性を使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(@name and @keys) or (@value and @vals) or (@name and @vals) or (@keys and @value)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR09</MSGCD>
		 <MSGTXT >og:hidden タグは、name,value属性のペアか、keys,valsのペアで指定してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="string-length(@value) &gt; 80" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING04B</MSGCD>
		 <MSGTXT >og:hidden タグの value属性の文字数が多すぎます(制限80字 ⇒ <xsl:value-of select="string-length(@value)" />字)。
						value属性は、BODY部に記述することも可能です。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="string-length(.) &gt; 1000" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING01B</MSGCD>
		 <MSGTXT >og:hidden タグの設定文字数が多すぎます(制限1000文字 ⇒ <xsl:value-of select="string-length(.)" />文字)。
						includeするか、データベースから取得することを検討ください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	<!-- 6.9.9.3 (2018/09/25) form内チェックを、hidden単独で行います。 -->
	 <xsl:if test="not(ancestor::form) and not(@noForm='true')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR16B</MSGCD>
		 <MSGTXT >og:hidden タグが、form タグの中にありません。formから除外する場合は、noForm="true" 属性を付けてください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="ancestor::form and @noForm='true'" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR16A</MSGCD>
		 <MSGTXT >noForm="true" 属性がセットされているog:hidden タグが、form タグの中にあります。これが通常の hidden の場合は、noForm="true" 属性をはずしてください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:columnEditor" >
	 <xsl:if test="@parameter" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02H</MSGCD>
		 <MSGTXT >og:columnEditor タグのparameter属性は廃止属性です。param属性を使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@editor='RADIO2'" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02H</MSGCD>
		 <MSGTXT >og:columnEditor タグのeditor属性で、RADIO2 は廃止されました。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <!-- og:dataCheck , og:error , og:input , og:option , og:orderBy , og:schedule -->
  <xsl:template match="*[@msg] | *[@msgParamKeys]" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02I</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> の msg属性や msgParamKeys属性は廃止属性です。lbl属性,lblParamKeys属性に置き換えてください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:topMenu" >
	 <xsl:if test="@useButtonScript" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04F</MSGCD>
		 <MSGTXT >og:topMenu タグのuseButtonScript属性は廃止属性です。属性を削除してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <!-- 6.2.2.0 (2015/03/27) -->
  <xsl:template match="og:directTableInsert" >
	 <xsl:if test="@useColumnAdjust" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02J</MSGCD>
		 <MSGTXT >og:directTableInsert タグのuseColumnAdjust属性は廃止属性です。代わりに、adjustColumns属性を指定してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@useColumnCheck" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02K</MSGCD>
		 <MSGTXT >og:directTableInsert タグのuseColumnCheck属性は廃止属性です。代わりに、checkColumns属性を指定してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <!-- 6.9.9.0 (2018/08/20) Add -->
  <xsl:template match="og:iGanttBar" >
	 <xsl:if test="@startInput" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02J</MSGCD>
		 <MSGTXT >og:iGanttBar タグのstartInput属性は廃止属性です。代わりに、startDateInput属性を指定してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@endInput" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02K</MSGCD>
		 <MSGTXT >og:iGanttBar タグのendInput属性は廃止属性です。代わりに、endDateInput属性を指定してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@chbox" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02K</MSGCD>
		 <MSGTXT >og:iGanttBar タグのchbox属性は廃止属性です。内部で使用されるので不要です。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <!-- og:chartCreate , og:image , og:popup , og:space , og:tabLink , og:view , og:iHead -->
  <xsl:template match="*[@width] | *[@height]" >
	 <xsl:if test="not(string(number(@width | @height))='NaN') and not(name()='og:chartCreate') and not(name()='canvas')">
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR10</MSGCD>
		 <MSGTXT >width や height属性 を指定する場合は、単位(pt,px,%)が必要です。(IE7 必須)</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

<!-- スペースの数は含めないことにします。 -->
  <xsl:template match="og:query" >
	 <xsl:if test="string-length(normalize-space(.)) &gt; 1000" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING01A</MSGCD>
		 <MSGTXT >og:query タグの設定文字数が多すぎます(制限1000文字 ⇒ <xsl:value-of select="string-length(normalize-space(.))" />文字)。
					QUERY文を見直してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
<!-- 2015/11/24 queryタグが複数存在する場合は、mainTrans 属性が必要。処理追加 -->
<!--
	 <xsl:if test="last() &gt; 1 and not(@mainTrans) and not(@tableId) and not(@scope='request')" >
-->
<!-- 2018/05/01 queryタグが複数存在する場合は、mainTrans 属性か、scope='request' で、かつ、include されていない場合 -->
	 <xsl:if test="count(//og:query[not(@mainTrans) and not(@scope='request')]) &gt; 1 and not( preceding::span[@type='jsp:directive'] )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING32</MSGCD>
		 <MSGTXT >og:query タグが複数存在する場合は、mainTrans 属性を使用して、DBTableModel の対象を指定してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:userInfo" >
	 <xsl:if test="last() &gt; 10 and position()=last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING02A</MSGCD>
		 <MSGTXT >og:userInfo タグを使いすぎです(制限10個 ⇒ <xsl:value-of select="last()" />個)。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:view" >
	 <xsl:if test="descendant::og:message" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >CAUTION02</MSGCD>
		 <MSGTXT >og:message タグは、{@LBL.XXXX} に置き換え可能です。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@useScrollBar) and (ancestor::table | ancestor::div)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21A</MSGCD>
		 <MSGTXT >og:view タグを、table,div などで囲うとヘッダー固定が崩れる可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@useScrollBar) and ((following::og:link) | (following::og:column)) and not(ancestor::og:equals) and not(ancestor::og:case)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21B</MSGCD>
		 <MSGTXT >og:view タグの後ろに、link や column タグがあると、ヘッダー固定時に見えなくなります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@useScrollBar) and (last() &gt; 1) and not(ancestor::og:equals) and not(ancestor::og:case)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21C</MSGCD>
		 <MSGTXT >og:view タグが複数存在すると、ヘッダー固定が崩れる可能性があります。どちらかの og:view を、useScrollBar="false" でヘッダー固定を解除してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@useScrollBar='true'" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21D</MSGCD>
		 <MSGTXT >og:view のヘッダー固定指定(useScrollBar='true')は、推奨機能なので、個別に設定しないでください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	<!-- 7.0.4.0 (2019/05/31) nth-child 指定のレイアウト崩れチェック追加 -->
<!-- equals が上位にいるかどうかの判定では、漏れる
	 <xsl:if test="(position()=last()) and count(//og:view[(@viewFormType='HTMLTable') and not(@tableId) and not(@viewClass) and not(ancestor::og:equals) and not(ancestor::og:case)]) &gt; 1" >
-->
	<!-- 7.0.4.1 (2019/06/10) equals が上位にいるかどうかの判定ではなく、同一レベルに複数存在するかどうかで判定します。 -->
	 <xsl:if test="count(following-sibling::og:view[(@viewFormType='HTMLTable') and not(@tableId) and not(@viewClass)]) &gt;= 1" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21E</MSGCD>
		 <MSGTXT >複数のog:view タグで使用する場合、tableIdで区別するか、viewClassで区別しないとレイアウトが崩れる可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:submit" >
	 <xsl:if test="not(//og:writeCheck)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR11A</MSGCD>
		 <MSGTXT >og:submit タグは、og:writeCheck タグの子要素として使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(starts-with($FILENAME,'query') and not(//og:queryButton))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING19</MSGCD>
		 <MSGTXT >og:submit タグが、og:queryButton タグに置き換え可能か検討してみてください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
<!-- 2015/11/24 ３ペインの場合、command="VIEW" で、value="update" しているので、 WARNING から除外します。-->
	 <xsl:if test="@value='update'" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING24A</MSGCD>
		 <MSGTXT >og:submit タグで、value="update" は、action属性で置換えを検討してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(starts-with($FILENAME,'update') and (@value='entry' or @value='reset'))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING24B</MSGCD>
		 <MSGTXT >og:submit タグで、value="entry" 又は "entry" の場合は、action属性で置換えを検討してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@accesskey and not(@action)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING24C</MSGCD>
		 <MSGTXT >og:submit タグで、action属性を使うと、accesskeyは初期設定されます。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:writeCheck" >
	 <xsl:if test="not(descendant::og:submit)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR11B</MSGCD>
		 <MSGTXT >og:writeCheck タグの子要素には、og:submit タグを使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
<!--
	 <xsl:if test="last() &gt; 1 and not(ancestor::og:equals)" >
-->
	 <xsl:if test="(position()=last()) and count(//og:writeCheck[not(ancestor::og:equals) and not(ancestor::og:case)]) &gt; 1" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING07</MSGCD>
		 <MSGTXT >og:writeCheck タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(starts-with($FILENAME,'result') and not(//og:errorMessage))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING16</MSGCD>
		 <MSGTXT >og:writeCheck タグを使用する場合は、og:errorMessage タグを記述して下さい。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	  </xsl:if>
  </xsl:template>

  <xsl:template match="og:button" >
	 <xsl:if test="(starts-with($FILENAME,'query') and @type='submit' and not(//og:queryButton))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING20</MSGCD>
		 <MSGTXT >og:button タグが、og:queryButton タグに置き換え可能か検討してしてください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:equals" >
	 <xsl:if test="last() &gt; 10 and position()=last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING02C</MSGCD>
		 <MSGTXT >og:equals タグを使いすぎです(制限10個 ⇒ <xsl:value-of select="last()" />個)。
og:switch～og:caseタグやcaseKey,caseVal,caseNN属性等を使用してソースを判りやすく記述してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:entry" >
	 <xsl:if test="(position()=last()) and count(//og:entry[not(ancestor::og:equals) and not(ancestor::og:case)]) &gt; 1" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR12</MSGCD>
		 <MSGTXT >og:entry タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:viewLink" >
<!--
	 <xsl:if test="last() &gt; 1 and not(ancestor::og:equals) and not(preceding::og:view) and not(parent::og:tab)" >
-->
	<!-- カウント時に、equals と case がある場合は、除外しておきます。 -->
	 <xsl:if test="count(//og:viewLink[not(ancestor::og:equals) and not(ancestor::og:case)]) &gt; 1" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR13</MSGCD>
		 <MSGTXT >og:viewLink タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:viewMarker[not(@isRenderer)]" >
<!--
	 <xsl:if test="last() &gt; 1 and position()=last() and not(ancestor::og:equals)" >
-->
	<!-- カウント時に、equals と case がある場合は、除外しておきます。 -->
	 <xsl:if test="count(//og:viewMarker[not(@isRenderer) and not(ancestor::og:equals) and not(ancestor::og:case)]) &gt; 1" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR14</MSGCD>
		 <MSGTXT >og:viewMarker タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:input" >
	 <xsl:if test="(//og:writeCheck) and (@type='submit')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING08</MSGCD>
		 <MSGTXT >og:input タグは、og:writeCheck タグの子要素として使用しないでください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:columnCheck" >
	 <xsl:if test="preceding::og:entry" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR15A</MSGCD>
		 <MSGTXT >og:columnCheck タグでチェックする前に、og:entry タグがあります。エラーの可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(//og:entry) and starts-with($FILENAME,'result') and (//og:writeCheck)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR15B</MSGCD>
		 <MSGTXT >og:columnCheck タグのチェック後に、og:entry タグがありません。エラーの可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
<!-- 2015/11/24 Linkで他の画面型飛んできた場合は、nullCheck が必要なので、WARNING から除外します。
	 <xsl:if test="(@nullCheck or @mustAnyCheck) and not(ancestor::og:equals) and not(ancestor::og:case)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING17</MSGCD>
		 <MSGTXT >og:columnCheck タグの nullCheck属性と mustAnyCheck属性は自動チェックされます。設定不要です。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
-->
  </xsl:template>

  <xsl:template match="og:column" >
	 <xsl:if test="last() &gt; 12 and position()=last() and not(//og:hideMenu) and starts-with($FILENAME,'query')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING02E</MSGCD>
		 <MSGTXT >og:column タグを使いすぎです(制限12個 ⇒ <xsl:value-of select="last()" />個)。og:hideMenu を使って、検索条件の絞り込みを行いましょう。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@useBody" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02J</MSGCD>
		 <MSGTXT >og:column タグのuseBody属性は廃止属性です。属性を削除してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@editor='RADIO2'" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02H</MSGCD>
		 <MSGTXT >og:column タグのeditor属性で、RADIO2 は廃止されました。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

<!-- 6.9.9.3 (2018/09/25) og:hidden を除外します。
  <xsl:template match="og:column | og:input | og:select | og:hidden | og:submit | og:textarea | input | select | textarea" mode="form-in" >
-->
  <xsl:template match="og:column | og:input | og:select | og:submit | og:textarea | input | select | textarea" mode="form-in" >
	 <xsl:if test="not(@writable='false' or @writable='FALSE') and not(ancestor::form) and not(@onClick='history.back()')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR16</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグが、form タグの中にありません。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="iBar | iGanttBar | iGantt | iHead | iMatrix | iTable | iTask" mode="iSeries-in" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR22</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグではなく、og:<xsl:value-of select="name()" /> タグを使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="form" >
	 <xsl:if test="starts-with(@action,'../')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR17</MSGCD>
		 <MSGTXT >form タグの action属性に、相対パスを使用するのは避けてください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="descendant::og:view and not(@method='POST')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING11</MSGCD>
		 <MSGTXT >テーブル登録時の form タグには、method="POST" を使用することを検討してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>

	<!--  2017/05/16 ３ペイン(target="INPUT")の場合と、useAjaxSubmit='true'は、oneClick は入れません。-->
	 <xsl:if test="descendant::og:view and descendant::og:submit[@action='ENTRY'] and not(starts-with(@onSubmit,'return oneClick')) and not(//og:head[@noTransition='true']) and not(//og:head[@useAjaxSubmit='true']) and not(@target='INPUT')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING12</MSGCD>
<!--	 <MSGTXT >テーブル登録時の form タグには、２度押し防止JavaScript(return oneClick();)の使用を検討してください(３ペインの場合は、target="INPUT"のみ除外しています)。</MSGTXT>	-->
		 <MSGTXT >テーブル登録時は、２度押し防止JavaScript(formのreturn oneClick(); か、headのuseAjaxSubmit='true')の使用を検討してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>

	<!--  2017/05/16 useAjaxSubmit='true'と、oneClick は同時には入れません。 -->
	 <xsl:if test="descendant::og:view and starts-with(@onSubmit,'return oneClick') and (//og:head[@useAjaxSubmit='true'])" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR23</MSGCD>
		 <MSGTXT >og:head タグに、useAjaxSubmit='true' を使用する場合は、form タグに、２度押し防止(return oneClick();) を使用できません。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:frame" >
	 <xsl:if test="starts-with(@src,'../')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING15</MSGCD>
		<!-- 2015/11/24 対応方法を追加します。 -->
		 <MSGTXT >og:frame タグの src属性に、相対パスを指定するのは、良くない慣習です。(例： src="../common/***" → src="{@SYS.JSP}/common/***")</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@marginwidth | @marginheight | @noresize | @scrolling | @frameborder" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04B</MSGCD>
		 <MSGTXT >og:frame タグの属性に廃止属性
			「<xsl:for-each select="(@marginwidth | @marginheight | @noresize | @scrolling | @frameborder)" >
			<xsl:value-of select="name()" /> , </xsl:for-each>」が含まれます。
				代替方法はありませんので、廃止属性を削除してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <!-- 6.9.5.0 (2018/04/23) -->
  <xsl:template match="og:iframe" >
	 <xsl:if test="@marginwidth | @marginheight | @noresize | @scrolling | @frameborder" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04B</MSGCD>
		 <MSGTXT >og:frame タグの属性に廃止属性
			「<xsl:for-each select="(@marginwidth | @marginheight | @noresize | @scrolling | @frameborder)" >
				<xsl:value-of select="name()" /> , </xsl:for-each>」が含まれます。
				代替方法はありませんので、廃止属性を削除してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@seamless" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04G</MSGCD>
		 <MSGTXT >iframeの seamless 属性は、HTML Standard 仕様において削除されています。属性を削除してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:message" >
	 <xsl:if test="last() &gt; 10 and position()=last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING02D</MSGCD>
		 <MSGTXT >og:message タグを使いすぎです(制限10個 ⇒ <xsl:value-of select="last()" />個)。{@LBL.XXXX} に置き換え可能です。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@comment and not(@lbl)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING34</MSGCD>
		<!-- 2016/11/12 追加します。 -->
		 <MSGTXT >og:message タグの comment属性のみで使用しないでください。基本的には、メッセージは、lbl属性で設定してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:appear" >
	 <xsl:if test="not(@defaultVal)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR18</MSGCD>
		 <MSGTXT >og:appear タグで、defaultVal属性を指定しないと、SQL構文エラーになる可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
<!--  2015/11/24 ORDER BY 以外にも、GROUP BY や HAVING で使うケースがあります。-->
	 <xsl:if test= "not(contains(@startKey,'order by')) and not(contains(@startKey,'ORDER BY'))
				and not(contains(@startKey,'group by')) and not(contains(@startKey,'GROUP BY'))
				and not(contains(@startKey,'having'))   and not(contains(@startKey,'HAVING'))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING22A</MSGCD>
		 <MSGTXT >og:appear タグは、startKey="ORDER BY" の専用タグと考えてください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(@startKey='order by' or @startKey='ORDER BY') and ( not(contains(@value,'order_by')) and not(contains(@value,'ORDER_BY')))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING22B</MSGCD>
		 <MSGTXT >og:appear タグの、value属性は、標準的には、{&#64;ORDER_BY} の引数を与えるように統一してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:forward" >
	 <xsl:if test="not(@gamenId) and starts-with(@page,'../')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR19</MSGCD>
		 <MSGTXT >og:forward タグで別画面へ飛ばす場合は、gamenId属性を使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:comment" >
	 <xsl:if test="not(@system) or not(@pgid)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR20</MSGCD>
		 <MSGTXT >og:comment タグのシステム名(system)、プログラムID(pgid)は必須です。記述して下さい。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(contains(@system,$SYSTEM_ID))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >CAUTION03</MSGCD>
		 <MSGTXT >og:comment タグ の system(=<xsl:value-of select="@system" />)が、システムID(=<xsl:value-of select="$SYSTEM_ID" />)と合っているか確認してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
<!-- 2015/11/24 ｲﾝｸﾙｰﾄﾞしたﾌｧｲﾙのPGID とは合わないため、最初だけ比較します。-->
	 <xsl:if test="not(@pgid=$ADDRESS) and position()=1" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >CAUTION04</MSGCD>
		 <MSGTXT >og:comment タグ の pgid(=<xsl:value-of select="@pgid" />)が、アドレス(=<xsl:value-of select="$ADDRESS" />)と合っているか確認してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:queryButton" >
	 <xsl:if test="//og:select[@name='ORDER_BY'] and not(descendant::og:select) and starts-with($FILENAME,'query')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >CAUTION05</MSGCD>
		 <MSGTXT >並び順(ORDER_BY)の og:select タグを使うときは、og:queryButton のBODY部に記述するとスペースが節約できます。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@useCrear" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02L</MSGCD>
		 <MSGTXT >og:queryButton タグのuseCrear属性は廃止属性です。useClear属性を使用してください。6.4.4.0 (2016/03/11)以降</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:hideMenu" >
	 <xsl:if test="following::og:queryButton and starts-with($FILENAME,'query')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >CAUTION06</MSGCD>
		 <MSGTXT >og:hideMenu は、og:queryButton より後ろに書くと、ボタンの位置が動かないので良いです。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <!-- 7.0.1.5 (2018/12/10) Add -->
  <xsl:template match="og:crossParam" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >CAUTION07A</MSGCD>
		 <MSGTXT >クロステーブルを使用する際は、画面リソースのモード３桁目に「f」を指定し、Edit機能の表示項目設定を使用しないで下さい。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <!-- 7.0.1.5 (2018/12/10) Add -->
<!-- 7.0.5.0 (2019/09/09) チェック廃止 問合・ﾄﾗﾌﾞﾙ (61200-190823-02) ②
  <xsl:template match="og:splitView" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >CAUTION07B</MSGCD>
		 <MSGTXT >左右分割スクロールを使用する際は、画面リソースのモード３桁目に「f」を指定し、Edit機能の表示項目設定を使用しないで下さい。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>
-->

  <xsl:template match="og:tableUpdate" >
	 <xsl:if test="not(descendant::og:tableUpdateParam)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING30</MSGCD>
		 <MSGTXT >og:tableUpdate タグの使用時には、QUERYの指定に、og:tableUpdateParam タグが利用できないか検討願います。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="*[starts-with(@onClick,'window_open')]" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING09</MSGCD>
		 <MSGTXT >window_open の代わりに、og:popup タグの使用を検討してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="*[@tableId]" >
	 <xsl:if test="last() &gt; 3 and position()=last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING05</MSGCD>
		 <MSGTXT >tableId属性を使いすぎです(制限3個 ⇒ <xsl:value-of select="last()" />個)。あまり使うとメモリが解放されなくなります。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="*[@optionAttributes]" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING29</MSGCD>
		 <MSGTXT >optionAttributes属性は、古い仕様です。JavaScriptのイベント系(onChange,onBlur等)は専用属性をご使用ください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="*[@style]" >
	 <xsl:if test="string-length(@style) &gt; 80" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING04C</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグの style属性が長すぎます(制限80字 ⇒ <xsl:value-of select="string-length(@style)" />字)。idもしくは classセレクタを指定し、外部ファイル(href属性)に記述しましょう。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
<!-- 7.0.1.5 (2018/12/10) style='display:none' は、og:thead 内部では使わないほうが良い。 -->
<!-- ロジックミス。7.0.2.1 (2019/02/25) で、別処理に移行
	 <xsl:if test="contains(@style,'display') and contains(@style,'none')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR25</MSGCD>
		 <MSGTXT >og:theadの子要素の <xsl:value-of select="name()" /> タグで、style='display:none' を記述すると、edit機能使用時に画面に表示されてしまいます。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
-->
  </xsl:template>

<!-- 7.0.2.1 (2019/02/25) style='display:none' は、og:thead 内部では使わないほうが良い。 -->
  <xsl:template match="og:thead" >
	 <xsl:if test="(descendant::*[@style])" >
		 <xsl:if test="contains(@style,'display') and contains(@style,'none')" >
		   <ROW>
			 <xsl:copy-of select="$row_header" />
			 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
			 <MSGCD  >ERROR25</MSGCD>
			 <MSGTXT >og:theadの子要素の <xsl:value-of select="name()" /> タグで、style='display:none' を記述すると、edit機能使用時に画面に表示されてしまいます。</MSGTXT>
			 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
		   </ROW>
		 </xsl:if>
	 </xsl:if>
  </xsl:template>

<!-- 7.0.6.4 (2019/11/29) dataCheck の JavaScript は廃止方向 -->
<!-- 7.0.7.2 (2019/12/26) from属性があれば、内部でSelect文を作成しているため、OK -->
  <xsl:template match="og:dataCheck" >
	<xsl:variable name="SEL" select="translate( . ,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )" />	<!-- BODY部分の 小文字 大文字変換 -->
	 <xsl:if test="@command='ENTRY' and not(@uniqCheckClms) and not(@from) and not( contains($SEL,'SELECT') )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR27</MSGCD>
		 <MSGTXT >新しいJavaでは、JavaScript の実行が出来なくなる可能性があります。command='ENTRY' で uniqCheckClms 未使用で SELECT処理でないケースは廃止です。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@command='NEW' and not(@from) and not( contains($SEL,'SELECT') )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR27</MSGCD>
		 <MSGTXT >新しいJavaでは、JavaScript の実行が出来なくなる可能性があります。command='NEW' で SELECT処理でないケースは廃止です。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="*[@clazz='aimai']" >					<!-- 6.2.0.0 (2015/02/21) -->
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING31A</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> name="<xsl:value-of select="@name" />" 曖昧指定は、aimai="true" か、aimai="V*" (又は、V,*V,*V*) 表記に変更しましょう。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="*[@aimai]" >							<!-- 6.4.7.1 (2016/06/17) -->
	 <xsl:if test="string-length(@aimai) &gt; 3 and not(@aimai='true')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING31B</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> name="<xsl:value-of select="@name" />" 曖昧指定は、aimai="true" か、aimai="V*" (又は、V,*V,*V*) 表記に変更しましょう。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="*[@accesskey='D']" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR03B</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグで、accesskey='D' は使えません。DELETE なら、'Z' を使ってください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="*[@queryType='JDBCPrepared']" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR03C</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグで、queryType='JDBCPrepared' は廃止されました。代わりに、JDBCTableUpdate を使用ください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="*[@caseNN='true'] | *[@isRenderer='true'] | *[@markList='true'] | *[@onLink='true'] | *[@useGamenId='true']" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING25A</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグの <xsl:for-each select="(@caseNN | @isRenderer | @markList | @onLink | @useGamenId)" >
				<xsl:if test="(.='true')"><xsl:value-of select="name()" /> , </xsl:if>
			</xsl:for-each>属性は、初期値 true ですので、初期値をあえて設定する必要はありません。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="*[@debug='false'] | *[@noMessage='false'] | *[@nullCheck='false'] | *[@stopZero='false'] | *[@useCache='false'] | *[@useParam='false']" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING25B</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグの <xsl:for-each select="(@debug | @noMessage | @nullCheck | @stopZero | @useCache | @useParam)" >
				<xsl:if test="(.='false')"><xsl:value-of select="name()" /> , </xsl:if>
			</xsl:for-each>属性は、初期値 false ですので、初期値をあえて設定する必要はありません。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

<!-- 6.3.9.1 (2015/11/27) 新規追加 debug属性に true が直接記述されているケースを警告する。 -->
  <xsl:template match="*[@debug='true']" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING33</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグの debug 属性に、"true" が直接記述されています。debug="{@debug}" の様に引数を渡してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="jsp:text" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING26</MSGCD>
		 <MSGTXT >jsp:text は、jsp:root 直下以外では使われなくなりました。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	<!-- 5.10.8.2 (2019/02/22) tomcat8でjsp:textの子要素としてタグが利用できないため、チェック用に追加しておきます。 -->
	<xsl:if test="count( child::* ) &gt; 0" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR26</MSGCD>
		 <MSGTXT >jsp:textタグの内部にタグを書くと、tomcat8以降でエラーとなります。jsp:textを削除するか、場合によってはCDATAを利用してください。</MSGTXT>
		 <TEXT_DATA   ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

<!-- 5.10.13.0 (2019/07/01),7.0.4.3 (2019/07/15) -->
  <xsl:template match="tr" >
<!--
	 <xsl:if test="count(*[not(descendant-or-self::og:*) and not(descendant-or-self::td)]) &gt; count(*[not(descendant-or-self::og:*) and not(descendant-or-self::td)]/ancestor::td)" >
-->
	 <xsl:if test="count(*[not(descendant-or-self::og:*) and not(descendant-or-self::th) and not(descendant-or-self::td)]) &gt; count(*[not(descendant-or-self::og:*) and not(descendant-or-self::th) and not(descendant-or-self::td)]/ancestor::td)" >
	   <xsl:if test="not(span[@type='jsp:directive'])" >
		   <ROW>
			 <xsl:copy-of select="$row_header" />
			 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
			 <MSGCD  >WARNING35</MSGCD>
			 <MSGTXT >trタグ内にtdタグで囲んでいない要素があります。</MSGTXT>
			 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
		   </ROW>
	    </xsl:if>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="frameset" >
	 <xsl:if test="not(@name='SUB_FRAME') and not(@name='TOP_FRAME') and not(@name='RES_FRAME')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING13</MSGCD>
		 <MSGTXT >フレーム分割(frameset)時の自動調整機能を有効にするには、name="SUB_FRAME" が必要です。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="script" >
	 <!-- 特殊処理1。custom/result_info.jsp に、csHilightBGColorをｸﾞﾛｰﾊﾞﾙ変数化 しているため除外する。 -->
	 <!-- 特殊処理2。custom/query_info.jsp  に、紙芝居作成時に使用する "toplink" をJavaSctiptで判定しているため除外する。 -->
	 <xsl:if test="not(ancestor::og:head) and not(ancestor::head) and not(contains( . , 'hybs_csHilightBGColor')) and not(contains( . , 'toplink'))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING27A</MSGCD>
		 <MSGTXT >script タグは、できるだけ og:head or head タグ内に記述した方が良いです。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@type) or not(@type='text/javascript')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR21</MSGCD>
		 <MSGTXT >script タグの、type属性は必須で、type="text/javascript" と記述してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
<!-- スペースの数は含めないことにします。 -->
	 <xsl:if test="string-length(normalize-space(.)) &gt; 1000" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING01C</MSGCD>
		 <MSGTXT >script タグの設定文字数が多すぎます(制限1000文字 ⇒ <xsl:value-of select="string-length(normalize-space(.))" />字)。
						別ファイルで管理してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="link" >
	 <xsl:if test="not(ancestor::og:head) and not(ancestor::head)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING27B</MSGCD>
		 <MSGTXT >スタイルシートのlink タグは、できるだけ og:head or head タグ内に記述した方が良いです。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="style" >
	 <xsl:if test="not(ancestor::og:head) and not(ancestor::head)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING27C</MSGCD>
		 <MSGTXT >style タグは、できるだけ og:head or head タグ内に記述した方が良いです。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@type) or not(@type='text/css')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING28B</MSGCD>
		 <MSGTXT >style タグの、type属性は必須ではありませんが、できれば、type="text/css" と記述してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="span[@type='jsp:directive']" >
	 <xsl:if test="(@pageEncoding='non')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING03</MSGCD>
		 <MSGTXT >インクルードファイル(<xsl:value-of select="@file" />)の先頭には、jsp:directive.page タグで pageEncoding="UTF-8" を記述した方が良いです。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template mode="sql"
		match="og:query | og:update | og:plsqlUpdate | og:tableUpdate | og:entryQuery |
				og:value[@command='SQL'] | og:value[@command='SET'] | og:userInfo[@command='SQL'] | og:tableUpdateParam |
				og:writeTableParam[@key='MergeSql'] |
				og:queryOption |
				og:directWriteTable |
				og:tableFilter[@classId='DBSELECT'] |
				og:chartDataset[not(@useTableData='true')] |
				og:dataCheck |
				og:columnEditor[(@renderer='DBMENU' or @editor='DBMENU')] |
				og:column[(@renderer='DBMENU' or @editor='DBMENU' or @eventColumn) and @param] |
				og:hidden" >
	<!-- normalize-space で、タブ等が統一されています。 -->
	<xsl:variable name="NODE1" select="normalize-space(translate( node() ,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' ))" />
	<xsl:variable name="NODE2" select="normalize-space(translate( @param ,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' ))" />
		<xsl:if test="contains($NODE1,' {@LBL.') or contains($NODE2,' {@LBL.')" >
		   <ROW>
			 <xsl:copy-of select="$row_header" />
			 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
			 <MSGCD  >ERROR24</MSGCD>
			 <MSGTXT >ﾗﾍﾞﾙﾘｿｰｽ {@LBL.XXXX} が、ｸｵｰﾄ無しで、直接 SELECT文で使われています。これは、ﾘｿｰｽに予約語が使用された場合、実行時ｴﾗｰになるため、ｸｵｰﾄを追加してください。</MSGTXT>
			 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
		   </ROW>
	</xsl:if>
  </xsl:template>

</xsl:stylesheet>
