<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC32"
	title	= "予約語ﾁｪｯｸ"
	date    = "2019/11/15"
	author	= "Kazuhiko.Hasegawa"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "{@command}"
	nullCheck = "CHBOX"
/>

<style type="text/css">
	.MARK { background-color:#ccff00 ;}
</style>

<!-- ベースとなる予約語一覧 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="0" scope="request" mainTrans="false"
						stopZero="true" notfoundMsg="{@LBL.GF19} {@LBL.MSG0089_NI} {@LBL.MSG0077}">
	select YOYAKU as CLM
			, case DBNAME when 'ORACLE' then '&lt;b class="MARK"&gt;ORACLE&lt;/b&gt;' else DBNAME end DBNAME
			, case CDYOYAKU when '0' then '{@LBL.CDYOYAKU.0}'
						    when '1' then '{@LBL.CDYOYAKU.1}'
						    when '2' then '{@LBL.CDYOYAKU.2}'
						    else CDYOYAKU end as CDYOYAKU
--			, LISTAGG(DBNAME   , ',') WITHIN GROUP (order by DBNAME) as DBNAME
--			, LISTAGG(CDYOYAKU , ',') WITHIN GROUP (order by DBNAME) as CDYOYAKU
	from   GF19
	<og:where>
		<og:and value = "YOYAKU		like  '{@CLM1}'"		/>
		<og:and value = "YOYAKU		like  '{@CLM2}'"		/>
		<og:and value = "CDYOYAKU	=     '{@CDYOYAKU}'"	/>
		<og:and value = "DBNAME		=     '{@DBNAME}'"		/>
	</og:where>
--	group by YOYAKU
	order by DBNAME,CDYOYAKU,YOYAKU
</og:query>

<og:tableMerge
	action        = "GROUP"
	masterScope   = "request"
	masterKeys    = "CLM"
	groupAddClms  = "DBNAME,CDYOYAKU"
	unionLbls     = "CDYOYAKU"
	display       = "true"
/>
<br />

<!-- ﾘｿｰｽ -->
<og:equals val1="{@CHBOX}" val2="RSC" >
	<og:query command="{@command}" debug="{@debug}" maxRowCount="0" dbid="{@DBID}"
						stopZero="true" notfoundMsg="{@LBL.GEA08}({@LBL.resource}) {@LBL.MSG0089_NI} {@LBL.MSG0077}">
		select CLM, NAME_JA ,SNAME,LNAME,RELEASE_NOTES,KBSAKU
		from   GEA08
		where  LANG = 'ja'
		and    FGJ  = '1'
		<og:where startKey="and" >
			<og:and value = "SYSTEM_ID		=     '{@SYSTEM_ID}'"		/>
			<og:and value = "CLM			like  '{@CLM1}'"			/>
			<og:and value = "RELEASE_NOTES	like  '{@RELEASE_NOTES}'"	/>
		</og:where>
		order by CLM, NAME_JA ,KBSAKU
	</og:query>

	<og:tableMerge
		action        = "INTERSECT"
		masterScope   = "session"
		masterKeys    = "CLM"
		slaveScope    = "request"
		display       = "true"
	/>

	<og:equals val1="{@DB.COUNT}" val2="0" useStop="true" >
<og:text>　　{@LBL.MSG0089_DE} {@LBL.MSG0077}</og:text>
	</og:equals>

	<br />
	<og:tableMerge
		action        = "UNION_CLM"
		masterScope   = "session"
		masterKeys    = "CLM"
		slaveScope    = "request"
		unionClms     = "DBNAME,CDYOYAKU"
		display       = "false"
	/>
<!--
	<og:viewMarker command="{@command}">
		<og:columnMarker columns="CLM,DBNAME,CDYOYAKU" markList="[DBNAME]" onMark="ORACLE" >
			<span style="background-color:#ccff00">[$1]</span>
		</og:columnMarker>
	</og:viewMarker>
-->
	<og:view
		viewFormType = "HTMLTable"
		command      = "{@command}"
		checked      = "{@checked}"
		startNo      = "{@startNo}"
		pageSize     = "{@pageSize}"
		writable	 = "false"
	/>
</og:equals>

<!-- ﾃｰﾌﾞﾙ -->
<og:equals val1="{@CHBOX}" val2="TBL" >
	<og:query command="{@command}" debug="{@debug}" maxRowCount="0" dbid="{@DBID}"
						stopZero="true" notfoundMsg="{@LBL.GF05}(USER_TAB_COLUMNS) {@LBL.MSG0089_NI} {@LBL.MSG0077}">
		select    A.TABLE_NAME
	--			, D.COMMENTS
				, A.COLUMN_NAME AS CLM
				, COALESCE(B.COMMENTS,A.COLUMN_NAME) AS NAME_JA
	--			, A.COLUMN_ID AS SEQNO
	--			, A.DATA_TYPE AS CLS_NAME
	--			, ( CASE	WHEN A.DATA_TYPE = 'BLOB' or A.DATA_TYPE = 'CLOB'
	--					THEN NULL
	--				WHEN A.DATA_TYPE = 'NUMBER' AND A.DATA_PRECISION IS NULL 
	--					THEN NULL
	--				WHEN A.DATA_TYPE = 'VARCHAR2'
	--					THEN to_char(A.DATA_LENGTH)
	--				WHEN A.DATA_PRECISION IS NULL 
	--					THEN to_char(A.DATA_LENGTH)
	--					ELSE (	CASE WHEN A.DATA_SCALE = 0 or A.DATA_SCALE is null
	--								THEN to_char(A.DATA_PRECISION)
	--								ELSE A.DATA_PRECISION || ',' || A.DATA_SCALE
	--						  	END )
	--				 END ) AS USE_LENGTH 
	--			, A.DATA_DEFAULT 
	--		    , (CASE A.NULLABLE WHEN 'N' THEN '1' ELSE '' END) AS NOT_NULL
		from USER_TAB_COLUMNS A left outer join USER_COL_COMMENTS B
				on  A.TABLE_NAME  = B.TABLE_NAME
				and A.COLUMN_NAME = B.COLUMN_NAME
	--				left outer join USER_TAB_COMMENTS D
	--				on  A.TABLE_NAME  = D.TABLE_NAME
		where exists ( select 'X' from USER_TABLES C
						where C.TABLE_NAME = A.TABLE_NAME
					)
		<og:where startKey="and">
			<og:and value = "A.TABLE_NAME like '{@TABLEID}'" />
			<og:and value = "A.COLUMN_NAME like '{@CLM2}'" />
			<og:and value = "INSTR(A.TABLE_NAME,'$') &lt; 1" />
		</og:where>
		order by A.TABLE_NAME,A.COLUMN_ID
	</og:query>

	<og:tableMerge
		action        = "INTERSECT"
		masterScope   = "session"
		masterKeys    = "CLM"
		slaveScope    = "request"
		display       = "true"
	/>

	<og:equals val1="{@DB.COUNT}" val2="0" useStop="true" >
<og:text>　　{@LBL.MSG0089_DE} {@LBL.MSG0077}</og:text>
	</og:equals>

	<br />
	<og:tableMerge
		action        = "UNION_CLM"
		masterScope   = "session"
		masterKeys    = "CLM"
		slaveScope    = "request"
		unionClms     = "DBNAME,CDYOYAKU"
		display       = "false"
	/>

<!--
	<og:viewMarker command="{@command}">
		<og:columnMarker columns="CLM,DBNAME,CDYOYAKU" markList="[DBNAME]" onMark="ORACLE" >
			<span style="background-color:#ccff00">[$1]</span>
		</og:columnMarker>
	</og:viewMarker>
-->
	<og:view
		viewFormType = "HTMLTable"
		command      = "{@command}"
		checked      = "{@checked}"
		startNo      = "{@startNo}"
		pageSize     = "{@pageSize}"
		writable	 = "false"
	/>
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
