<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query" />
<jsp:directive.include file="/jsp/custom/query_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6230"
	title	= "LDAP+MAIL"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- LDAPの再検索時に、GETでは上手くいかない。 -->
<form method="POST" action="forward.jsp" target="RESULT" onSubmit="timeSet();">

<!-- 変更はここから -->
<table summary="layout" >
<tr>
	<!-- 画面へのリンクを作成するときに指定する画面ID -->
	<og:select name="GUIKEY" >
		<og:queryOption value="{@GUIKEY}">
				select GUIKEY,GUIKEY,NAME_JA from GEA11
				where SYSTEM_ID='{@SYS.SYSTEM_ID}' and FGJ='1'
				order by SEQNO
		</og:queryOption>
	</og:select>
	<og:input name="cnLangJP" value="{@cnLangJP}" />
	<td><og:img src="{@SYS.JSP}/image/out_18x16.gif" onClick="renew('query.jsp','QUERY');" style="cursor:hand;" alt="ReNew" /></td>
</tr>
<tr>
	<!-- 部門CDを検索するメニュー onChangeイベントで再呼び出し -->
	<og:select name="soOUID" onChange="renew('query.jsp?soOUID2=','QUERY'); ">
		<og:option value="" lbl="" />
		<og:queryOption value="{@soOUID}">
			<og:ldapQuery
				searchScope = "ONELEVEL"
				filter		= "(objectClass=organizationalUnit)"
				attributes	= "soOUID,ou"
				orderBy		= "soOUID"
			/>
		</og:queryOption>
	</og:select>
	<og:input name="cnLangEng" value="{@cnLangEng}"  />
	<td><og:img src="{@SYS.JSP}/image/out_18x16.gif" onClick="renew('query.jsp','QUERY');" style="cursor:hand;" alt="ReNew"/></td>
</tr>
<tr>
	<og:equals val1="{@soOUID}" val2="{@soOUID}">
	<!-- サブ部門CDを検索するメニュー onChangeイベントで再呼び出し -->
		<og:select name="soOUID2" onChange="renew('query.jsp','QUERY'); ">
			<og:option value="" lbl="" />
			<og:queryOption value="{@soOUID2}">
				<og:ldapQuery
					searchbase	= "soOUID={@soOUID},soouid=employeeuser,o=opengion,c=JP"
					searchScope = "ONELEVEL"
					filter		= "(objectClass=organizationalUnit)"
					attributes	= "soOUID,ou"
					orderBy		= "soOUID"
				/>
			</og:queryOption>
		</og:select>
	</og:equals>
	<og:space />
</tr>
<tr>
	<!-- 部門CDがセットされた時に使用する、searchbase に付加する情報 -->
	<og:equals val1="{@soOUID}" val2="{@soOUID}">
		<og:value key="BASE" value="soOUID={@soOUID}," />

		<!-- サブ部門CDがセットされた時に使用する、searchbase に付加する情報 -->
		<og:equals val1="{@soOUID2}" val2="{@soOUID2}">
			<og:value key="BASE" value="soOUID={@soOUID2},soOUID={@soOUID}," />
		</og:equals>
	</og:equals>

	<!-- C社員番号と担当者名のメニュー。部門CD、サブ部門CD による絞込みと、複数選択をサポート -->
	<!-- BASE,cnLangJP,cnLangEng のうち、いづれかの条件が入力されていること。 -->
	<!-- C社員番号は uid , 社員番号は、employeeNumber -->
	<og:equals val1="{@BASE}{@cnLangJP}{@cnLangEng}" val2="{@BASE}{@cnLangJP}{@cnLangEng}">
		<og:select name="uid" multiple="multiple" size="5" colspan="3" style="font-family:monospace;" >
			<og:queryOption value="{@uid}">
				<og:ldapQuery
					searchbase	= "{@BASE}soouid=employeeuser,o=opengion,c=JP"
					filter		= "(&amp;(objectClass=employeeuser)(mail=*)(cnLangJP={@cnLangJP}*)(cnLangEng={@cnLangEng}*))"
					attributes	= "uid,uid,cn,departmentName"
					columns		= ",,CN_S,"
					orderBy		= "uid"
				/>
			</og:queryOption>
		</og:select>
	</og:equals>
	<td><og:img src="{@SYS.JSP}/image/out_18x16.gif" onClick="renew('query.jsp','QUERY');" style="cursor:hand;" alt="ReNew" /></td>
</tr>
<tr>
	<og:value key="uidx"    value="{@uid}" action="APPEND" />
	<og:input name="uidadd" value="{@uidadd},{@uidx}" size="80" colspan="4" />
</tr>

</table>

<og:queryButton />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
