<jsp:directive.page pageEncoding="UTF-8" />

<!-- 本来は、queryタグ で、stopZero して、以下の処理を止めます。 -->
<!-- ここでは、テストのため、stopZero は、chartCreate に入れるので、queryタグから、notfoundMsg を出さないようにしておきます。 -->
<og:query command="{@command}" debug="{@debug}" scope="request" notfoundMsg="">
	SELECT 	 ENAME || '\n' || EMPNO || '\n' || JOB			-- 営業担当者
			,SAL											-- 売上( 1月)
			,ROUND(SAL * 2 * DBMS_RANDOM.VALUE) as SALES	-- 乱数倍
			,ROUND(SAL * 2 * DBMS_RANDOM.VALUE) as AMOUNT	-- 乱数倍
	FROM EMP
	<og:where>
		<og:and value=" DEPTNO = {@SOOUID}" />
	</og:where>
</og:query>

<og:chartCreate
	title			= "{@chartType}"
	width			= "1200"
	height			= "500"
	plotOrientation	= "{@plotOrientation}"
	rotationLabel	= "0"
	useCache		= "{@useCache}"
	cacheTime		= "{@cacheTime}"
	cacheScope		= "{@cacheScope}"
	masterKey		= "{@chartType}_{@plotOrientation}_{@SOOUID}"
	useToolTip		= "true"
	imageMapUrl		= "../GF7202/index.jsp?SOOUID={@SOOUID}&amp;command=NEW,ENAME"
	imageMapTarget	= "CONTENTS"
	stopZero		= "{@stopZero}"
>
	<og:chartDataset
		chartType		= "{@chartType}"
		itemLabelVisible= "true"
		markOverColors	= "BLUE,RED"
		markValues		= "4000"
		markColors		= "BLACK"
		seriesLabels	= "SAL,SALES,AMOUNT"
		useTableData	= "true"
		scope			= "request"
	/>
</og:chartCreate>

<og:view scope="request" />
