/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.XLogger;

public class PathMatcherSet
implements PathMatcher {
    private static final XLogger LOGGER = XLogger.getLogger(PathMatcherSet.class.getName());
    private final Set<PathMatcher> pathMchSet = new CopyOnWriteArraySet<PathMatcher>();

    public boolean addAll(PathMatcherSet pathMatcherSet) {
        return pathMatcherSet != null && this.pathMchSet.addAll(pathMatcherSet.pathMchSet);
    }

    public boolean isEmpty() {
        return this.pathMchSet.isEmpty();
    }

    public void clear() {
        this.pathMchSet.clear();
    }

    public PathMatcherSet addPathMatcher(PathMatcher pathMatcher) {
        if (pathMatcher != null) {
            this.pathMchSet.add(pathMatcher);
        }
        return this;
    }

    public PathMatcherSet addStartsWith(String ... stringArray) {
        if (stringArray != null) {
            LOGGER.debug(() -> "addStartsWith : String[]=" + Arrays.toString(stringArray));
            this.pathMchSet.add(path -> {
                String string = path.getFileName().toString().toUpperCase(Locale.JAPAN);
                for (String string2 : stringArray) {
                    if (string2 != null && !string2.isEmpty() && !string.startsWith(string2.toUpperCase(Locale.JAPAN))) continue;
                    return true;
                }
                return false;
            });
        }
        return this;
    }

    public PathMatcherSet addEndsWith(String ... stringArray) {
        if (stringArray != null) {
            LOGGER.debug(() -> "addEndsWith : String[]=" + Arrays.toString(stringArray));
            this.pathMchSet.add(path -> {
                String string = path.getFileName().toString().toUpperCase(Locale.JAPAN);
                for (String string2 : stringArray) {
                    if (string2 != null && !string2.isEmpty() && !string.endsWith(string2.toUpperCase(Locale.JAPAN))) continue;
                    return true;
                }
                return false;
            });
        }
        return this;
    }

    public PathMatcherSet addFileName(String string) {
        if (string != null && !string.isEmpty()) {
            LOGGER.debug(() -> "addFileName : filename=" + string);
            int n = string.indexOf(42);
            if (n != string.lastIndexOf(42)) {
                MsgUtil.errPrintln("MSG2005", string);
                return this;
            }
            if (n < 0) {
                this.addStartsWith(string);
            } else if (n == 0) {
                this.addEndsWith(string.substring(1));
            } else if (n == string.length() - 1) {
                this.addStartsWith(string.substring(0, string.length() - 1));
            } else {
                String string2 = string.substring(0, n).toUpperCase(Locale.JAPAN);
                String string3 = string.substring(n + 1).toUpperCase(Locale.JAPAN);
                this.pathMchSet.add(path -> {
                    String string3 = path.getFileName().toString().toUpperCase(Locale.JAPAN);
                    return string3.startsWith(string2) && string3.endsWith(string3);
                });
            }
        }
        return this;
    }

    @Override
    public boolean matches(Path path) {
        return this.allMatch(path);
    }

    public boolean allMatch(Path path) {
        boolean bl;
        boolean bl2 = bl = this.pathMchSet.isEmpty() || this.pathMchSet.stream().allMatch((? super T pathMatcher) -> pathMatcher.matches(path));
        if (bl) {
            LOGGER.debug(() -> "allMatch : Path=" + path);
        }
        return bl;
    }

    public boolean anyMatch(Path path) {
        boolean bl;
        boolean bl2 = bl = this.pathMchSet.isEmpty() || this.pathMchSet.stream().anyMatch((? super T pathMatcher) -> pathMatcher.matches(path));
        if (bl) {
            LOGGER.debug(() -> "anyMatch : Path=" + path);
        }
        return bl;
    }

    public boolean noneMatch(Path path) {
        boolean bl;
        boolean bl2 = bl = this.pathMchSet.isEmpty() || this.pathMchSet.stream().noneMatch((? super T pathMatcher) -> pathMatcher.matches(path));
        if (bl) {
            LOGGER.debug(() -> "noneMatch : Path=" + path);
        }
        return bl;
    }
}

