/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.common;

import org.opengion.fukurou.util.Cleanable;

/**
 * ユーザー情報(UserInfo)のサマリー情報のみハンドリングする為のインターフェースです。
 * パッケージ間依存を減らす為に、新規作成しています。
 * よって、resource/UserInfo の部分メソッドのみをサポートしていると考えてください。
 *
 * @og.rev 4.0.0.0 (2005/08/31) 新規作成
 * @og.group ログイン制御
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public interface UserSummary extends Comparable<UserSummary> , Cleanable {

	/**
	 * ユーザーログイン時刻を取得します。
	 *
	 * @return	ユーザーログイン時刻
	 */
	long getLoginTime() ;

	/**
	 * ユーザーのログインIPアドレスを取得します。
	 *
	 * @return   IPアドレス
	 */
	String getIPAddress() ;

	/**
	 * ユーザーを返します。
	 *
	 * @return  ユーザー
	 */
	String getUserID() ;

	/**
	 * ユーザー情報ロケール(言語)を返します。
	 *
	 * @return	ロケール(言語)
	 */
	String getLang() ;

	/**
	 * ユーザー情報 名称(日本語)を返します。
	 *
	 * @return	名称(日本語)
	 */
	String getJname() ;

	/**
	 * ユーザー情報 ロール(役割)を取得します。
	 *
	 * @return	ロール(役割)
	 */
	String getRoles() ;

	/**
	 * オブジェクトの識別子として，ユーザー情報を返します。
	 *
	 * @return  ユーザー情報
	 */
	String getInfo() ;

	/**
	 * ユーザー情報の，属性文字列を取得します。
	 *
	 * @param	key  	キー
	 *
	 * @return  属性文字列
	 * @see org.opengion.hayabusa.resource.UserInfo#getAttribute( String )
	 */
	String getAttribute( final String key ) ;

}
