/**
 * <pre>
 * このドキュメントは、『はやぶさPlugIn』の カラムリソース関連 PlugIn 仕様です。
 * 
 * カラムリソースは、内部に、Renderer、Editor、DBType というオブジェクトを持っています。
 * 検索結果の表示には、Renderer を、結果を編集する場合は、Editor を、そのデータの
 * 種類(桁数、半角/全角 など)を規定し、チェック、正規化 を行うのが DBType です。
 * 
 * 
 * これらのプラグインは、エンジン内部で、デフォルトオブジェクトが生成され、
 * それをキャッシュしています。そのオブジェクトの newInstance インターフェース
 * を経由して、実際に必要なオブジェクトをロードする２重構造を持っています。
 * 
 * 
 * オブジェクトは、すべてのカラムオブジェクトの内部にキープされ、同時アクセスが
 * 行われます。
 * エンジン標準に用意しているクラスでは、イミュータブル（immutable：不変）オブジェクト
 * として、作成した場合には、内部にキャッシュして、再利用し、そうでない場合は、
 * 同期化せずに、要求都度オブジェクトを作成しています。
 * 
 * 
 * 基本的に、イミュータブル でない場合でも、カラムに対しては、ユニークになるように
 * することで、カラムオブジェクトの数だけで、全ユーザーのアクセスに対応できる作り
 * にしておく必要があります。
 * 
 * </pre>
 */
package org.opengion.plugin.column;
