<jsp:directive.page pageEncoding="UTF-8" />
<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" notfoundMsg = "" maxRowCount="0">
		select  a.VERNO,a.SEQ as CSEQ,a.TAGNAME,a.PRE_FIX || ':' || a.TAGNAME  TAGNAME2 ,
				a.BODYCONTENT,b.HTMLEXT,b.CONTENTS,b.FORM_SAMPLE ,
				c.SEQ as VSEQ,c.VALUENAME,d.CONTENTS CONTENTS2
		from    ( GF21 a left outer join GF23 b
				on		a.VERNO		= b.VERNO
				and		a.TAGCLASS	= b.TAGCLASS )
			left outer join
				( GF22 c left outer join GF24 d
				on		c.VERNO		= d.VERNO
				and		c.TAGCLASS	= d.TAGCLASS
				and		c.VALUENAME = d.VALUENAME
				and		c.FGJ		= d.FGJ )
			on		a.VERNO		= c.VERNO
			and		a.TAGCLASS	= c.TAGCLASS
	<og:where>
		<og:and value = "a.VERNO	= '{@VERNO}'"	/>
		<og:and value = "a.PRE_FIX	= '{@PRE_FIX}'"	/>
	</og:where>
	order by a.VERNO,a.TAGNAME,CSEQ,VSEQ
</og:query>

<!-- 検索条件の値フィールドは、動的カラムを使用してフィールドを作成します。 -->
<og:columnEditor column="VSEQ" dbType="X"  />

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->

<og:viewMarker command="{@command}">
	<og:columnMarker column="TAGNAME" >
		<a name="TAG_[TAGNAME]" />
		<a href="#VAL_[TAGNAME]" alt="[TAGNAME]">[TAGNAME]</a>
	</og:columnMarker>
	<og:columnMarker column="TAGNAME2" >
		<a name="VAL_[TAGNAME]" />
		<a href="#TAG_[TAGNAME]" alt="[TAGNAME]">[TAGNAME2]</a>
	</og:columnMarker>
	<og:columnMarker column="VALUENAME"  onMark="[VALUENAME]"
			markList="chartClass|dbType|editor|queryType|readerClass|renderer|viewFormType|writerClass|calDB|" >
		<a name="VAL_[VALUENAME]" />
		<a href="#CLS_[VALUENAME]" alt="[VALUENAME]">[VALUENAME]</a>
	</og:columnMarker>
</og:viewMarker>

<div style="font-size: x-large">
	<og:text>{@LBL.TAGNAME}/{@LBL.VALUENAME} ({@LBL.VERNO} {@VERNO})</og:text>
</div>

<og:view
	viewFormType = "HTMLCustomTable"
	command		= "{@command}"
	writable	= "false"
	pageSize	= "100000"
	headerSkipCount = "0"
	backLinkCount	= "10"
	useTableSorter	= "false"
	useScrollBar	= "false"
	numberType		= "delete"
>
	<og:thead rowspan="2">
		<tr>
			<td valign="top">
				[VERNO]<br />[TAGNAME2]<br />[HTMLEXT]<br />[BODYCONTENT]
			</td>
			<td><pre>[CONTENTS]</pre></td>
		</tr>
		<tr>
			<td colspan="2"><pre>[FORM_SAMPLE]</pre></td>
		</tr>
	</og:thead>

	<og:tbody usableKey="VSEQ" usableList="1" rowspan="2">
		<tr>
			<td valign="top" style="border-top:solid 2px #ff9900; page-break-before: always;">
				[VERNO]<br />[TAGNAME2]<br />[HTMLEXT]<br />[BODYCONTENT]
			</td>
			<td style="border-top:solid 2px #ff9900;"><pre>[CONTENTS]</pre></td>
		</tr>
		<tr>
			<td colspan="2"><pre>[FORM_SAMPLE]</pre></td>
		</tr>
	</og:tbody>

	<og:tbody usableList="1" rowspan="2">
		<tr><td valign="top">[VSEQ].[VALUENAME]</td>
			<td valign="top"><pre>[CONTENTS2]</pre></td>
		</tr>
	</og:tbody>

</og:view>

<div style="page-break-before: always" ></div>

<og:query command="{@command}" debug="{@debug}" notfoundMsg = "" maxRowCount="0">
		select  VERNO,ATTCLASS,ATTKEY,VALUENAME,
				DESCRIPTION,CONTENTS,FORM_SAMPLE
		from    GF25
	<og:where>
		<og:and value = "VERNO	=	'{@VERNO}'"	/>
		<og:and value = "FGJ	in ( '0','1' )"	/>
	</og:where>
	order by VERNO,SEQ,ATTKEY
</og:query>

<og:viewMarker command="{@command}">
	<og:columnMarker column="VALUENAME" >
		<a name="CLS_[VALUENAME]" />
		<a href="#VAL_[VALUENAME]" alt="[VALUENAME]">[VALUENAME]</a>
	</og:columnMarker>
</og:viewMarker>

<br /><hr /><br />
<div style="font-size: x-large">
	<og:text>{@LBL.ATTKEY} ({@LBL.VERNO} {@VERNO})</og:text>
</div>

<og:view
	viewFormType = "HTMLFormatTable"
	command			= "{@command}"
	writable		= "false"
	pageSize		= "100000"
	headerSkipCount = "0"
	backLinkCount   = "10"
	useTableSorter	= "false"
	useScrollBar	= "false"
	numberType		= "delete"
	rowspan			= "3"
>
	<tr><td valign="top">[VERNO]<br />[VALUENAME]<br />[ATTKEY]</td>
		<td valign="top"><pre>[CONTENTS]</pre></td>
	</tr>
	<tr><td colspan="2"><pre>[ATTCLASS]</pre></td></tr>
	<tr><td colspan="2"><pre>[FORM_SAMPLE]</pre></td></tr>
</og:view>
