/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.OracleTypeMetaData;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;

public class ResultSetValue
implements AutoCloseable {
    private static final int BUFFER_MIDDLE = 10000;
    private final ResultSet resultSet;
    private final List<ColumnInfo> clmInfos;
    private boolean skipNext;
    private boolean firstNext;

    public ResultSetValue(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.clmInfos = new ArrayList<ColumnInfo>();
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            int n3 = resultSetMetaData.getColumnType(n2);
            String string = resultSetMetaData.getColumnLabel(n2).toUpperCase(Locale.JAPAN);
            if (n3 == 2002) {
                Object object;
                if (!this.skipNext) {
                    this.skipNext = true;
                    this.firstNext = this.resultSet.next();
                }
                if (!this.firstNext || (object = this.resultSet.getObject(n2)) == null) continue;
                OracleTypeMetaData oracleTypeMetaData = ((OracleStruct)object).getOracleMetaData();
                ResultSetMetaData resultSetMetaData2 = ((OracleTypeMetaData.Struct)oracleTypeMetaData).getMetaData();
                int n4 = resultSetMetaData2.getColumnCount();
                for (int j = 0; j < n4; ++j) {
                    int n5 = j + 1;
                    String string2 = string + "." + resultSetMetaData2.getColumnLabel(n5).toUpperCase(Locale.JAPAN);
                    int n6 = resultSetMetaData2.getColumnType(n5);
                    int n7 = resultSetMetaData2.getColumnDisplaySize(n5);
                    boolean bl = resultSetMetaData2.isWritable(n5);
                    this.clmInfos.add(new ColumnInfo(string2, n6, n7, bl, n2, j));
                }
                continue;
            }
            int n8 = resultSetMetaData.getColumnDisplaySize(n2);
            boolean bl = resultSetMetaData.isWritable(n2);
            this.clmInfos.add(new ColumnInfo(string, n3, n8, bl, n2, -1));
        }
    }

    public int getColumnCount() {
        return this.clmInfos.size();
    }

    public String[] getNames() {
        return (String[])this.clmInfos.stream().map(columnInfo -> columnInfo.getName()).toArray(String[]::new);
    }

    public int[] getColumnNos(String[] stringArray) {
        return this.getColumnNos(stringArray, false);
    }

    public int[] getColumnNos(String[] stringArray, boolean bl) {
        int n;
        if (stringArray != null && stringArray.length == 1 && "*".equals(stringArray[0])) {
            int[] nArray = new int[this.clmInfos.size()];
            for (int i = 0; i < this.clmInfos.size(); ++i) {
                nArray[i] = 1;
            }
            return nArray;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (n = 0; n < this.clmInfos.size(); ++n) {
            hashMap.put(this.clmInfos.get(n).getName(), n);
        }
        n = stringArray == null ? 0 : stringArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)hashMap.get(stringArray[i]);
            if (n2 == null) {
                if (bl) {
                    String string = "\u6307\u5b9a\u306e\u30ab\u30e9\u30e0\u540d\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 \u30ab\u30e9\u30e0\u540d[" + i + "]=[" + stringArray[i] + "]" + HybsConst.CR + " \u5f15\u6570\u30ab\u30e9\u30e0\u914d\u5217=[" + String.join((CharSequence)",", stringArray) + "]" + HybsConst.CR + " \u5185\u90e8\u30ab\u30e9\u30e0\u5217=[" + String.join((CharSequence)",", hashMap.keySet()) + "]";
                    throw new OgRuntimeException(string);
                }
                nArray[i] = -1;
                continue;
            }
            nArray[i] = n2;
        }
        return nArray;
    }

    public String getColumnName(int n) {
        return this.clmInfos.get((int)n).name;
    }

    public int getColumnDisplaySize(int n) {
        return this.clmInfos.get((int)n).size;
    }

    public boolean isWritable(int n) {
        return this.clmInfos.get((int)n).isWrit;
    }

    public boolean next() throws SQLException {
        if (this.skipNext) {
            this.skipNext = false;
            return this.firstNext;
        }
        return this.resultSet.next();
    }

    public String getValue(int n) throws SQLException {
        String string;
        ColumnInfo columnInfo = this.clmInfos.get(n);
        int n2 = columnInfo.clmNo;
        Object object = this.resultSet.getObject(n2);
        if (object == null) {
            string = "";
        } else if (columnInfo.isStruct) {
            int n3 = columnInfo.objNo;
            Object[] objectArray = ((Struct)object).getAttributes();
            string = n3 < objectArray.length ? String.valueOf(objectArray[n3]) : "";
        } else if (columnInfo.isObject) {
            switch (columnInfo.type) {
                case 2005: {
                    string = this.getClobData((Clob)object);
                    break;
                }
                case -8: {
                    string = this.resultSet.getString(n2);
                    break;
                }
                case 93: {
                    string = DateSet.getDate(((Timestamp)object).getTime(), "yyyyMMddHHmmss");
                    break;
                }
                default: {
                    string = String.valueOf(object);
                    break;
                }
            }
        } else {
            string = String.valueOf(object);
        }
        return string;
    }

    public String[] getValues() throws SQLException {
        String[] stringArray = new String[this.clmInfos.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getValue(i);
        }
        return stringArray;
    }

    public Number getNumber(int n) throws SQLException {
        ColumnInfo columnInfo = this.clmInfos.get(n);
        int n2 = columnInfo.clmNo;
        Number number = null;
        Object object = this.resultSet.getObject(n2);
        if (object != null) {
            Object object2;
            if (columnInfo.isStruct) {
                int n3 = columnInfo.objNo;
                object2 = ((Struct)object).getAttributes();
                Object object3 = object = n3 < ((Object[])object2).length ? object2[n3] : null;
                if (object == null) {
                    return number;
                }
            }
            switch (columnInfo.type) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    number = (Number)object;
                    break;
                }
                case 91: 
                case 92: {
                    number = ((Date)object).getTime();
                    break;
                }
                case 93: {
                    number = ((Timestamp)object).getTime();
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    object2 = (String)object;
                    try {
                        number = Double.valueOf((String)object2);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = "\u6570\u5b57\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002in=" + (String)object2 + HybsConst.CR + numberFormatException.getMessage();
                        throw new OgRuntimeException(string, numberFormatException);
                    }
                }
            }
        }
        return number;
    }

    public String getClassName(int n) {
        String string;
        switch (this.clmInfos.get((int)n).type) {
            case -7: 
            case 1: 
            case 12: {
                string = "VARCHAR2";
                break;
            }
            case -1: {
                string = "LONG";
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "NUMBER";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                string = "DATE";
                break;
            }
            case 2005: {
                string = "CLOB";
                break;
            }
            case 2002: {
                string = "STRUCT";
                break;
            }
            default: {
                string = "NONE";
            }
        }
        return string;
    }

    @Override
    public void close() {
        Closer.resultClose(this.resultSet);
    }

    private String getClobData(Clob clob) throws SQLException {
        if (clob == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(10000);
        Reader reader = null;
        try {
            int n;
            reader = clob.getCharacterStream();
            char[] cArray = new char[10000];
            while ((n = reader.read(cArray)) >= 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            String string = "CLOB\u30c7\u30fc\u30bf\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + iOException.getMessage();
            throw new OgRuntimeException(string, iOException);
        }
        finally {
            Closer.ioClose(reader);
        }
        return stringBuilder.toString();
    }

    private static final class ColumnInfo {
        private final String name;
        private final int type;
        private final int size;
        private final boolean isWrit;
        private final int clmNo;
        private final int objNo;
        private final boolean isStruct;
        private final boolean isObject;

        ColumnInfo(String string, int n, int n2, boolean bl, int n3, int n4) {
            this.name = string;
            this.type = n;
            this.size = n2;
            this.isWrit = bl;
            this.clmNo = n3;
            this.objNo = n4;
            this.isStruct = n4 >= 0;
            this.isObject = n == 2005 || n == -8 || n == 93;
        }

        public String getName() {
            return this.name;
        }
    }
}

