/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.system.HybsConst;

public class JsChartData {
    public static final String DATASET = "dataset";
    public static final String AXIS = "axis";
    public static final String TICKS = "ticks";
    public static final String TIME = "time";
    public static final String SCALE_LABEL = "scaleLabel";
    public static final String GRID_LINES = "gridLines";
    final String[] AXIS_OPTS = new String[]{"ticks", "time", "scaleLabel", "gridLines"};
    private final ConcurrentMap<String, StringBuilder> charts = new ConcurrentHashMap<String, StringBuilder>();
    private final ConcurrentMap<String, StringBuilder> options = new ConcurrentHashMap<String, StringBuilder>();
    private String chartColumn;
    private String yid;
    private boolean useAxis;
    private boolean useTime;

    public void setChartColumn(String string) {
        this.chartColumn = string;
    }

    public String getChartColumn() {
        return this.chartColumn;
    }

    public void setId(String string) {
        this.yid = string;
        this.addAxis("id", this.yid + "Ax", false);
    }

    public void setUseAxis(boolean bl) {
        this.useAxis = bl;
    }

    public boolean isUseAxis() {
        return this.useAxis;
    }

    public void setUseTime(boolean bl) {
        this.useTime = bl;
    }

    public void addDataset(String string, String string2, boolean bl) {
        this.addBuffer(DATASET, string, string2, bl);
    }

    public void addAxis(String string, String string2, boolean bl) {
        this.addBuffer(AXIS, string, string2, bl);
    }

    public void addTicks(String string, String string2, boolean bl) {
        this.addBuffer(TICKS, string, string2, bl);
    }

    public void addTime(String string, String string2, boolean bl) {
        this.addBuffer(TIME, string, string2, bl);
    }

    private void addBuffer(String string2, String string3, String string4, boolean bl) {
        if (string4 != null && !string4.trim().isEmpty()) {
            String string5 = string4.trim();
            StringBuilder stringBuilder = this.charts.computeIfAbsent(string2, string -> new StringBuilder(200));
            if (bl || '[' == string5.charAt(0) || '{' == string5.charAt(0)) {
                stringBuilder.append(string3).append(':').append(string5).append(',');
            } else {
                stringBuilder.append(string3).append(":'").append(string5).append("',");
            }
        }
    }

    public void addOptions(String string2, String string3) {
        if (string3 != null && string3.length() > 0) {
            this.options.computeIfAbsent(string2, string -> new StringBuilder(200)).append(string3);
        }
    }

    public boolean contains(String string, String string2) {
        boolean bl = false;
        StringBuilder stringBuilder = (StringBuilder)this.charts.get(string);
        if (stringBuilder != null && stringBuilder.indexOf(string2) >= 0) {
            bl = true;
        } else {
            StringBuilder stringBuilder2 = (StringBuilder)this.options.get(string);
            if (stringBuilder2 != null && stringBuilder2.indexOf(string2) >= 0) {
                bl = true;
            }
        }
        return bl;
    }

    public String getDataset(char c) {
        StringBuilder stringBuilder = this.charts.computeIfAbsent(DATASET, string -> new StringBuilder(200));
        stringBuilder.append("data:").append(this.chartColumn).append(',');
        if (this.useAxis && stringBuilder.indexOf("AxisID:") < 0) {
            stringBuilder.append(c).append("AxisID:'").append(this.getAxisKey()).append("',");
        }
        return new StringBuilder(200).append("var ").append(this.getDatasetKey()).append("={").append((CharSequence)stringBuilder).append(this.nval(this.options, DATASET)).append("};").toString();
    }

    public String getDatasetKey() {
        return this.yid + "Ds";
    }

    public String getAxis() {
        StringBuilder stringBuilder = this.charts.computeIfAbsent(AXIS, string -> new StringBuilder(200));
        for (String string2 : this.AXIS_OPTS) {
            String string3;
            if (!this.useTime && TIME.equals(string2) || stringBuilder.indexOf(string3 = string2 + ":{") >= 0 || !this.charts.containsKey(string2) && !this.options.containsKey(string2)) continue;
            stringBuilder.append(string3).append(this.nval(this.charts, string2)).append(this.nval(this.options, string2)).append("},");
        }
        return new StringBuilder(200).append("var ").append(this.getAxisKey()).append("={").append((CharSequence)stringBuilder).append(this.nval(this.options, AXIS)).append("};").toString();
    }

    public String getAxisKey() {
        return this.yid + "Ax";
    }

    private String nval(ConcurrentMap<String, StringBuilder> concurrentMap, String string) {
        StringBuilder stringBuilder = (StringBuilder)concurrentMap.get(string);
        return stringBuilder == null || stringBuilder.length() == 0 ? "" : stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append("chartColumn=").append(this.chartColumn).append(HybsConst.CR).append("datasetKey =").append(this.getDatasetKey()).append(HybsConst.CR).append("axisKey    =").append(this.getAxisKey()).append(HybsConst.CR);
        this.charts.forEach((string, stringBuilder2) -> stringBuilder.append((String)string).append(" = ").append((CharSequence)stringBuilder2).append(HybsConst.CR));
        this.options.forEach((string, stringBuilder2) -> stringBuilder.append((String)string).append(" opt = ").append((CharSequence)stringBuilder2).append(HybsConst.CR));
        return stringBuilder.toString();
    }
}

