<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE7001"
	title    = "取込要求ﾃｰﾌﾞﾙ"
	date     = "2017/06/27"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
		select	A.SYSTEM_ID , A.RSRV_NO , A.FGYKAN , A.EXECID , B.NAME_JA
				 , A.DIR_BASE , A.DIR_SUB , A.DIR_WORK , A.DIR_BKUP_OK , A.DIR_BKUP_NG , A.FILE_FILTER
				 , A.RELEASE_NOTES , A.RDC_CODE , A.DYUPD , A.USRUPD , A.FGJ , A.UNIQ
		from GE70 A left outer join GE72 B
				on  A.EXECID=B.EXECID
	<og:where>
		<og:and value = "A.SYSTEM_ID	=		'{@SYSTEM_ID}'"		/>
		<og:and value = "A.RSRV_NO		=		'{@RSRV_NO}'"		/>
		<og:and value = "B.NAME_JA		like	'{@NAME_JA}'"		/>
		<og:and value = "A.EXECID		like	'{@EXECID}'"		/>
		<og:and value = "A.FGYKAN		=		'{@FGYKAN}'"		/>
		<jsp:directive.include file="/jsp/custom/releaseNotesWhereA.jsp" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.RSRV_NO" />
</og:query>

<og:viewLink command="{@command}">
	<og:link column="RSRV_NO" gamenId="GE7002" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,RSRV_NO,DYFROM,DYTO,FGJ"
		vals="NEW,{@SYSTEM_ID},[RSRV_NO],{@DATE.YMD},{@DATE.YMD},1" />
	<og:link column="EXECID" gamenId="GE7003" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,EXECID,DYFROM,DYTO,FGJ"
		vals="NEW,{@SYSTEM_ID},[EXECID],{@DATE.YMD},{@DATE.YMD},1" />
</og:viewLink>

<form method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
	<og:submit  action="COPY"    noWritable="null" />
	<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,RSRV_NO"  />
	<og:submit  action="DELETE"  columnWritable="null" />
	<br />
</og:writeCheck>

<og:columnEditor columns="FILE_FILTER" clazz="W100" />
<og:columnEditor columns="SYSTEM_ID,RSRV_NO,EXECID,FGYKAN" must="true" />

<og:view
	viewFormType = "HTMLTable"
	command 	= "{@command}"
	noDisplay	= "UNIQ"
	checked 	= "{@checked}"
	startNo 	= "{@startNo}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
