/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import org.opengion.fukurou.fileexec.AppliExec;
import org.opengion.fukurou.fileexec.BasePath;
import org.opengion.fukurou.fileexec.CommandLine;
import org.opengion.fukurou.fileexec.DBUtil;
import org.opengion.fukurou.fileexec.FileUtil;
import org.opengion.fukurou.fileexec.FileWatch;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.PathMatcherSet;
import org.opengion.fukurou.fileexec.StringUtil;
import org.opengion.fukurou.fileexec.XLogger;

public class FileExec {
    private static final XLogger LOGGER = XLogger.getLogger(FileExec.class.getSimpleName());
    public static final String CR = System.getProperty("line.separator");
    private final TBL_GE71 tableGE71;
    private final String systemId;
    private final String rsrvNo;
    private final String execId;
    private final String fileFltr;
    private final BasePath basePath;
    private final FileWatch fWatch;
    private static final String PROP = ".properties";
    private static final String BAT = ".bat";
    private static final String JAR = ".jar";
    private static final PathMatcher SCAN_EXT = path -> {
        String string = path.getFileName().toString();
        return !string.endsWith(PROP) && !string.endsWith(BAT) && !string.endsWith(JAR);
    };

    public FileExec(CommandLine commandLine) {
        LOGGER.debug(() -> "\u2461 CommandLine=" + commandLine);
        this.systemId = commandLine.getValue(CommandLine.GE70.SYSTEM_ID);
        this.rsrvNo = commandLine.getValue(CommandLine.GE70.RSRV_NO);
        this.execId = commandLine.getValue(CommandLine.GE70.EXECID);
        this.fileFltr = commandLine.getValue(CommandLine.GE70.FILE_FILTER);
        this.basePath = new BasePath(commandLine.getValue(CommandLine.GE70.DIR_BASE), commandLine.getValue(CommandLine.GE70.DIR_SUB), commandLine.getValue(CommandLine.GE70.DIR_WORK), commandLine.getValue(CommandLine.GE70.DIR_BKUP_OK), commandLine.getValue(CommandLine.GE70.DIR_BKUP_NG));
        this.tableGE71 = new TBL_GE71(this.systemId, this.rsrvNo, this.execId);
        this.fWatch = new FileWatch(this.basePath.SUB_PATH);
        this.fWatch.setPathMatcher(SCAN_EXT);
        this.fWatch.setPathMatcher(path -> this.basePath.isScanPath(path));
    }

    public void watchStart() {
        LOGGER.debug(() -> "\u2463 [watchStart()]");
        this.fWatch.setEventKinds(FileWatch.CREATE, FileWatch.MODIFY);
        this.fWatch.setPathMatcher(new PathMatcherSet().addFileName(this.fileFltr));
        this.fWatch.callback((string, path) -> this.checkFile((String)string, (Path)path));
        this.fWatch.start();
    }

    public void watchStop() {
        LOGGER.debug(() -> "\u2469 [watchStop()]");
        AppliExec.removeInstance(this.systemId, this.rsrvNo);
        this.fWatch.stop();
    }

    private void checkFile(String string, Path path) {
        AppliExec appliExec;
        String string2;
        int n;
        String string3;
        Path path2;
        String string4;
        block11: {
            if (Files.isDirectory(path, new LinkOption[0]) || !Files.exists(path, new LinkOption[0])) {
                return;
            }
            string4 = "0";
            path2 = null;
            string3 = "";
            n = -1;
            string2 = StringUtil.getTimeFormat();
            appliExec = null;
            try {
                if (FileUtil.stablePath(path)) {
                    LOGGER.debug(() -> "\u2464 event=" + string + " , Path=" + path);
                    appliExec = AppliExec.newInstance(this.systemId, this.rsrvNo, this.execId);
                    path2 = FileUtil.backup(path, this.basePath.WORK_PATH);
                    n = appliExec.exec(path2);
                    string4 = n >= 0 ? "2" : "8";
                    break block11;
                }
                LOGGER.info(() -> "checkFile Not stablePath. " + path);
                return;
            }
            catch (Throwable throwable) {
                string4 = "7";
                string3 = MsgUtil.errPrintln(throwable, "MSG0021", path);
            }
        }
        if (appliExec != null) {
            try {
                appliExec.endExec(path2, string4, string3);
            }
            catch (Throwable throwable) {
                if (!"7".equals(string4)) {
                    string4 = "8";
                }
                string3 = MsgUtil.errPrintln(throwable, "MSG0032", path);
            }
        }
        Path path3 = null;
        Path path4 = null;
        if (path2 != null && Files.exists(path2, new LinkOption[0])) {
            if ("2".equals(string4)) {
                path3 = FileUtil.backup(path2, this.basePath.OK_PATH);
            } else {
                path4 = FileUtil.backup(path2, this.basePath.NG_PATH);
            }
        }
        this.tableGE71.dbInsert(string4, string2, path, path3, path4, n, string3);
    }

    public String toString() {
        return String.join((CharSequence)",", this.systemId, this.rsrvNo, this.execId);
    }

    private static final class TBL_GE71 {
        private static final String[] KEYS = new String[]{"SYSTEM_ID", "RSRV_NO", "EXECID", "FGTKAN", "TMSTR", "TMEND", "FILE_IN", "FILE_OK", "FILE_NG", "SUTORI ", "ERRMSG ", "DYSET", "DYUPD"};
        private static final String[] CON_KEYS = new String[]{"FGJ", "PGSET", "PGUPD"};
        private static final String[] CON_VALS = new String[]{"1", "FileExec", "FileExec"};
        private static final String INS_QUERY = DBUtil.getInsertSQL("GE71", KEYS, CON_KEYS, CON_VALS);
        private final String systemId;
        private final String rsrvNo;
        private final String execId;

        public TBL_GE71(String string, String string2, String string3) {
            this.systemId = string;
            this.rsrvNo = string2;
            this.execId = string3;
        }

        public void dbInsert(String string, String string2, Path path, Path path2, Path path3, int n, String string3) {
            String string4 = StringUtil.getTimeFormat();
            String string5 = path == null ? "" : path.getFileName().toString();
            String string6 = path2 == null ? "" : path2.getFileName().toString();
            String string7 = path3 == null ? "" : path3.getFileName().toString();
            String[] stringArray = new String[]{this.systemId, this.rsrvNo, this.execId, string, string2, string4, string5, string6, string7, String.valueOf(n), string3, string4, string4};
            LOGGER.debug(() -> "\u2465 GE71.dbInsert query=" + INS_QUERY + "\n\t values=" + Arrays.toString(stringArray));
            DBUtil.execute(INS_QUERY, stringArray);
        }
    }
}

