/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.Shell;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public class ReportPrint {
    private final int TIMEOUT = HybsSystem.sysInt("REPORT_DAEMON_TIMEOUT");
    private final StringBuilder errMsg = new StringBuilder(200);
    private final String SYSTEM_ID;
    private final String YKNO;
    private final String PRTID;
    private String prtNM;
    private final String programFile;
    private final String htmlDir;
    private final String modelFile;
    private final String pdfFile;
    private final String DMN_GRP;
    private final boolean DEBUG;
    private String BASE_SYS_ID = "**";
    private String shellCmd;
    private static final String GE55_SELECT = "SELECT PRTNM,SYSTEM_ID from (  select 0 as SNO,B.* from GE55 B where SYSTEM_ID='**' and PRTID=? and FGJ='1'  union all  select 1 as SNO,B.* from GE55 B where SYSTEM_ID=? and PRTID=? and FGJ='1'  union all  select 2 as SNO,B.* from GE55 B where SYSTEM_ID=? and PRTID=? and FGJ='1' ) A order by SNO,SYSTEM_ID";
    private static final int GE55_PRTNM = 0;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");

    public ReportPrint(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        this.SYSTEM_ID = string;
        this.YKNO = string2;
        this.PRTID = string3;
        this.programFile = string4;
        this.htmlDir = string5;
        this.modelFile = string6;
        this.pdfFile = string7;
        this.DMN_GRP = string8;
        this.DEBUG = bl;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("ReportPrint", this.YKNO, this.PRTID);
        } else {
            this.appInfo = null;
        }
    }

    public boolean execute() {
        boolean bl;
        System.out.print("ReportPrint Started ... ");
        try {
            bl = this.initialDataSet();
            if (bl) {
                System.out.print("INIT,");
            }
            if (bl && (bl = this.makeShellCommand())) {
                System.out.print("SHELL,");
            }
            if (bl && (bl = this.programRun())) {
                System.out.print("RUN,");
            }
        }
        catch (RuntimeException runtimeException) {
            this.errMsg.append("ReportPrint Execute Error! ").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append(ThrowUtil.ogStackTrace((Throwable)runtimeException)).append(HybsConst.CR);
            bl = false;
        }
        System.out.println("End.");
        return bl;
    }

    private boolean initialDataSet() {
        String string = HybsSystem.sys("RESOURCE_BASE_SYSTEM_ID", false);
        String string2 = this.BASE_SYS_ID = StringUtil.isEmpty((CharSequence[])new CharSequence[]{string}) ? "**" : string;
        if (this.PRTID == null) {
            this.errMsg.append("PRTID columns does not exist in GE55 table.").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , PRTID=[").append(this.PRTID).append(']').append(HybsConst.CR);
            return false;
        }
        String[] stringArray = new String[]{this.PRTID, this.BASE_SYS_ID, this.PRTID, this.SYSTEM_ID, this.PRTID};
        String[][] stringArray2 = DBUtil.dbExecute((String)GE55_SELECT, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
        if (stringArray2 == null || stringArray2.length == 0) {
            this.errMsg.append("Data does not exist in GE55 table.").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , PRTID=[").append(this.PRTID).append(']').append(HybsConst.CR);
            return false;
        }
        int n = stringArray2.length;
        this.prtNM = StringUtil.nval((String)stringArray2[n][0], (String)this.prtNM);
        if (this.DEBUG) {
            System.out.println("SYSTEM_ID   =" + this.SYSTEM_ID);
            System.out.println("YKNO        =" + this.YKNO);
            System.out.println("PRTID       =" + this.PRTID);
            System.out.println("PRTNM       =" + this.prtNM);
            System.out.println("programFile =" + this.programFile);
            System.out.println("htmlDir     =" + this.htmlDir);
            System.out.println("pdfFile     =" + this.pdfFile);
            System.out.println("DMN_GRP     =" + this.DMN_GRP);
            System.out.println("GE55_SELECT =SELECT PRTNM,SYSTEM_ID from (  select 0 as SNO,B.* from GE55 B where SYSTEM_ID='**' and PRTID=? and FGJ='1'  union all  select 1 as SNO,B.* from GE55 B where SYSTEM_ID=? and PRTID=? and FGJ='1'  union all  select 2 as SNO,B.* from GE55 B where SYSTEM_ID=? and PRTID=? and FGJ='1' ) A order by SNO,SYSTEM_ID");
        }
        return true;
    }

    private boolean makeShellCommand() {
        StringBuilder stringBuilder = new StringBuilder(200).append(this.programFile).append(' ').append('\"').append(this.htmlDir).append(HybsConst.FS).append(this.YKNO).append("_*.html\" ").append('\"').append(this.prtNM).append("\" ");
        if (this.pdfFile == null) {
            stringBuilder.append('\"').append(this.htmlDir).append(HybsConst.FS).append(this.YKNO).append(".xls\" ");
        } else {
            stringBuilder.append('\"').append(this.pdfFile).append("\" ");
        }
        if (this.modelFile == null) {
            stringBuilder.append("DMY_MDL ");
        } else {
            stringBuilder.append(this.modelFile).append(' ');
        }
        stringBuilder.append(this.DMN_GRP).append(' ').append(this.PRTID);
        this.shellCmd = stringBuilder.toString();
        System.out.println(HybsConst.CR + this.shellCmd + HybsConst.CR);
        return true;
    }

    private boolean programRun() {
        Shell shell = new Shell();
        shell.setCommand(this.shellCmd, true);
        shell.setWait(true);
        shell.setTimeout(this.TIMEOUT);
        int n = shell.exec();
        if (n != 0) {
            this.errMsg.append("Shell Command exequte Error.").append(HybsConst.CR);
            this.errMsg.append("==============================").append(HybsConst.CR);
            this.errMsg.append(this.shellCmd).append(HybsConst.CR);
            this.errMsg.append(shell.getStdoutData()).append(HybsConst.CR);
            this.errMsg.append(shell.getStderrData()).append(HybsConst.CR);
            this.errMsg.append(HybsConst.CR);
            return false;
        }
        return true;
    }

    public String getErrMsg() {
        return this.errMsg.toString();
    }
}

