<?xml version="1.0" encoding="UTF-8" ?>
	<!-- 過去のLOGフォルダを見つけるする -->
	<og:fileQuery
		command		= "NEW"
		from		= "{@WORK_DIR}/LOGFILE"
		addFrom		= "false"
		fileType	= "DIR"
		maxRowCount	= "0"
		displayMsg	= ""
		notfoundMsg	= ""
		useTimeView	= "false"
	>
		<og:fileWhere
			startsDir	= "X"
			unStartsDir	= "X{@DATE.yyyyMMdd}"
			debug		= "{@debug}"
		/>
	</og:fileQuery>

	<!-- 過去のLOGフォルダを削除する -->
	<og:fileUpdate
		action		= "DELETE"
		command		= "ENTRY"
		selectedAll	= "true"
		displayMsg	= ""
		outMessage	= "false"
		useTimeView	= "false"
	/>

	<!-- ALLCHECK でない場合、対象のソース一覧を取得する。(nameOnlyで拡張子を除去) -->
	<og:equals val1="{@CHBOX}" val2="ALLCHECK" notEquals="true" >
		<og:fileQuery
			command		= "NEW"
			from		= "{@SQL_PATH}/{@SQL_DIR}"
			nameOnly	= "true"
			fileType	= "FILE"
			orderBy		= "NAME"
			maxRowCount	= "0"
			displayMsg	= ""
			notfoundMsg	= ""
			useTimeView	= "false"
			debug		= "{@debug}"
		>
			<og:fileWhere
				endsWith	= "sql|SQL"
				debug		= "{@debug}"
			/>
		</og:fileQuery>

		<!-- 対象のソース一覧から、名前部分を抜き出して連結する。 -->
		<og:value command="SETTBL" action="ALL_APPEND" key="NAME" separator="、" />
		<og:value command="SET" action="LENGTH" key="NLEN" value="{@NAME}" />

		<og:equals val1="{@NLEN}" val2="1760" operator="GT" useStop="true" compareType="NUMBER" >
			<!-- 文字列の長さが指定の長さよりも長いです。ｷｰ={0} 値={1} 長さ=[{2}] > [{3}] -->
			<b class="error"><og:message lbl="ERR0006" val0="{@PROGRAM}" val1="{@LBL.P_VALS}" val2="{@NLEN}" val3="1760" /></b>
		</og:equals>

		<og:value command="SET" action="SUBSTR" key="NAME2" value="{@NAME}" fromVal="0"		toVal="220"		/>
		<og:value command="SET" action="SUBSTR" key="NAME3" value="{@NAME}" fromVal="220"	toVal="440"		/>
		<og:value command="SET" action="SUBSTR" key="NAME4" value="{@NAME}" fromVal="440"	toVal="660"		/>
		<og:value command="SET" action="SUBSTR" key="NAME5" value="{@NAME}" fromVal="660"	toVal="880"		/>
		<og:value command="SET" action="SUBSTR" key="NAME6" value="{@NAME}" fromVal="880"	toVal="1100"	/>
		<og:value command="SET" action="SUBSTR" key="NAME7" value="{@NAME}" fromVal="1100"	toVal="1320"	/>
		<og:value command="SET" action="SUBSTR" key="NAME8" value="{@NAME}" fromVal="1320"	toVal="1540"	/>
		<og:value command="SET" action="SUBSTR" key="NAME9" value="{@NAME}" fromVal="1540"	toVal="1760"	/>
	</og:equals>

	<!-- チェック用のバッチファイルを実行する。 -->
	<pre>
		<og:shell
			workDir		= "{@WORK_DIR}"
			program		= '{@PROGRAM} "{@XKEY}" "{@NAME2}" "{@NAME3}" "{@NAME4}" "{@NAME5}" "{@NAME6}" "{@NAME7}" "{@NAME8}" "{@NAME9}"'
			action		= "RUN"
			useBatch	= "true"
			wait		= "true"
			stdout		= "true"
			stderr		= "true"
			info		= "true"
			display		= "false"
			useStop		= "false"
			debug		= "{@debug}"
		/>
	</pre><br />

	<!-- 実行結果のCHECK_DIRフォルダをスキャンして、ファイル一覧を取得する。 -->
	<og:fileQuery
		command		= "NEW"
		from		= "{@WORK_DIR}/LOGFILE/{@XKEY}/{@CHECK_DIR}"
		fileType	= "FILE"
		useText		= "true"
		orderBy		= "NAME"
		maxRowCount	= "0"
		displayMsg	= ""
		notfoundMsg	= ""
		useTimeView	= "false"
		debug		= "{@debug}"
	>
		<og:fileWhere
			endsWith	= "LOG"
			debug		= "{@debug}"
		/>
	</og:fileQuery>

	<!-- ファイル一覧の中身から、指定のキーワードの内側だけ切り取る。 -->
	<og:columnEditor column="TEXT" renderer="SUBSTR" param="**********$$ORA" />

	<!-- ファイル一覧の中身を表示する。 -->
	<og:view
		command			= "NEW"
		pageSize		= "100000"
		useScrollBar	= "false"
		columnDisplay	= "TEXT"
		selectedType	= "none"
		noMessage		= "true"
	/>
