<jsp:directive.page pageEncoding="UTF-8" />
<og:query command="{@command}" debug="{@debug}" maxRowCount="0" stopZero="true">
	select * from (
		select	RENDERER,EDITOR,DBTYPE,'' as DTYPE,KBCLM,
				CLM,CLM_NAME,TABLE_NAME,SEQNO,
				CLS_NAME,VIEW_LENGTH,USE_LENGTH,NOT_NULL,
				case	when 
							(
								(
										RENDERER not in ( 'MENU','DBMENU','CHBOX','DATALIST' )
									or	EDITOR   not in ( 'MENU','DBMENU','CHBOX','DATALIST' )
				--					or	CLS_NAME like 'VARCHAR%'
								)
								and	(
										CLM like 'FG%'
									or  CLM like 'CD%'
									or  CLM like 'KB%'
								)
								and	(	USE_LENGTH in ( '1','2' )	)
							) then '01 FG,CD,KBで始まるカラムが、MENU 関係ではありません'
						when
							(
								NOT_NULL is null
								and	(
										CLS_NAME in ( 'NUMBER','DECIMAL','INTEGER' )
									or	RENDERER in ( 'MENU','DBMENU','CHBOX','DATALIST' )
									or	EDITOR   in ( 'MENU','DBMENU','CHBOX','DATALIST' )
								)
							) then '02 NUMBER型や MENU 関係のカラムに、NOT NULL 指定がありません'
						when
							(
								CLS_NAME not in ( 'NUMBER','DECIMAL','INTEGER' )
								and	(
										CLM like 'SU%'
									or  CLM like 'NO%'
									or  CLM like 'KN%'
									or  CLM like 'TK%'
									or  CLM like 'SEQ%'
								)
							) then '03 SU,NO,KN,TK,SEQで始まるカラムが、NUMBER型ではありません'
						when
							(
								CLM like 'NM%'
								and	(
										CLS_NAME not like 'VARCHAR%'
									or	instr( CLM_NAME , '名' ) = 0
								)
							) then '04 NMで始まるカラムが、VARCHAR2型でない、または「名」が付いていません'
						when
							(
								CLM like 'DY%'
								and	(
										RENDERER not in ( 'YMD','YMDH','MD','YM','DATE' )
									or	EDITOR   not in ( 'YMD','YMDH','MD','YM','DATE' )
									or	DBTYPE   not in ( 'YMD','YMDH','MD','YM','DATE' )
									or	CLS_NAME not like 'VARCHAR%'
								)
							) then '05 DYで始まるカラムが、日付型ではありません'
						when
							(
						--		regexp_instr( CLM_NAME , '[０-９Ａ-Ｚａ-ｚァ-ヶ]' ) > 0
								regexp_instr( CLM_NAME , '[０-９Ａ-Ｚａ-ｚ]' ) > 0
							) then '06 カラム名に全角英数字が使われています'
						when
							(
								( instr( CLM_NAME , '番号' ) > 0 or instr( CLM_NAME , 'ID' ) > 0 )
								and (
										UK  is null AND LUK is null AND IXA is null AND IXB is null AND IXC is null
													AND IXD is null AND IXE is null AND IXF is null AND IXG is null
													AND IXH is null AND IXI is null AND IXJ is null AND IXK is null
								)
							) then '07 カラム名称に「番号」や「ID」が使われているのにインデックスがありません'
						else null end as RIYU ,
				SYSTEM_ID,FGJ,UNIQ
		from GE82
		where SYSTEM_ID  = '{@SYSTEM_ID}'
		and   TBLSYU      = '{@TBLSYU}'
		<og:where startKey="and">
			<og:and value="TABLE_NAME like '{@TABLE_NAME}'" />
			<og:and value="CLM        like '{@CLM}'" />
		</og:where>
		and   KBCLM		<= '7'
		and   FGJ		= '1'
	)
	where RIYU is not null
	order by SYSTEM_ID,CLM,TABLE_NAME
</og:query>

<!-- UNIQ のみでユニークになるが、安全のため、SYSTEM_IDとTBLSYUだけは条件に加えておく -->
<og:hidden name="SQL" >
	UPDATE GE82 SET
			RENDERER	= [RENDERER],
			EDITOR		= [EDITOR],
			DBTYPE		= [DBTYPE],
			KBCLM		= [KBCLM],
			CLM_NAME	= [CLM_NAME],
			CLS_NAME	= [CLS_NAME],
			VIEW_LENGTH	= [VIEW_LENGTH],
			USE_LENGTH	= [USE_LENGTH],
			NOT_NULL	= [NOT_NULL],
			COMMENTS	= '{@DATE.YMDF} {@LBL.@ACTION}',
			CDKH		= 'C',
			FGJ			= '1',
			DYUPD		= '{@USER.YMDH}',
			USRUPD		= '{@USER.ID}',
			PGUPD		= '{@GUI.KEY}'
	WHERE SYSTEM_ID	= '{@SYSTEM_ID}'
	AND   TBLSYU	= '{@TBLSYU}'
	AND   UNIQ		= [UNIQ]
</og:hidden>

<og:value key="noDisplay" value="CLS_NAME,VIEW_LENGTH,USE_LENGTH" />
<og:hidden name="noDisplay">{@noDisplay}</og:hidden>

<og:hidden name="noWritable">TABLE_NAME,CLM,SYSTEM_ID,DTYPE,RIYU,SEQNO</og:hidden>
<og:hidden name="columnBulkSet" value="*" />
