<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
    xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:og="hybs-taglib.tld"
    version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
	<!-- イメージをタイル状に表示する為の CSSﾌｧｲﾙ  -->
	<link rel="stylesheet" type="text/css" href="imageTbl.css" />
</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6380"
	title	= "ファイルクエリー"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<form>
<og:select name="FileOption">
    <og:fileOption
		from		= "{@from}"
		value		= "{@VALUE}"
		orderBy		= "{@orderBy}"
		desc		= "{@desc}"
		groupDir	= "{@groupDir}"
		debug		= "{@debug}"
	>
			<og:fileWhere
				startsWith		= "{@startsWith}"
				endsWith		= "{@endsWith}"
				instr			= "{@instr}"
				equals			= "{@equals}"
				matches			= "{@matches}"
				unMatches		= "{@unMatches}"
				lastModified	= "{@lastModified}"
				isLarger		= "{@isLarger}"
				isSmaller		= "{@isSmaller}"
				isHidden		= "{@isHidden}"
				notEquals		= "{@notEquals}"
				debug			= "{@debug}"
			/>
    </og:fileOption>
</og:select>

<og:column name="FileOptionList" list="dl_FileOptionList" />
<og:datalist id="dl_FileOptionList">
    <og:fileOption
		from		= "{@from}"
		value		= "{@VALUE}"
		orderBy		= "{@orderBy}"
		desc		= "{@desc}"
		groupDir	= "{@groupDir}"
		debug		= "{@debug}"
	>
			<og:fileWhere
				startsWith		= "{@startsWith}"
				endsWith		= "{@endsWith}"
				instr			= "{@instr}"
				equals			= "{@equals}"
				matches			= "{@matches}"
				unMatches		= "{@unMatches}"
				lastModified	= "{@lastModified}"
				isLarger		= "{@isLarger}"
				isSmaller		= "{@isSmaller}"
				isHidden		= "{@isHidden}"
				notEquals		= "{@notEquals}"
				debug			= "{@debug}"
			/>
    </og:fileOption>
</og:datalist>
</form>

<!-- イメージをタイル状に表示する為の切り替えリンク(引数を渡すため) -->
<span style="float:right;">
	<og:link href="result.jsp" target="RESULT" keys="command" vals="RENEW">
		<og:img src="{@SYS.JSP}/image/listS.png" alt="{@LBL.FGVIEW.1}" />
	</og:link>
	<og:link href="result.jsp" target="RESULT" keys="command,FGVIEW,addClms,fileType" vals="RENEW,2,IMG,FILE">
		<og:img src="{@SYS.JSP}/image/listImg.png" alt="{@LBL.FGVIEW.2}" />
	</og:link>
	<og:link href="result.jsp" target="RESULT" keys="command,FGVIEW,addClms,fileType" vals="RENEW,3,IMG,FILE">
		<og:img src="{@SYS.JSP}/image/listnail.png" alt="{@LBL.FGVIEW.3}" />
	</og:link>
</span>

<br />
<og:message lbl="FileQuery:" />
<br />

<og:fileQuery
	command			= "{@command}"
	from			= "{@from}"
	multi			= "{@multi}"
	level			= "{@level}"
	orderBy			= "{@orderBy}"
	desc			= "{@desc}"
	useWritable 	= "{@useWritable}"
	useMD5			= "{@useMD5}"
	useText			= "{@useText}"
	useUpdateClms	= "{@useUpdateClms}"
	addClms			= "{@addClms}"
	stopZero		= "{@stopZero}"
	maxRowCount		= "{@maxRowCount}"
	fileType		= "{@fileType}"
	addFrom			= "{@addFrom}"
	fromBase		= "{@fromBase}"
	debug			= "{@debug}"
>
	<og:fileWhere
		startsWith		= "{@startsWith}"
		endsWith		= "{@endsWith}"
		instr			= "{@instr}"
		equals			= "{@equals}"
		matches			= "{@matches}"
		unMatches		= "{@unMatches}"
		lastModified	= "{@lastModified}"
		isLarger		= "{@isLarger}"
		isSmaller		= "{@isSmaller}"
		isHidden		= "{@isHidden}"
		notEquals		= "{@notEquals}"
		debug			= "{@debug}"
	/>
</og:fileQuery>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="NAME" href="../fileDownload" useGamenId="false" target="_NEW" useHrefEncode="true"
		keys="file,name" vals="[PARENT]/[NAME],[NAME]" />
</og:viewLink>

<og:equals val1="{@addClms}" val2="IMG">
	<og:viewMarker command="{@command}" >
		<og:columnMarker column="IMG" onMark="[FILE_TYPE]" markList="F" >
			<og:img src="[PARENT]/[NAME]" alt="[NAME]" title="[NAME]" height="100px" />
		</og:columnMarker>
	</og:viewMarker>
</og:equals>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT">
	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:equals val1="{@useUpdateClms}" val2="true">
		<og:writeCheck>
			<og:submit  action="COPY"    noWritable="LEVEL,FILE_TYPE,PARENT,NAME,LASTMODIFIED,FILE_LENGTH,RWH" />
			<og:submit  action="MODIFY"  noWritable="LEVEL,FILE_TYPE,PARENT,NAME,LASTMODIFIED,FILE_LENGTH,RWH" />
			<og:submit  action="DELETE"  columnWritable="null" />
		<br />
		</og:writeCheck>
	</og:equals>

	<og:equals val1="{@FGVIEW}" nullCheck="true" >
		<og:view
			viewFormType = "HTMLTable"
			command    = "{@command}"
			startNo    = "{@startNo}"
			pageSize   = "{@pageSize}"
		/>
	</og:equals>
	<og:equals val1="{@FGVIEW}" val2="2" >
		<og:view
			viewFormType = "CustomData"
			command		 = "{@command}"
			writable	 = "false"
			useScrollBar = "false"
			numberType	 = "delete"
			bgColorCycle = "1"
			useHilightRow= "false"
		>
			<og:thead rowspan="1">
				<tr><td rowspan="4"></td></tr>
			</og:thead>
			<og:tbody rowspan="1" >
				<table class="imageTbl">
					<tr><td>[IMG]</td></tr>
					<tr><td>[NAME]</td></tr>
					<tr><td>[PARENT]</td></tr>
					<tr><td>[FILE_LENGTH]</td></tr>
					<tr><td>[LASTMODIFIED]</td></tr>
				</table>
			</og:tbody>
		</og:view>
	</og:equals>
	<og:equals val1="{@FGVIEW}" val2="3" >
		<og:view
			viewFormType = "CustomData"
			command		 = "{@command}"
			writable	 = "false"
			useScrollBar = "false"
			numberType	 = "delete"
			bgColorCycle = "1"
			useHilightRow= "false"
		>
			<og:thead rowspan="1">
				<tr><td rowspan="2"></td></tr>
			</og:thead>
			<og:tbody rowspan="1" >
				<table class="imageTbl">
					<tr><td>[IMG]</td></tr>
					<tr><td>[NAME]</td></tr>
				</table>
			</og:tbody>
		</og:view>
	</og:equals>
</form>

<og:equals val1="{@action}" val2="COPY">
	<og:fileUpdate
		action			= "COPY"
		command			= "ENTRY"
		inPath			= "{@from}"
		targetDir		= "{@targetDir}"
		createDir		= "{@createDir}"
		selectedAll		= "{@selectedAll}"
		keepTimeStamp	= "{@keepTimeStamp}"
	/>
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
