<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" adjustEvent="Table" />	<!-- 左右分割 -->

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7215"
	title	= "左右分割（特殊）"
	date	= "2012/08/17"
	author	= "S.Li"
	text	= "システム、プログラムＩＤ、処理名、作成日、作成者を修正して下さい。"
	version	= "001">
	adjustGantTable.jsの機能を利用してテーブルの左右分割スクロールを行います。
	通常の左右分割は２つのテーブルを左右に並べるため、セルの高さが異なってずれる場合が
	ありました（但し調整するロジックは入っています）が、こちらの方法は１つのテーブルを
	利用するため、ずれが抑えられます。
	リサイズされない等の副作用があるため、特別な理由が無い限りは通常の左右分割方式を利用して下さい。
</og:comment>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	SELECT	 NOORDER
			,KNORDER
			,KNJISK
			,KNMIKM
			,SUORDER
			,PN
			,PHOTO
			,SINTYOKU * 100 as SIN_PER
			,SINTYOKU
			,NMCUST
			,DYORDER
			,DYNOKI
			,DYSET
			,PGSET
			,PGPSET
			,USRSET
			,DYUPD
			,PGUPD
			,PGPUPD
			,USRUPD
			,UNIQ
			,FGJ
	FROM GF45
	<og:where>
		<og:and value="NOORDER = '{@NOORDER}'" />
	</og:where>
	<og:appear startKey="ORDER BY" value="{@ORDER_BY}" defaultVal="PN" />
</og:query>

<og:viewMarker command="{@command}" >
	<og:columnMarker column="PHOTO" >
		<img src="image/[PHOTO]" alt="[PN]" style="width:100px;" />
	</og:columnMarker>
	<og:columnMarker column="SIN_PER" >
		[SIN_PER]% <img width="[SIN_PER]px" height="10px" src="{@SYS.JSP}/image/space_green.gif" alt="[SIN_PER]" />
	</og:columnMarker>
</og:viewMarker>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT" >

	<og:writeCheck>
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="null" />
		<og:submit  action="MODIFY"  noWritable="NOORDER,UNIQ"  />
		<og:submit  action="DELETE"  columnWritable="null" />
	<br />
	</og:writeCheck>

	<og:view
		viewFormType = "HTMLTable"
		command		 = "{@command}"
		noDisplay	 = "SINTYOKU"
	/>
	<!--
	 iTableタグはadjustGantTable.js内での識別用タグです。
	 fixedColsの数字が左側に固定するカラムの数となります。
	 addEvent( this, "load", adjustTable );
	 で、ページロード時にadjustTable()関数を実行する必要があります。
	 又、通常のヘッダ固定と異なりサイズ変更でのリサイズは行われません。
	-->
	<og:iTable fixedCols="5" />
</form>


<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
