/**
 * <pre>
 * このドキュメントは、『はやぶさPlugIn』の ファイル入出力関連 PlugIn 仕様です。
 * 
 * ファイル入出力には、ChartWriter、TableReader、TableWriter というインターフェースが
 * あります。
 * 
 * 
 * ChartWriter は、<a href="http://ja.wikipedia.org/wiki/Scalable_Vector_Graphics">
 * SVG(Scalable Vector Graphics)</a>によるグラフ表示を行うクラスです。
 * 現在のエンジンでは、<a href="http://www.jfree.org/index.php">JFreeChart</a>による
 * グラフ表示を主に採用していますが、実験的要素として、SVG によるグラフも行いました。
 * 
 * 
 * TableReader は、ファイルの読み込みで、Excelネイティブとタブ区切りテキストの
 * 読み込みが主流です。それ以外の方式を採用する場合は、外部PlugInとして実装して
 * ください。
 * Excelネイティブでは、<a href="http://jakarta.jp/poi/">POI</a>による HSSF を
 * 使用しています。
 * 
 * 
 * なお、米Microsoftの，「Office 12」の XMLベースのファイル形式
 * 「Microsoft Office Open XML Formats」が、標準化組織 Ecma International により
 * Ecma TC45 OOXML Standard - Draft 1.3 として承認されています。
 * 
 * 
 * また、オープンソースのオフィス・アプリケーション<a href="OpenOffice.org">
 * OpenOffice.org</a>のXMLベースのファイル形式である、ODF(OpenDocument Format)も、
 * XML関連の標準化団体OASIS(Organization for the Advancement of Structured 
 * Information Standards)と、欧州委員会（European Commision）、
 * 国際標準化機構（ISO）も承認しています。
 * 
 * 
 * 今後の動向にあわせて、対応していくつもりです。
 * 
 * </pre>
 */
package org.opengion.plugin.io;
