/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opengion.fukurou.fileexec.AppliExec;
import org.opengion.fukurou.fileexec.DBUtil;
import org.opengion.fukurou.fileexec.LineSplitter;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.RunExec;
import org.opengion.fukurou.fileexec.StringUtil;
import org.opengion.fukurou.fileexec.XLogger;

public class RunExec_DBIN
implements RunExec {
    private static final XLogger LOGGER = XLogger.getLogger(RunExec_DBIN.class.getSimpleName());
    private static final String DEF_ENCODE = "Windows-31J";
    public static final String CR = System.getProperty("line.separator");

    @Override
    public int exec(Path path, String[] stringArray) {
        LOGGER.debug(() -> "\u2466 exec Path=" + path + " , GE72Data=" + Arrays.toString(stringArray));
        String string = stringArray[AppliExec.GE72.TABLE_NAME.NO];
        if (string == null || string.isEmpty()) {
            throw MsgUtil.throwException("MSG3003", new Object[0]);
        }
        String string2 = StringUtil.nval(stringArray[AppliExec.GE72.FILE_ENC.NO], DEF_ENCODE);
        String string3 = stringArray[AppliExec.GE72.CLMS.NO];
        ArrayList arrayList = new ArrayList();
        LineSplitter lineSplitter = new LineSplitter(string2, string3);
        lineSplitter.forEach(path, list2 -> arrayList.add(list2));
        String[] stringArray2 = lineSplitter.getColumns();
        if (stringArray2 == null || stringArray2.length == 0) {
            throw MsgUtil.throwException("MSG3004", new Object[0]);
        }
        ConstValsSet constValsSet = new ConstValsSet(path, stringArray[AppliExec.GE72.PARAMS.NO], stringArray[AppliExec.GE72.EXECID.NO]);
        constValsSet.setConstData();
        String[] stringArray3 = constValsSet.getConstKeys();
        String[] stringArray4 = constValsSet.getConstVals();
        String string4 = DBUtil.getInsertSQL(string, stringArray2, stringArray3, stringArray4);
        int n = StringUtil.nval(stringArray[AppliExec.GE72.SKIP_CNT.NO], 0);
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        if (!arrayList.isEmpty()) {
            for (int i = n; i < arrayList.size(); ++i) {
                List list = (List)arrayList.get(i);
                String[] stringArray5 = new String[stringArray2.length];
                for (int j = 0; j < stringArray2.length; ++j) {
                    stringArray5[j] = j < list.size() ? (String)list.get(j) : "";
                }
                arrayList2.add(stringArray5);
            }
        }
        return DBUtil.execute(string4, arrayList2);
    }

    @Override
    public void endExec(Path path, String[] stringArray, String string, String string2) {
        String string3 = stringArray[AppliExec.GE72.RUNPG.NO];
        if (string3 == null || string3.isEmpty()) {
            return;
        }
        LOGGER.debug(() -> "\u2467 endExec Path=" + path + " , runPG=" + string3 + " , fgtkan=" + string);
        String string4 = "{ call " + string3 + "}";
        String string5 = stringArray[AppliExec.GE72.EXECID.NO];
        String string6 = path.getFileName().toString();
        try (Connection connection = DBUtil.getConnection();){
            try (CallableStatement callableStatement = connection.prepareCall(string4);){
                callableStatement.setQueryTimeout(300);
                callableStatement.setFetchSize(1001);
                callableStatement.setInt(1, Integer.parseInt(string));
                callableStatement.setString(2, string2);
                callableStatement.registerOutParameter(1, 4);
                callableStatement.registerOutParameter(2, 12);
                callableStatement.setString(3, string5);
                callableStatement.setString(4, string6);
                callableStatement.execute();
                int n = callableStatement.getInt(1);
                if (n > 0) {
                    String string7 = callableStatement.getString(2);
                    throw MsgUtil.throwException("MSG0019", string4, string7);
                }
                connection.commit();
                LOGGER.debug(() -> "\u2468 Path=" + path + " , plsql=" + string4);
            }
            catch (SQLException sQLException) {
                connection.rollback();
                connection.setAutoCommit(true);
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            throw MsgUtil.throwException(sQLException, "MSG0019", string3, string5);
        }
    }

    private static final class ConstValsSet {
        private final Path path;
        private final String params;
        private final String pgset;
        private final String dyset;
        private String[] cnstKeys;
        private String[] cnstVals;

        public ConstValsSet(Path path, String string, String string2) {
            this.path = path;
            this.params = string;
            this.pgset = string2;
            this.dyset = StringUtil.getTimeFormat();
        }

        public void setConstData() {
            String[] stringArray;
            if (this.params != null && !this.params.isEmpty() && (stringArray = this.params.split(",")) != null && stringArray.length > 0) {
                int n = stringArray.length;
                this.cnstKeys = new String[n];
                this.cnstVals = new String[n];
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    int n2 = string.indexOf(61);
                    if (n2 > 0) {
                        this.cnstKeys[i] = string.substring(0, n2).trim();
                        this.cnstVals[i] = string.substring(n2 + 1).trim();
                        continue;
                    }
                    this.cnstKeys[i] = string.trim();
                    this.cnstVals[i] = this.getVal(this.cnstKeys[i]);
                }
            }
        }

        public String[] getConstKeys() {
            return this.cnstKeys;
        }

        public String[] getConstVals() {
            return this.cnstVals;
        }

        private String getVal(String string) {
            String string2;
            if ("FULL_PATH".equalsIgnoreCase(string)) {
                String string3 = "";
                try {
                    string3 = this.path.toFile().getCanonicalPath();
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                }
                string2 = string3;
            } else {
                switch (string) {
                    case "FILE_NAME": {
                        string2 = this.path.getFileName().toString();
                        break;
                    }
                    case "FGJ": {
                        string2 = "1";
                        break;
                    }
                    case "DYSET": {
                        string2 = this.dyset;
                        break;
                    }
                    case "DYUPD": {
                        string2 = this.dyset;
                        break;
                    }
                    case "PGSET": {
                        string2 = this.pgset;
                        break;
                    }
                    case "PGUPD": {
                        string2 = this.pgset;
                        break;
                    }
                    case "PGPSET": {
                        string2 = "GE7001";
                        break;
                    }
                    case "PGPUPD": {
                        string2 = "GE7001";
                        break;
                    }
                    case "USRSET": {
                        string2 = "BATCH";
                        break;
                    }
                    case "USRUPD": {
                        string2 = "BATCH";
                        break;
                    }
                    default: {
                        string2 = "";
                    }
                }
            }
            return string2;
        }
    }
}

