<jsp:directive.page pageEncoding="UTF-8" />
<!-- 画面別総計表示(JOIN) -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select B.GUIKEY,B.NAME_JA,B.SEQNO
				, sum(COALESCE(A.CNT_ACCESS,0))		AS SUM_ACCESS
				, sum(COALESCE(A.CNT_ERROR,0))		AS SUM_ERROR
				, sum(COALESCE(A.CNT_READ,0))		AS SUM_READ
				, sum(COALESCE(A.CNT_WRITE,0))		AS SUM_WRITE
				, sum(COALESCE(A.TM_TOTAL_QUERY,0)) AS SUM_TOTAL_QUERY
				, max(COALESCE(A.TM_MAX_QUERY,0))	AS TM_MAX_QUERY
		from GEA11 B left outer join GE15 A
		on      A.SYSTEM_ID = B.SYSTEM_ID
		and     A.GUIKEY    = B.GUIKEY
		and     B.FGJ       = '1'
	<og:where>
		<og:and value = "B.SYSTEM_ID	=	'{@SYSTEM_ID}'"	/>
		<og:and value = "B.GUIKEY		=	'{@GUIKEY}'"	/>
		<og:and value = "A.DYLOGIN		like '{@DATE}%'"	/>
	</og:where>
	group by B.SYSTEM_ID,B.GUIKEY,B.NAME_JA,B.SEQNO
	order by B.SYSTEM_ID,{@SORT} B.SEQNO
</og:query>

<og:viewLink command="{@command}">
	<og:link column="GUIKEY" gamenId="GE0002" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,GUIKEY,LANG"
		vals="NEW,{@SYSTEM_ID},[GUIKEY],ja" />
	<og:link column="TM_MAX_QUERY" href="result.jsp" target="RESULT"
		keys="command,SYSTEM_ID,GUIKEY,ACTION,TM_MAX_QUERY"
		vals="NEW,{@SYSTEM_ID},[GUIKEY],GEM0020,[TM_MAX_QUERY]" />
</og:viewLink>

<og:view
	viewFormType = "HTMLTable"
	command      = "{@command}"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}" />
