fs = require ('fs');

var liDir = 'LicenseTypes/';
var linefeed = '\r\n';
var dirname = 'licenses';

fs.access (dirname, error => {
  if (error) {
    fs.mkdirSync (dirname, err => {
      if (err) {
        console.log (err);
        return 1;
      }
    });
  }

  var text = fs.readFileSync ('input/in.csv');
  var lines = text.toString ().split (linefeed);

  var header = true;
  for (var line of lines) {
    // 1行目はheader
    if (header) {
      header = false;
      continue;
    }

    var data = line.split (',');
    var fileName = data[1] + '-license.txt';
    var moduleName = 'moduleName : ' + data[2] + linefeed;
    var licenseName = 'license : ' + data[3] + linefeed;
    var filePath = 'path : ' + data[4] + linefeed;

    if (fileName === '') continue;
    var fileData = '';
    if (data.length > 1) {
      fileData = moduleName + filePath + licenseName;
    }

    fs.writeFile (dirname + '/' + fileName, fileData, 'utf8', err => {
      if (err) console.log (err);
    });
  }
});
