<?xml version="1.0" encoding="UTF-8" ?>
	<!-- 過去のLOGフォルダを見つけるする -->
	<og:fileQuery
		command		= "NEW"
		from		= "{@WORK_DIR}/LOGFILE"
		addFrom		= "false"
		fileType	= "DIR"
		maxRowCount	= "0"
		displayMsg	= ""
		notfoundMsg	= ""
		useTimeView	= "false"
	>
		<og:fileWhere
			startsDir	= "X"
			unMatchDir	= "X{@DATE.yyyyMMdd}.*"
			debug		= "{@debug}"
		/>
	</og:fileQuery>

	<!-- 過去のLOGフォルダを削除する -->
	<og:fileUpdate
		action		= "DELETE"
		command		= "ENTRY"
		selectedAll	= "true"
		displayMsg	= ""
		useTimeView	= "false"
	/>

	<!-- チェック用のバッチファイルを実行する。 -->
	<pre>
		<og:shell
			workDir		= "{@WORK_DIR}"
			program		= "{@PROGRAM}"
			action		= "RUN"
			useBatch	= "true"
			wait		= "true"
			stdout		= "true"
			stderr		= "true"
			info		= "true"
			display		= "false"
			useStop		= "false"
			debug		= "{@debug}"
		/>
	</pre>

	<!-- 実行結果のCHECK_DIRフォルダをスキャンして、ファイル一覧を取得する。 -->
	<og:fileQuery
		command		= "NEW"
		from		= "{@WORK_DIR}/LOGFILE/{@XKEY}/{@CHECK_DIR}"
		fileType	= "FILE"
		useText		= "true"
		orderBy		= "NAME"
		maxRowCount	= "0"
		displayMsg	= ""
		notfoundMsg	= ""
		useTimeView	= "false"
		debug		= "{@debug}"
	>
		<og:fileWhere
			endsWith	= "LOG"
			debug		= "{@debug}"
		/>
	</og:fileQuery>

	<!-- ファイル一覧の中身から、指定のキーワードの内側だけ切り取る。 -->
	<og:columnEditor column="TEXT" renderer="SUBSTR" param="**********$$ORA" />

	<!-- ファイル一覧の中身を表示する。 -->
	<og:view
		command			= "NEW"
		pageSize		= "10000"
		useScrollBar	= "false"
		columnDisplay	= "TEXT"
		selectedType	= "none"
		noMessage		= "true"
	/>
