<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
	<script type="text/javascript" src="/gf/jsp/common/jquery/jquery-ui.js?v=1377478812228" ><!-- --></script>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9100"
	title	= "標準(PLSQL)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck command = "{@command}" />

<!-- データチェック -->
<og:equals val1="{@CDTAN}" val2="{@CDTAN}" >
	<og:dataCheck command="{@command}" lbl="GFE0003" lblParamKeys="{#GF44},{@CDTAN}">
		select count(*) from GF44 where USERID = '{@CDTAN}'
	</og:dataCheck>
</og:equals>
<!-- データチェック -->
<og:dataCheck
	command="{@command}"
	lbl="GFE0002"
	lblParamKeys="{#SYSTEM_ID},'ZW GE GF',{@SYSTEM_ID}"
>
	<![CDATA[
		'{@SYSTEM_ID}' == 'ZW' || '{@SYSTEM_ID}' == 'GE' || '{@SYSTEM_ID}' == 'GF'
	]]>
</og:dataCheck>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<!-- は不要です-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		SELECT	(CASE KBSAKU WHEN '0' THEN 0 ELSE 1 END) AS WRITABLE	<!-- 書込制御 -->
				,SYSTEM_ID												<!-- ｼｽﾃﾑID -->
				,LANG													<!-- 言語 -->
				,CLM													<!-- 項目 -->
				,NAME_JA												<!-- 名称(漢字) -->
				,LABEL_NAME												<!-- 表示名称 -->
				,KBSAKU													<!-- 作成区分 -->
				,CDTAN													<!-- 担当者 -->
				,UNIQ													<!-- (非表示)ﾕﾆｰｸ -->
				,''	as	PUP												<!-- ﾎﾟｯﾌﾟｱｯﾌﾟﾎﾞﾀﾝ -->
--				,'1' as u2
		FROM	GF41
	<og:where>
		<og:and value = "FGJ		IN		('0','1')"			/>	<!-- GF41》状態F    IN   ('0','1') -->
		<og:and value = "SYSTEM_ID	=		'{@SYSTEM_ID}'"		/>	<!-- GF41》ｼｽﾃﾑID   ＝   画面》ｼｽﾃﾑID-->
		<og:and value = "LANG		=		'{@LANG}'"			/>	<!-- GF41》言語     ＝   画面》言語-->
		<og:and value = "CLM		LIKE	'{@CLM}'"			/>	<!-- GF41》項目     LIKE 画面》項目-->
		<og:and value = "LABEL_NAME	LIKE	'{@LABEL_NAME}'"	/>	<!-- GF41》表示名称 LIKE 画面》表示名称 -->
		<og:and value = "KBSAKU		=		'{@KBSAKU}'" 		/>	<!-- GF41》作成区分 ＝   画面》作成区分 -->
		<og:and value = "CDTAN		=		'{@CDTAN}'" 		/>	<!-- GF41》担当者   ＝   画面》担当者 -->
	</og:where>
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。-->
<og:columnEditor columns="SYSTEM_ID,LANG,CLM" must="true" />
<og:columnEditor columns="LANG" editor="INMENU" must="true" />
<og:columnEditor columns="CLM" must="true" onChange="console.log('X');"/>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<!-- 項目 -->
	<og:link column="CLM" gamenId="GF9000" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,LANG,CLM,KBSAKU,IMAGE"
		vals="NEW,{@SYSTEM_ID},[LANG],[CLM],[KBSAKU],true" />
	<og:link column="NAME_JA" href="/gf/filetemp/check/テスト.txt" useURLCheck="true" keys="xxx" vals="te" />
</og:viewLink>

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<!-- onMarkはfalse/ture又は0/1、その他onMarkとmarkListと一致した時マーキングします。 -->
<og:viewMarker command="{@command}">
	<!-- 名称(漢字) -->
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="1" >
		<span style="background-color:#ccff00">[NAME_JA]</span>
	</og:columnMarker>
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="2" >
		<span style="background-color:#cc00ff">[NAME_JA]</span>
	</og:columnMarker>
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="3" >
		<span style="background-color:#00ffff">[NAME_JA]</span>
	</og:columnMarker>
	<!-- 表示名称 -->
	<og:columnMarker column="LABEL_NAME" onMark="[KBSAKU]" markList="3" >
		<font color='red'>[LABEL_NAME]</font>
	</og:columnMarker>
</og:viewMarker>

<!-- ポップアップ画面を表示します -->
<og:viewMarker command="{@command}" isRenderer="false">
	<og:popup column="PUP" gamenId="GF9110" href="popup.jsp"
			keys="CLM" vals="[CLM].value" rtnKeys="SYSTEM_ID,CLM,NAME_JA" 
			width="600px" height="600px" />
</og:viewMarker>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<!-- ここでは、すべてを、update.jsp に転送している為、command属性を設定しています。-->
<og:writeCheck>
	<og:submit  action="COPY"    noWritable="null" />
	<!-- PUP も、noWritable しておかないと、MODIFY 時に表示されてしまう。 -->
	<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,LANG,CLM,PUP"  />
	<og:submit  action="DELETE"  columnWritable="null" />
	<!-- ボタンで画面遷移するサンプルです。-->
	<og:submit  gamenId="GF9200" value="index" dbkeys="SYSTEM_ID,LANG,CLM" command="NEW" lbl="GF9200" target="CONTENTS" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<!-- サンプルではポップアップを使用するためviewFormTypeはHTMLCustomTableを使用します-->
<!-- 
<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ"
/>
-->
<og:view
	viewFormType = "HTMLCustomTable"
	command      = "{@command}"
	noDisplay    = "UNIQ"
>
	<og:thead rowspan="1">
		<tr>
			<td>[SYSTEM_ID]</td>										<!-- ｼｽﾃﾑID -->
			<td>[LANG]</td>												<!-- 言語 -->
			<td>[CLM]</td>												<!-- 項目 -->
			<td>[NAME_JA]</td>											<!-- 名称(漢字) -->
			<td>[LABEL_NAME]</td>										<!-- 表示名称 -->
			<td>[KBSAKU]</td>											<!-- 作成区分 -->
			<td>[CDTAN]</td>											<!-- 担当者 -->
<!--<td>[u2]</td	>-->
		</tr>
	</og:thead>
	<og:tbody rowspan="1">
		<tr>
			<td>[SYSTEM_ID]</td>										<!-- ｼｽﾃﾑID -->
			<td>[LANG]</td>												<!-- 言語 -->
			<td>[CLM]</td>												<!-- 項目 -->
			<td>[NAME_JA]</td>											<!-- 名称(漢字) -->
			<td>[LABEL_NAME]</td>										<!-- 表示名称 -->
			<td>[KBSAKU]</td>											<!-- 作成区分 -->
			<td>[CDTAN]</td>											<!-- 担当者 -->
<!--<td>[u2]</td>-->
		</tr>
	</og:tbody>
</og:view>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
