/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.view;

import java.util.List;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.html.TableFormatter;
import org.opengion.plugin.view.ViewForm_HTMLTable;

public class ViewForm_CustomData
extends ViewForm_HTMLTable {
    private static final String VERSION = "6.4.4.2 (2016/04/01)";
    private TableFormatter headerFormat;
    private TableFormatter[] bodyFormats;
    private TableFormatter footerFormat;
    private int bodyFormatsCount;
    private static final int BODYFORMAT_MAX_COUNT = 10;

    @Override
    public String create(int n, int n2) {
        if (this.getRowCount() == 0) {
            return "";
        }
        this.headerLine = null;
        int n3 = this.getLastNo(n, n2);
        if (this.headerFormat != null) {
            this.headerFormat.makeFormat(this.getDBTableModel());
            this.setFormatNoDisplay(this.headerFormat);
        }
        if (this.bodyFormatsCount > 0) {
            for (int i = 0; i < this.bodyFormatsCount; ++i) {
                this.bodyFormats[i].makeFormat(this.getDBTableModel());
                this.setFormatNoDisplay(this.bodyFormats[i]);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append(this.getHeader());
        for (int i = n; i < n3; ++i) {
            if (this.isSkip(i) || this.isSkipNoEdit(i)) continue;
            for (int j = 0; j < this.bodyFormatsCount; ++j) {
                int n4;
                TableFormatter tableFormatter = this.bodyFormats[j];
                if (!tableFormatter.isUse(i, this.getDBTableModel())) continue;
                for (n4 = 0; n4 < tableFormatter.getLocationSize(); ++n4) {
                    String string = tableFormatter.getFormat(n4);
                    stringBuilder.append(string);
                    int n5 = tableFormatter.getLocation(n4);
                    if (n5 >= 0) {
                        stringBuilder.append(this.getTypeCaseValue(tableFormatter.getType(n4), i, n5));
                        continue;
                    }
                    stringBuilder.append(tableFormatter.getSystemFormat(i, n5));
                }
                stringBuilder.append(tableFormatter.getFormat(n4));
            }
        }
        if (this.footerFormat != null) {
            stringBuilder.append(this.getTableFoot(this.footerFormat));
        }
        return stringBuilder.toString();
    }

    @Override
    public void clear() {
        super.clear();
        this.headerFormat = null;
        this.bodyFormats = null;
        this.footerFormat = null;
        this.bodyFormatsCount = 0;
    }

    @Override
    protected String getHeader() {
        if (this.headerLine == null) {
            if (this.headerFormat == null) {
                this.headerLine = "";
            } else {
                int n;
                StringBuilder stringBuilder = new StringBuilder(200);
                for (n = 0; n < this.headerFormat.getLocationSize(); ++n) {
                    stringBuilder.append(this.headerFormat.getFormat(n));
                    int n2 = this.headerFormat.getLocation(n);
                    if (n2 < 0) continue;
                    stringBuilder.append(this.getTypeCaseValue(this.headerFormat.getType(n), -1, n2));
                }
                stringBuilder.append(this.headerFormat.getFormat(n)).append(CR);
                this.headerLine = stringBuilder.toString();
            }
        }
        return this.headerLine;
    }

    @Override
    protected String getTableFoot(TableFormatter tableFormatter) {
        int n;
        tableFormatter.makeFormat(this.getDBTableModel());
        this.setFormatNoDisplay(tableFormatter);
        StringBuilder stringBuilder = new StringBuilder(200);
        for (n = 0; n < tableFormatter.getLocationSize(); ++n) {
            int n2 = tableFormatter.getLocation(n);
            if (n2 < 0) continue;
            stringBuilder.append(this.getTypeCaseValue(tableFormatter.getType(n), -1, n2));
        }
        stringBuilder.append(tableFormatter.getFormat(n)).append(CR);
        return stringBuilder.toString();
    }

    public void setFormatterList(List<TableFormatter> list) {
        this.bodyFormats = new TableFormatter[10];
        this.bodyFormatsCount = 0;
        block5: for (int i = 0; i < list.size(); ++i) {
            TableFormatter tableFormatter = list.get(i);
            switch (tableFormatter.getFormatType()) {
                case TYPE_HEAD: {
                    this.headerFormat = tableFormatter;
                    continue block5;
                }
                case TYPE_BODY: {
                    this.bodyFormats[this.bodyFormatsCount++] = tableFormatter;
                    continue block5;
                }
                case TYPE_FOOT: {
                    this.footerFormat = tableFormatter;
                    continue block5;
                }
                default: {
                    throw new HybsSystemException("FormatterType \u306e\u5b9a\u7fa9\u5916\u306e\u5024\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002");
                }
            }
        }
        if (this.bodyFormatsCount == 0) {
            if (this.headerFormat == null) {
                throw new HybsSystemException("thead \u30bf\u30b0\u304b\u3001\u307e\u305f\u306f\u3001tbody \u30bf\u30b0\u306b\u3088\u308b\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u306e\u6307\u5b9a\u306f\u5fc5\u9808\u3067\u3059\u3002");
            }
            this.bodyFormats[this.bodyFormatsCount++] = this.headerFormat;
            this.headerFormat = null;
        }
    }

    @Override
    public boolean canUseFormat() {
        return true;
    }

    public boolean isEditable() {
        return false;
    }
}

