/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBEditConfig;
import org.opengion.hayabusa.db.DBSysArg;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.db.DBUserArg;
import org.opengion.hayabusa.db.Query;
import org.opengion.hayabusa.resource.ResourceManager;

public class AbstractQuery
implements Query {
    protected static final String CR = HybsConst.CR;
    protected static final int BUFFER_MIDDLE = 200;
    private Connection connection;
    private int rtnCode = 0;
    private ErrorMessage errMessage;
    private ResourceManager resource;
    private DBTableModel table;
    private String stmtString;
    private int executeCount = -1;
    private int skipRowCount;
    private int maxRowCount = HybsSystem.sysInt("DB_MAX_ROW_COUNT");
    private boolean updateFlag = true;
    private DBEditConfig config;
    protected static final int DB_MAX_QUERY_TIMEOUT = HybsSystem.sysInt("DB_MAX_QUERY_TIMEOUT");
    protected static final int DB_FETCH_SIZE = 251;
    public static final String ARG_ARRAY = "ARG_ARRAY";
    public static final String SYSARG_ARRAY = "SYSARG_ARRAY";
    public static final String ERR_MSG = "ERR_MSG";
    public static final String ERR_MSG_ARRAY = "ERR_MSG_ARRAY";
    private String updQuery;
    private String insQuery;

    protected AbstractQuery() {
    }

    @Override
    public void setConnection(Connection connection) {
        if (connection == null) {
            String string = "Connection \u306b null \u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002" + CR;
            throw new HybsSystemException(string);
        }
        this.connection = connection;
    }

    @Override
    public void setStatement(String string) {
        this.stmtString = string.trim();
    }

    @Override
    public String getStatement() {
        return this.stmtString;
    }

    @Override
    public void setMergeStatement(String string, String string2) {
        this.updQuery = string;
        this.insQuery = string2;
    }

    @Override
    public String[] getMergeStatement() {
        return new String[]{this.updQuery, this.insQuery};
    }

    @Override
    public void execute(String ... stringArray) {
        throw new UnsupportedOperationException("\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002execute( String... )");
    }

    @Override
    public void execute(String[] stringArray, String ... stringArray2) {
        throw new UnsupportedOperationException("\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002execute( String[],String... )");
    }

    @Override
    public void execute(String string, String string2, DBSysArg[] dBSysArgArray, DBUserArg[] dBUserArgArray) {
        throw new UnsupportedOperationException("\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002execute( String,String,DBSysArg[],DBUserArg[] )");
    }

    @Override
    public void execute(int[] nArray, DBTableModel dBTableModel) {
        throw new UnsupportedOperationException("\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002execute( final int[] rowNo, final DBTableModel table )");
    }

    protected void setExecuteCount(int n) {
        this.executeCount = n;
    }

    @Override
    public int getExecuteCount() {
        return this.executeCount;
    }

    protected void setDBTableModel(DBTableModel dBTableModel) {
        this.table = dBTableModel;
    }

    @Override
    public DBTableModel getDBTableModel() {
        return this.table;
    }

    @Override
    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    @Override
    public void setMaxRowCount(int n) {
        this.maxRowCount = n > 0 ? n : Integer.MAX_VALUE;
    }

    @Override
    public int getSkipRowCount() {
        return this.skipRowCount;
    }

    @Override
    public void setSkipRowCount(int n) {
        this.skipRowCount = n;
    }

    protected void setUpdateFlag(boolean bl) {
        this.updateFlag = bl;
    }

    @Override
    public boolean isUpdate() {
        return this.updateFlag;
    }

    @Override
    public void setResourceManager(ResourceManager resourceManager) {
        this.resource = resourceManager;
    }

    @Override
    public int getErrorCode() {
        return this.rtnCode;
    }

    protected void setErrorCode(int n) {
        this.rtnCode = n;
    }

    @Override
    public ErrorMessage getErrorMessage() {
        return this.errMessage;
    }

    protected void setErrorMessage(ErrorMessage errorMessage) {
        this.errMessage = errorMessage;
    }

    @Override
    public void setEditConfig(DBEditConfig dBEditConfig) {
        this.config = dBEditConfig;
    }

    protected DBEditConfig getEditConfig() {
        return this.config;
    }

    protected void createTableModel(ResultSet resultSet) {
        try {
            this.table = this.config == null ? DBTableModelUtil.makeDBTable(resultSet, this.getSkipRowCount(), this.maxRowCount, this.resource) : DBTableModelUtil.makeEditDBTable(resultSet, this.getSkipRowCount(), this.maxRowCount, this.resource, this.config);
            this.setExecuteCount(this.table.getRowCount());
        }
        catch (SQLException sQLException) {
            throw new HybsSystemException("\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", sQLException);
        }
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected boolean useParameterMetaData() {
        try {
            return "PostgreSQL".equalsIgnoreCase(this.connection.getMetaData().getDatabaseProductName());
        }
        catch (Throwable throwable) {
            System.err.println(ThrowUtil.ogStackTrace((Throwable)throwable));
            return false;
        }
    }

    public String toString() {
        return "LastQuery  :[" + this.getStatement() + "] ";
    }
}

