/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;

public final class HybsFileFilter
implements FileFilter {
    private final List<FileFilter> listF = new ArrayList<FileFilter>();
    private final List<FileFilter> listD = new ArrayList<FileFilter>();
    private final boolean ignoreCase;
    private final boolean notEquals;

    public HybsFileFilter() {
        this(true, false);
    }

    public HybsFileFilter(boolean bl) {
        this(bl, false);
    }

    public HybsFileFilter(boolean bl, boolean bl2) {
        this.ignoreCase = bl;
        this.notEquals = bl2;
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            List<FileFilter> list = file.isFile() ? this.listF : this.listD;
            for (FileFilter fileFilter : list) {
                if (fileFilter.accept(file)) continue;
                return false;
            }
        }
        return true;
    }

    public HybsFileFilter startsWith(String string) {
        return this.startsWith(string, this.notEquals);
    }

    public HybsFileFilter startsWith(String string3, boolean bl) {
        if (string3 != null) {
            DefaultFilter defaultFilter = new DefaultFilter(string3, bl, this.ignoreCase);
            defaultFilter.setPred((string, string2) -> string.startsWith((String)string2));
            this.listF.add(defaultFilter);
        }
        return this;
    }

    public HybsFileFilter startsDir(String string) {
        return this.startsDir(string, this.notEquals);
    }

    public HybsFileFilter startsDir(String string3, boolean bl) {
        if (string3 != null) {
            DefaultFilter defaultFilter = new DefaultFilter(string3, bl, this.ignoreCase);
            defaultFilter.setPred((string, string2) -> string.startsWith((String)string2));
            this.listD.add(defaultFilter);
        }
        return this;
    }

    public HybsFileFilter endsWith(String string) {
        return this.endsWith(string, this.notEquals);
    }

    public HybsFileFilter endsWith(String string3, boolean bl) {
        if (string3 != null) {
            DefaultFilter defaultFilter = new DefaultFilter(string3, bl, this.ignoreCase);
            defaultFilter.setPred((string, string2) -> string.endsWith((String)string2));
            this.listF.add(defaultFilter);
        }
        return this;
    }

    public HybsFileFilter instr(String string) {
        return this.instr(string, this.notEquals);
    }

    public HybsFileFilter instr(String string3, boolean bl) {
        if (string3 != null) {
            DefaultFilter defaultFilter = new DefaultFilter(string3, bl, this.ignoreCase);
            defaultFilter.setPred((string, string2) -> string.contains((CharSequence)string2));
            this.listF.add(defaultFilter);
        }
        return this;
    }

    public HybsFileFilter instrDir(String string) {
        return this.instrDir(string, this.notEquals);
    }

    public HybsFileFilter instrDir(String string3, boolean bl) {
        if (string3 != null) {
            DefaultFilter defaultFilter = new DefaultFilter(string3, bl, this.ignoreCase);
            defaultFilter.setPred((string, string2) -> string.contains((CharSequence)string2));
            this.listD.add(defaultFilter);
        }
        return this;
    }

    public HybsFileFilter fileEquals(String string) {
        return this.fileEquals(string, false);
    }

    public HybsFileFilter fileEquals(String string3, boolean bl) {
        if (string3 != null) {
            DefaultFilter defaultFilter = new DefaultFilter(string3, bl, this.ignoreCase);
            defaultFilter.setPred((string, string2) -> string.equals(string2));
            this.listF.add(defaultFilter);
        }
        return this;
    }

    public HybsFileFilter matches(String string) {
        return this.matches(string, this.notEquals);
    }

    public HybsFileFilter matches(String string, boolean bl) {
        if (string != null) {
            Pattern pattern = this.ignoreCase ? Pattern.compile(string, 2) : Pattern.compile(string);
            this.listF.add(file -> pattern.matcher(file.getName()).find() ^ bl);
        }
        return this;
    }

    public HybsFileFilter matchDir(String string) {
        return this.matchDir(string, this.notEquals);
    }

    public HybsFileFilter matchDir(String string, boolean bl) {
        if (string != null) {
            Pattern pattern = this.ignoreCase ? Pattern.compile(string, 2) : Pattern.compile(string);
            this.listD.add(file -> pattern.matcher(file.getName()).find() ^ bl);
        }
        return this;
    }

    public HybsFileFilter lastModified(String string) {
        return this.lastModified(string, this.notEquals);
    }

    public HybsFileFilter lastModified(String string, boolean bl) {
        if (string != null) {
            long l = HybsFileFilter.modifyTime(string);
            this.listF.add(file -> file.lastModified() >= l ^ bl);
        }
        return this;
    }

    private static long modifyTime(String string) {
        if (string == null) {
            throw new OgRuntimeException("ModifyTime Error! modify valus is not null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        if ("YESTERDAY".equalsIgnoreCase(string)) {
            calendar.add(5, -1);
        } else if ("LAST_WEEK".equalsIgnoreCase(string)) {
            calendar.add(5, -7);
        } else if ("MONTH".equalsIgnoreCase(string)) {
            calendar.set(5, 1);
        } else if ("LAST_MONTH".equalsIgnoreCase(string)) {
            calendar.add(2, -1);
        } else if ("LAST_YEAR".equalsIgnoreCase(string)) {
            calendar.add(1, -1);
        } else if (string.length() == 8) {
            calendar.set(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)));
        } else if (!"TODAY".equalsIgnoreCase(string)) {
            String string2 = "ModifyFileFilter Error! modify Format [" + string + "]" + HybsConst.CR + "\u65e5\u4ed8\u3051\u306e\u6307\u5b9a\u65b9\u6cd5\u306b\u306f\u3001\u5b9f\u65e5\u4ed8\u3051(YYYYMMDD\u5f62\u5f0f \u4f8b\uff1a20040323)\u3068" + HybsConst.CR + "\u4eee\u60f3\u65e5\u4ed8\u3051(TODAY,YESTERDAY \u306a\u3069)\u304c\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002" + HybsConst.CR + "    YYYYMMDD   YYYYMMDD\u5f62\u5f0f\u306e\u6307\u5b9a\u65e5\u306e 00:00:00 \u3092\u57fa\u6e96\u6642\u523b" + HybsConst.CR + "    TODAY      \u5b9f\u884c\u65e5\u306e 00:00:00 \u3092\u57fa\u6e96\u6642\u523b" + HybsConst.CR + "    YESTERDAY  \u5b9f\u884c\u65e5\u524d\u65e5\u306e 00:00:00 \u3092\u57fa\u6e96\u6642\u523b" + HybsConst.CR + "    LAST_WEEK  \u5b9f\u884c\u65e5\u306e\u5148\u9031(7\u65e5\u524d) 00:00:00 \u3092\u57fa\u6e96\u6642\u523b" + HybsConst.CR + "    MONTH      \u5b9f\u884c\u6708\u306e 1\u65e5 00:00:00 \u3092\u57fa\u6e96\u6642\u523b" + HybsConst.CR + "    LAST_MONTH \u5b9f\u884c\u524d\u6708\u306e \u540c\u65e5 00:00:00 \u3092\u57fa\u6e96\u6642\u523b" + HybsConst.CR + "    LAST_YEAR  \u5b9f\u884c\u524d\u5e74\u306e \u540c\u6708\u540c\u65e5 00:00:00 \u3092\u57fa\u6e96\u6642\u523b" + HybsConst.CR;
            throw new OgRuntimeException(string2);
        }
        return calendar.getTimeInMillis();
    }

    private static long getByteSize(String string) {
        if (string == null) {
            return -1L;
        }
        String string2 = string;
        int n = string2.length();
        if (n > 0 && 'B' == string2.charAt(n - 1)) {
            string2 = string2.substring(0, n - 1);
            --n;
        }
        long l = -1L;
        long l2 = -1L;
        if (n > 0) {
            char c = string2.charAt(n - 1);
            switch (c) {
                case 'K': {
                    l2 = 1024L;
                    break;
                }
                case 'M': {
                    l2 = 0x100000L;
                    break;
                }
                case 'G': {
                    l2 = 0x40000000L;
                    break;
                }
            }
            if (l2 > 0L) {
                string2 = string2.substring(0, n - 1);
                --n;
            } else {
                l2 = 1L;
            }
        }
        if (n > 0) {
            l = l2 * Long.parseLong(string2);
        }
        return l;
    }

    public HybsFileFilter isLarger(String string) {
        long l = HybsFileFilter.getByteSize(string);
        if (l >= 0L) {
            this.listF.add(file -> file.length() >= l);
        }
        return this;
    }

    public HybsFileFilter isSmaller(String string) {
        long l = HybsFileFilter.getByteSize(string);
        if (l >= 0L) {
            this.listF.add(file -> file.length() < l);
        }
        return this;
    }

    public HybsFileFilter isHidden(String string) {
        return this.isHidden(string, this.notEquals);
    }

    public HybsFileFilter isHidden(String string, boolean bl) {
        if (string != null) {
            boolean bl2 = Boolean.parseBoolean(string);
            this.listF.add(file -> file.isHidden() ^ !bl2 ^ bl);
        }
        return this;
    }

    private static final class DefaultFilter
    implements FileFilter {
        private final String[] tkens;
        private final int cnt;
        private final boolean rvse;
        private final boolean igCase;
        private BiPredicate<String, String> biPred = (string, string2) -> true;

        DefaultFilter(String string3, boolean bl, boolean bl2) {
            this.rvse = bl;
            this.igCase = bl2;
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
            this.cnt = stringTokenizer.countTokens();
            this.tkens = new String[this.cnt];
            for (int i = 0; i < this.cnt; ++i) {
                String string4 = stringTokenizer.nextToken();
                this.tkens[i] = this.igCase ? string4.toLowerCase(Locale.JAPAN) : string4;
            }
        }

        public void setPred(BiPredicate<String, String> biPredicate) {
            this.biPred = biPredicate;
        }

        @Override
        public boolean accept(File file) {
            if (this.biPred != null) {
                String string = file.getName();
                String string2 = this.igCase ? string.toLowerCase(Locale.JAPAN) : string;
                for (int i = 0; i < this.cnt; ++i) {
                    if (!this.biPred.test(string2, this.tkens[i])) continue;
                    return !this.rvse;
                }
            }
            return this.rvse;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200).append(this.getClass()).append(':').append(" tokens=").append(Arrays.toString(this.tkens)).append(" reverse=").append(this.rvse).append(" ignoreCase=").append(this.igCase);
            return stringBuilder.toString();
        }
    }
}

