/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.opengion.fukurou.fileexec.FileUtil;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.PathMatcherSet;
import org.opengion.fukurou.fileexec.XLogger;

public class DirWatch
implements Runnable {
    private static final XLogger LOGGER = XLogger.getLogger(DirWatch.class.getSimpleName());
    public static final long INIT_DELAY = 10L;
    public static final long PERIOD = 30L;
    public static final long TIME_DIFF = 10L;
    private final Path sPath;
    private final boolean useTree;
    private Consumer<Path> action = path -> System.out.println("DirWatch Path=" + path);
    private final PathMatcherSet pathMchSet = new PathMatcherSet();
    private DirectoryStream.Filter<Path> filter;
    private ScheduledFuture<?> stFuture;
    private ScheduledExecutorService scheduler;
    private boolean isError;
    private final Set<Path> pathSet = new HashSet<Path>();

    public DirWatch(Path path) {
        this(path, false);
    }

    public DirWatch(Path path2, boolean bl) {
        this.sPath = path2;
        this.useTree = bl;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMchSet.addPathMatcher(pathMatcher);
    }

    public void setPathEndsWith(String ... stringArray) {
        this.pathMchSet.addEndsWith(stringArray);
    }

    public void callback(Consumer<Path> consumer) {
        if (consumer != null) {
            this.action = consumer;
        }
    }

    public void start() {
        this.start(10L, 30L, 10L);
    }

    public void start(long l, long l2, long l3) {
        LOGGER.debug(() -> "DirWatch Start: " + this.sPath + " Tree=" + this.useTree + " Delay=" + l + " Period=" + l2 + " TimeDiff=" + l3);
        this.filter = path -> Files.isDirectory(path, new LinkOption[0]) || this.pathMchSet.matches((Path)path) && l3 * 1000L < System.currentTimeMillis() - path.toFile().lastModified();
        if (this.scheduler == null) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
        }
        this.stFuture = this.scheduler.scheduleAtFixedRate(this, l, l2, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.stFuture != null && !this.stFuture.isDone()) {
            LOGGER.info(() -> "DirWatch Stop: [" + this.sPath + "]");
            this.stFuture.cancel(true);
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
    }

    public boolean isErrorStatus() {
        return this.isError;
    }

    @Override
    public void run() {
        try {
            LOGGER.debug(() -> "DirWatch Running: " + this.sPath + " Tree=" + this.useTree);
            if (FileUtil.exists(this.sPath)) {
                this.execute(this.sPath);
                this.isError = false;
            } else {
                this.isError = true;
                String string = "DirWatch#run : sPath=" + this.sPath;
                LOGGER.warning("MSG0002", string);
                this.stop();
            }
        }
        catch (Throwable throwable) {
            this.isError = true;
            String string = "DirWatch#run : Path=" + this.sPath;
            LOGGER.warning(throwable, "MSG0021", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Path path) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, this.filter);){
            LOGGER.debug(() -> "DirWatch execute: " + path);
            for (Path path2 : directoryStream) {
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    if (!this.useTree) continue;
                    this.execute(path2);
                    continue;
                }
                Consumer<Path> consumer = this.action;
                synchronized (consumer) {
                    if (this.setAdd(path2)) {
                        this.action.accept(path2);
                    }
                }
            }
            this.setClear();
        }
        catch (IOException iOException) {
            throw MsgUtil.throwException(iOException, "MSG0005", path);
        }
    }

    public boolean setAdd(Path path) {
        return this.pathSet.add(path);
    }

    public void setClear() {
        this.pathSet.clear();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.sPath + " , Tree=[" + this.useTree + "]";
    }
}

