/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.StringUtil;

public final class ColorMap {
    public static final String VIVID = "VIVID";
    public static final String PASTEL = "PASTEL";
    private static final String[] VIVID_KEY;
    private static final String[] PSTL_KEY;
    private static final String[] COLOR_KEY;
    private static final Map<String, String> CLR_MAP;

    private ColorMap() {
    }

    public static Color getColorInstance(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            String string3 = "\u8272\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + HybsConst.CR + "ColorMap=" + CLR_MAP.keySet().toString();
            throw new OgRuntimeException(string3);
        }
        if (string.charAt(0) == '#') {
            string2 = string;
        } else {
            String string4 = string.replaceAll("_", "").toUpperCase(Locale.JAPAN);
            string2 = CLR_MAP.get(string4);
            if (string2 == null) {
                try {
                    return ColorMap.getColorInstance(Integer.parseInt(string4));
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = "\u6307\u5b9a\u306e\u8272\u30b3\u30fc\u30c9\u306f\u30ab\u30e9\u30fc\u30de\u30c3\u30d7\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 Color=[" + string + "]" + HybsConst.CR + "ColorMap=" + CLR_MAP.keySet().toString();
                    throw new OgRuntimeException(string5, numberFormatException);
                }
            }
        }
        try {
            return Color.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string6 = "\u6307\u5b9a\u306e\u8272\u30b3\u30fc\u30c9\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u7570\u306a\u308a\u307e\u3059(#XXXXXX\u5f62\u5f0f\u306e16bitRGB\u8868\u8a18) Color=[" + string + "]";
            throw new OgRuntimeException(string6, numberFormatException);
        }
    }

    public static Color getColorInstance(int n) {
        try {
            return Color.decode(COLOR_KEY[n % COLOR_KEY.length]);
        }
        catch (NumberFormatException numberFormatException) {
            String string = "\u6307\u5b9a\u306e\u8272\u756a\u53f7\u306e\u5185\u90e8\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u30a8\u30e9\u30fc\u3067\u3059\u3002no=[" + n + "] , code=[" + COLOR_KEY[n % COLOR_KEY.length] + "]";
            throw new OgRuntimeException(string, numberFormatException);
        }
    }

    public static String getColorKey(int n) {
        return COLOR_KEY[n % COLOR_KEY.length];
    }

    public static String getColorKey(String string) {
        return ColorMap.getColorKey(string, null);
    }

    public static String getColorKey(String string, String string2) {
        return CLR_MAP.getOrDefault(string, string2);
    }

    public static String[] getColorKeys() {
        return (String[])COLOR_KEY.clone();
    }

    public static String[] getColorKeys(String string) {
        String[] stringArray;
        if (string == null || string.isEmpty()) {
            stringArray = ColorMap.getColorKeys();
        } else if (VIVID.equalsIgnoreCase(string)) {
            stringArray = ColorMap.getVividKeys();
        } else if (PASTEL.equalsIgnoreCase(string)) {
            stringArray = ColorMap.getPastelKeys();
        } else {
            stringArray = StringUtil.csv2Array(string);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ColorMap.getColorKey(stringArray[i], stringArray[i]);
            }
        }
        return stringArray;
    }

    public static String[] getVividKeys() {
        return (String[])VIVID_KEY.clone();
    }

    public static String[] getPastelKeys() {
        return (String[])PSTL_KEY.clone();
    }

    static {
        int n;
        VIVID_KEY = new String[]{"#0000FF", "#00FF00", "#FF0000", "#00FFFF", "#FFFF00", "#FF00FF", "#00FF7F", "#FF7F00", "#7F00FF", "#007FFF", "#7FFF00", "#FF007F"};
        PSTL_KEY = new String[]{"#7F7FFF", "#7FFF7F", "#FF7F7F", "#7FFFFF", "#FFFF7F", "#FF7FFF", "#7FFFBF", "#FFBF7F", "#BF7FFF", "#7FBFFF", "#BFFF7F", "#FF7FBF"};
        COLOR_KEY = new String[VIVID_KEY.length + PSTL_KEY.length];
        System.arraycopy(VIVID_KEY, 0, COLOR_KEY, 0, VIVID_KEY.length);
        System.arraycopy(PSTL_KEY, 0, COLOR_KEY, VIVID_KEY.length, PSTL_KEY.length);
        CLR_MAP = new HashMap<String, String>();
        CLR_MAP.put("BLUE", "#0000FF");
        CLR_MAP.put("CYAN", "#00FFFF");
        CLR_MAP.put("GRAY", "#808080");
        CLR_MAP.put("GREEN", "#008000");
        CLR_MAP.put("LIGHTGRAY", "#D3D3D3");
        CLR_MAP.put("MAGENTA", "#FF00FF");
        CLR_MAP.put("DARKGRAY", "#A9A9A9");
        CLR_MAP.put("ORANGE", "#FFA500");
        CLR_MAP.put("PINK", "#FFC0CB");
        CLR_MAP.put("RED", "#FF0000");
        CLR_MAP.put("YELLOW", "#FFFF00");
        CLR_MAP.put("LIME", "#00FF00");
        CLR_MAP.put("AQUA", "#00FFFF");
        CLR_MAP.put("SILVER", "#C0C0C0");
        CLR_MAP.put("MAROON", "#800000");
        CLR_MAP.put("OLIVE", "#808000");
        CLR_MAP.put("TEAL", "#008080");
        CLR_MAP.put("NAVY", "#000080");
        CLR_MAP.put("FUCHSIA", "#FF00FF");
        CLR_MAP.put("PURPLE", "#800080");
        CLR_MAP.put("WHITE", "#FFFFFF");
        CLR_MAP.put("BLACK", "#000000");
        CLR_MAP.put("TRANSPARENT", "rgba( 255,255,255,0 )");
        CLR_MAP.put("ALICEBLUE", "#F0F8FF");
        CLR_MAP.put("ANTIQUEWHITE", "#FAEBD7");
        CLR_MAP.put("AQUAMARINE", "#7FFFD4");
        CLR_MAP.put("AZURE", "#F0FFFF");
        CLR_MAP.put("BEIGE", "#F5F5DC");
        CLR_MAP.put("BISQUE", "#FFE4C4");
        CLR_MAP.put("BLANCHEDALMOND", "#FFEBCD");
        CLR_MAP.put("BLUEVIOLET", "#8A2BE2");
        CLR_MAP.put("BROWN", "#A52A2A");
        CLR_MAP.put("BURLYWOOD", "#DEB887");
        CLR_MAP.put("CADETBLUE", "#5F9EA0");
        CLR_MAP.put("CHARTREUSE", "#7FFF00");
        CLR_MAP.put("CHOCOLATE", "#D2691E");
        CLR_MAP.put("CORAL", "#FF7F50");
        CLR_MAP.put("CORNFLOWERBLUE", "#6495ED");
        CLR_MAP.put("CORNSILK", "#FFF8DC");
        CLR_MAP.put("CRIMSON", "#DC143C");
        CLR_MAP.put("DARKBLUE", "#00008B");
        CLR_MAP.put("DARKCYAN", "#008B8B");
        CLR_MAP.put("DARKGOLDENROD", "#B8860B");
        CLR_MAP.put("DARKGREEN", "#006400");
        CLR_MAP.put("DARKKHAKI", "#BDB76B");
        CLR_MAP.put("DARKMAGENTA", "#8B008B");
        CLR_MAP.put("DARKOLIVEGREEN", "#556B2F");
        CLR_MAP.put("DARKORANGE", "#FF8C00");
        CLR_MAP.put("DARKORCHID", "#9932CC");
        CLR_MAP.put("DARKRED", "#8B0000");
        CLR_MAP.put("DARKSALMON", "#E9967A");
        CLR_MAP.put("DARKSEAGREEN", "#8FBC8F");
        CLR_MAP.put("DARKSLATEBLUE", "#483D8B");
        CLR_MAP.put("DARKSLATEGRAY", "#2F4F4F");
        CLR_MAP.put("DARKTURQUOISE", "#00CED1");
        CLR_MAP.put("DARKVIOLET", "#9400D3");
        CLR_MAP.put("DEEPPINK", "#FF1493");
        CLR_MAP.put("DEEPSKYBLUE", "#00BFFF");
        CLR_MAP.put("DIMGRAY", "#696969");
        CLR_MAP.put("DODGERBLUE", "#1E90FF");
        CLR_MAP.put("FIREBRICK", "#B22222");
        CLR_MAP.put("FLORALWHITE", "#FFFAF0");
        CLR_MAP.put("FORESTGREEN", "#228B22");
        CLR_MAP.put("GAINSBORO", "#DCDCDC");
        CLR_MAP.put("GHOSTWHITE", "#F8F8FF");
        CLR_MAP.put("GOLD", "#FFD700");
        CLR_MAP.put("GOLDENROD", "#DAA520");
        CLR_MAP.put("GREENYELLOW", "#ADFF2F");
        CLR_MAP.put("HONEYDEW", "#F0FFF0");
        CLR_MAP.put("HOTPINK", "#FF69B4");
        CLR_MAP.put("INDIANRED", "#CD5C5C");
        CLR_MAP.put("INDIGO", "#4B0082");
        CLR_MAP.put("IVORY", "#FFFFF0");
        CLR_MAP.put("KHAKI", "#F0E68C");
        CLR_MAP.put("LAVENDER", "#E6E6FA");
        CLR_MAP.put("LAVENDERBLUSH", "#FFF0F5");
        CLR_MAP.put("LAWNGREEN", "#7CFC00");
        CLR_MAP.put("LEMONCHIFFON", "#FFFACD");
        CLR_MAP.put("LIGHTBLUE", "#ADD8E6");
        CLR_MAP.put("LIGHTCORAL", "#F08080");
        CLR_MAP.put("LIGHTCYAN", "#E0FFFF");
        CLR_MAP.put("LIGHTGOLDENRODYELLOW", "#FAFAD2");
        CLR_MAP.put("LIGHTGREEN", "#90EE90");
        CLR_MAP.put("LIGHTPINK", "#FFB6C1");
        CLR_MAP.put("LIGHTSALMON", "#FFA07A");
        CLR_MAP.put("LIGHTSEAGREEN", "#20B2AA");
        CLR_MAP.put("LIGHTSKYBLUE", "#87CEFA");
        CLR_MAP.put("LIGHTSLATEGRAY", "#778899");
        CLR_MAP.put("LIGHTSTEELBLUE", "#B0C4DE");
        CLR_MAP.put("LIGHTYELLOW", "#FFFFE0");
        CLR_MAP.put("LIMEGREEN", "#32CD32");
        CLR_MAP.put("LINEN", "#FAF0E6");
        CLR_MAP.put("MEDIUMAQUAMARINE", "#66CDAA");
        CLR_MAP.put("MEDIUMBLUE", "#0000CD");
        CLR_MAP.put("MEDIUMORCHID", "#BA55D3");
        CLR_MAP.put("MEDIUMPURPLE", "#9370DB");
        CLR_MAP.put("MEDIUMSEAGREEN", "#3CB371");
        CLR_MAP.put("MEDIUMSLATEBLUE", "#7B68EE");
        CLR_MAP.put("MEDIUMSPRINGGREEN", "#00FA9A");
        CLR_MAP.put("MEDIUMTURQUOISE", "#48D1CC");
        CLR_MAP.put("MEDIUMVIOLETRED", "#C71585");
        CLR_MAP.put("MIDNIGHTBLUE", "#191970");
        CLR_MAP.put("MINTCREAM", "#F5FFFA");
        CLR_MAP.put("MISTYROSE", "#FFE4E1");
        CLR_MAP.put("MOCCASIN", "#FFE4B5");
        CLR_MAP.put("NAVAJOWHITE", "#FFDEAD");
        CLR_MAP.put("OLDLACE", "#FDF5E6");
        CLR_MAP.put("OLIVEDRAB", "#6B8E23");
        CLR_MAP.put("ORANGERED", "#FF4500");
        CLR_MAP.put("ORCHID", "#DA70D6");
        CLR_MAP.put("PALEGOLDENROD", "#EEE8AA");
        CLR_MAP.put("PALEGREEN", "#98FB98");
        CLR_MAP.put("PALETURQUOISE", "#AFEEEE");
        CLR_MAP.put("PALEVIOLETRED", "#DB7093");
        CLR_MAP.put("PAPAYAWHIP", "#FFEFD5");
        CLR_MAP.put("PEACHPUFF", "#FFDAB9");
        CLR_MAP.put("PERU", "#CD853F");
        CLR_MAP.put("PLUM", "#DDA0DD");
        CLR_MAP.put("POWDERBLUE", "#B0E0E6");
        CLR_MAP.put("ROSYBROWN", "#BC8F8F");
        CLR_MAP.put("ROYALBLUE", "#4169E1");
        CLR_MAP.put("SADDLEBROWN", "#8B4513");
        CLR_MAP.put("SALMON", "#FA8072");
        CLR_MAP.put("SANDYBROWN", "#F4A460");
        CLR_MAP.put("SEAGREEN", "#2E8B57");
        CLR_MAP.put("SEASHELL", "#FFF5EE");
        CLR_MAP.put("SIENNA", "#A0522D");
        CLR_MAP.put("SKYBLUE", "#87CEEB");
        CLR_MAP.put("SLATEBLUE", "#6A5ACD");
        CLR_MAP.put("SLATEGRAY", "#708090");
        CLR_MAP.put("SNOW", "#FFFAFA");
        CLR_MAP.put("SPRINGGREEN", "#00FF7F");
        CLR_MAP.put("STEELBLUE", "#4682B4");
        CLR_MAP.put("TAN", "#D2B48C");
        CLR_MAP.put("THISTLE", "#D8BFD8");
        CLR_MAP.put("TOMATO", "#FF6347");
        CLR_MAP.put("TURQUOISE", "#40E0D0");
        CLR_MAP.put("VIOLET", "#EE82EE");
        CLR_MAP.put("WHEAT", "#F5DEB3");
        CLR_MAP.put("WHITESMOKE", "#F5F5F5");
        CLR_MAP.put("YELLOWGREEN", "#9ACD32");
        int n2 = 0;
        for (n = 0; n < VIVID_KEY.length; ++n) {
            CLR_MAP.put(String.valueOf(n2++), VIVID_KEY[n]);
            CLR_MAP.put("V" + n, VIVID_KEY[n]);
        }
        for (n = 0; n < PSTL_KEY.length; ++n) {
            CLR_MAP.put(String.valueOf(n2++), PSTL_KEY[n]);
            CLR_MAP.put("P" + n, PSTL_KEY[n]);
        }
        CLR_MAP.put(VIVID, VIVID_KEY[0]);
        CLR_MAP.put(PASTEL, PSTL_KEY[0]);
    }
}

