<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0002"
	title    = "画面"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
>
	5.5.1.5 (2012/04/12) Takahashi Masakazu **はSEQ再セットしない
	5.7.7.3 (2014/06/27) Takahashi Masakazu 削除時条件追加
</og:comment>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />

<og:entry command="{@command}">
	<og:columnSet command="{@command}" columnId="CLM"			action="TBLSET"	value="[GUIKEY]" />
	<og:columnSet command="{@command}" columnId="EXIST_GEA08"	action="SET"	value="0" />
	<og:columnSet command="{@command}" columnId="KBLBL"			action="SET"	value="4" conditionKey="GUILVL" conditionList="1|2"  />
</og:entry>

<og:tableFilter classId="DBSELECT" dbid="{@MEM.TO_DBID}">
	select '1' EXIST_GEA08, A.UNIQ UNIQ_GEA08
	from GEA08 A
	where A.SYSTEM_ID = [SYSTEM_ID]
	and   A.CLM       = [CLM]
	and   A.KBSAKU    = [KBSAKU]
	and   A.LANG      = [LANG]
	and   A.FGJ      in ('0','1')
	order by A.SYSTEM_ID DESC, A.KBSAKU DESC
</og:tableFilter>
<og:equals val1="COPY|MODIFY|INSERT" val2="{@sqlType}" contains="true">
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		queryType		= "JDBCTableUpdate"
		conditionKey	= "EXIST_GEA08"
		conditionList	= "0"
		commitTableModel= "false">
		<og:tableUpdateParam
			sqlType		= "INSERT"
			table		= "GEA08"
			names		= "CLM,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,KBLBL,SYSTEM_ID,LANG,RELEASE_NOTES,CDKH,RDC_CODE"
			constKeys	= "FGLOAD"
			constVals	= "1"
		/>
	</og:tableUpdate>
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		queryType		= "JDBCTableUpdate"
		conditionKey	= "EXIST_GEA08"
		conditionList	= "1"
		commitTableModel= "false">
		<og:tableUpdateParam
			sqlType		= "UPDATE"
			table		= "GEA08"
			where		= "UNIQ=[UNIQ_GEA08] AND SYSTEM_ID=[SYSTEM_ID]"
			names		= "CLM,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,KBLBL,SYSTEM_ID,LANG,RELEASE_NOTES,CDKH,RDC_CODE"
			constKeys	= "FGLOAD"
			constVals	= "1"
		/>
	</og:tableUpdate>
</og:equals>

<og:equals val1="DELETE" val2="{@sqlType}">
	<!-- 5.7.7.3 (2014/06/27) まだGEA11が他に存在する場合は削除しない。 -->
	<og:tableFilter classId="DBSELECT" dbid="{@MEM.TO_DBID}">
		select '0' EXIST_GEA08
		from GEA11 A
		where A.SYSTEM_ID = [SYSTEM_ID]
		and A.GUIKEY      = [GUIKEY]
		and A.KBSAKU      = [KBSAKU]
		and A.FGJ        in ('0','1')
		and A.UNIQ       != [UNIQ]
	</og:tableFilter>
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		queryType		= "JDBCTableUpdate"
		conditionKey	= "EXIST_GEA08"
		conditionList	= "1"
		commitTableModel= "false">
		<og:tableUpdateParam
			sqlType			= "{@sqlType}"
			table			= "GEA08"
			where			= "UNIQ=[UNIQ_GEA08] AND SYSTEM_ID=[SYSTEM_ID]"
			names			= "CDKH"
			logicalDelete	= "{@logicalDelete}"
		/>
	</og:tableUpdate>
</og:equals>

<og:tableUpdate
	dbid			= "{@MEM.TO_DBID}"
	command			= "{@command}"
	queryType		= "JDBCTableUpdate">
	<og:tableUpdateParam
		sqlType			= "{@sqlType}"
		table			= "GEA11"
		where			= "UNIQ=[UNIQ] AND SYSTEM_ID=[SYSTEM_ID]"
		names			= "GUIKEY,ADDRESS,SEQNO,GUILVL,NAME_JA,LABEL_CLM,GROUPS,ROLES,RWMODE,KBLINK,TARGET,PARAM,SYSTEM_ID,KBSAKU,COMMENTS,RELEASE_NOTES,CDKH,RDC_CODE"
		logicalDelete	= "{@logicalDelete}"
	/>
</og:tableUpdate>

<!-- SEQNOの再セット -->
<og:query
	dbid 		= "{@MEM.TO_DBID}"
	command		= "NEW"
	maxRowCount	= "0" >
		SELECT SEQNO,GUILVL,UNIQ
		FROM   GEA11
		WHERE  SYSTEM_ID IN ('{@MEM.SYSTEM_ID}','{@U_BASE}')
		AND    FGJ       IN ( '0','1' )
		ORDER  BY SEQNO,KBSAKU
</og:query>
<og:tableFilter classId="SEQRESET" keys="SEQ_CLM,BREAK_CLM" vals="SEQNO,GUILVL" selectedAll="true" />
<og:tableUpdate
	dbid 		= "{@MEM.TO_DBID}"
	command		= "{@command}"
	selectedAll = "true"
	queryType	= "JDBCTableUpdate" >
		UPDATE GEA11 SET
			SEQNO  = [SEQNO]
		WHERE UNIQ = [UNIQ]
		AND SEQNO != [SEQNO]
		AND SYSTEM_ID IN ('{@MEM.SYSTEM_ID}','{@U_BASE}')
</og:tableUpdate>

<!-- リソースキャッシュのクリア -->
<og:engine guiClear="true" />

<!--他システムIDのリソース更新ここから-->
<og:value command="SET" key="remocommand" value="GUI"/>
<jsp:directive.include file="/jsp/common/remoteResource.jsp" />
<!--他システムリソース更新ここまで-->

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
